/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.acs.commons.replication.dispatcher.impl;

import com.adobe.acs.commons.replication.dispatcher.DispatcherFlushFilter;
import com.adobe.acs.commons.replication.dispatcher.DispatcherFlushRules;
import com.adobe.acs.commons.replication.dispatcher.DispatcherFlusher;
import com.adobe.acs.commons.util.ParameterUtil;
import com.day.cq.replication.AgentManager;
import com.day.cq.replication.Preprocessor;
import com.day.cq.replication.ReplicationAction;
import com.day.cq.replication.ReplicationActionType;
import com.day.cq.replication.ReplicationException;
import com.day.cq.replication.ReplicationOptions;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang.StringUtils;
import org.apache.felix.scr.annotations.Activate;
import org.apache.felix.scr.annotations.Component;
import org.apache.felix.scr.annotations.ConfigurationPolicy;
import org.apache.felix.scr.annotations.Deactivate;
import org.apache.felix.scr.annotations.Properties;
import org.apache.felix.scr.annotations.Property;
import org.apache.felix.scr.annotations.PropertyOption;
import org.apache.felix.scr.annotations.Reference;
import org.apache.felix.scr.annotations.ReferencePolicyOption;
import org.apache.felix.scr.annotations.Service;
import org.apache.sling.api.resource.LoginException;
import org.apache.sling.api.resource.ResourceResolver;
import org.apache.sling.api.resource.ResourceResolverFactory;
import org.apache.sling.commons.osgi.PropertiesUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(label="ACS AEM Commons - Dispatcher Flush Rules", description="Facilitates the flushing of associated paths based on resources being replicated. All flushes use the AEM Replication APIs and support queuing on the Replication Agent.ResourceOnly flushes require Replication Flush Agents with the HTTP Header of 'CQ-Action-Scope: ResourceOnly'.Neither rule sets supports chaining; { /a/.*=/b/c -> /b/.*=/d/e }, due to dangerous cyclic conditions.", metatype=true, configurationFactory=true, policy=ConfigurationPolicy.REQUIRE)
@Service
@Properties(value={@Property(name="webconsole.configurationFactory.nameHint", value={"Rule: {prop.replication-action-type}, for Hierarchy: [{prop.rules.hierarchical}] or Resources: [{prop.rules.resource-only}]"})})
public class DispatcherFlushRulesImpl
implements Preprocessor,
DispatcherFlushRules {
    private static final Logger log = LoggerFactory.getLogger(DispatcherFlushRulesImpl.class);
    private static final String OPTION_INHERIT = "INHERIT";
    private static final String OPTION_ACTIVATE = "ACTIVATE";
    private static final String OPTION_DELETE = "DELETE";
    private static final DispatcherFlushFilter HIERARCHICAL_FILTER = new DispatcherFlushRulesFilter(DispatcherFlushFilter.FlushType.Hierarchical);
    private static final DispatcherFlushFilter RESOURCE_ONLY_FILTER = new DispatcherFlushRulesFilter(DispatcherFlushFilter.FlushType.ResourceOnly);
    private static final String DEFAULT_REPLICATION_ACTION_TYPE_NAME = "INHERIT";
    @Property(label="Replication Action Type", description="The Replication Action Type to use when issuing the flush cmd to the associated paths. If 'Inherit' is selected, the Replication Action Type of the observed Replication Action will be used.", options={@PropertyOption(name="INHERIT", value="Inherit"), @PropertyOption(name="ACTIVATE", value="Invalidate Cache"), @PropertyOption(name="DELETE", value="Delete Cache")})
    private static final String PROP_REPLICATION_ACTION_TYPE_NAME = "prop.replication-action-type";
    private static final String[] DEFAULT_HIERARCHICAL_FLUSH_RULES = new String[0];
    @Property(label="Flush Rules (Hierarchical)", description="Pattern to Path associations for flush rules.Format: <pattern-of-trigger-content>=<path-to-flush>", cardinality=0x7FFFFFFF, value={})
    private static final String PROP_FLUSH_RULES = "prop.rules.hierarchical";
    private static final String[] DEFAULT_RESOURCE_ONLY_FLUSH_RULES = new String[0];
    @Property(label="Flush Rules (ResourceOnly)", description="Pattern to Path associations for flush rules. Format: <pattern-of-trigger-content>=<path-to-flush>", cardinality=0x7FFFFFFF, value={})
    private static final String PROP_RESOURCE_ONLY_FLUSH_RULES = "prop.rules.resource-only";
    private static final String SERVICE_NAME = "dispatcher-flush";
    protected static final Map<String, Object> AUTH_INFO = Collections.singletonMap("sling.service.subservice", "dispatcher-flush");
    @Reference(policyOption=ReferencePolicyOption.GREEDY)
    private DispatcherFlusher dispatcherFlusher;
    @Reference
    private AgentManager agentManager;
    @Reference
    private ResourceResolverFactory resourceResolverFactory;
    private Map<Pattern, String[]> hierarchicalFlushRules = new LinkedHashMap<Pattern, String[]>();
    private Map<Pattern, String[]> resourceOnlyFlushRules = new LinkedHashMap<Pattern, String[]>();
    private ReplicationActionType replicationActionType = null;

    @Override
    public final void preprocess(ReplicationAction replicationAction, ReplicationOptions replicationOptions) throws ReplicationException {
        if (!this.accepts(replicationAction, replicationOptions)) {
            return;
        }
        String path = replicationAction.getPath();
        ReplicationActionType flushActionType = this.replicationActionType == null ? replicationAction.getType() : this.replicationActionType;
        try (ResourceResolver resourceResolver = this.resourceResolverFactory.getServiceResourceResolver(AUTH_INFO);){
            String flushPath;
            Matcher m;
            Pattern pattern;
            for (Map.Entry<Pattern, String[]> entry : this.hierarchicalFlushRules.entrySet()) {
                pattern = entry.getKey();
                m = pattern.matcher(path);
                if (!m.matches()) continue;
                for (String value : entry.getValue()) {
                    flushPath = m.replaceAll(value);
                    log.debug("Requesting hierarchical flush of associated path: {} ~> {}", (Object)path, (Object)flushPath);
                    this.dispatcherFlusher.flush(resourceResolver, flushActionType, false, HIERARCHICAL_FILTER, flushPath);
                }
            }
            for (Map.Entry<Pattern, String[]> entry : this.resourceOnlyFlushRules.entrySet()) {
                pattern = entry.getKey();
                m = pattern.matcher(path);
                if (!m.matches()) continue;
                for (String value : entry.getValue()) {
                    flushPath = m.replaceAll(value);
                    log.debug("Requesting ResourceOnly flush of associated path: {} ~> {}", (Object)path, (Object)entry.getValue());
                    this.dispatcherFlusher.flush(resourceResolver, flushActionType, false, RESOURCE_ONLY_FILTER, flushPath);
                }
            }
        }
        catch (ReplicationException e) {
            log.error("Error issuing dispatcher flush rules, some downstream replication exception occurred: {}", (Object)e.getMessage(), (Object)e);
        }
        catch (LoginException e) {
            log.error("Error issuing dispatcher flush rules due to a repository login exception: {}", (Object)e.getMessage(), (Object)e);
        }
    }

    private boolean accepts(ReplicationAction replicationAction, ReplicationOptions replicationOptions) {
        if (replicationAction == null || replicationOptions == null) {
            log.debug("Replication Action or Options are null. Skipping this replication.");
            return false;
        }
        String path = replicationAction.getPath();
        if (replicationOptions.getFilter() instanceof DispatcherFlushRulesFilter) {
            log.debug("Ignore applying dispatcher flush rules for [ {} ], as it originated from this Service.", (Object)path);
            return false;
        }
        if (!(this.hierarchicalFlushRules != null && this.hierarchicalFlushRules.size() >= 1 || this.resourceOnlyFlushRules != null && this.resourceOnlyFlushRules.size() >= 1)) {
            log.warn("Ignored due no configured flush rules.");
            return false;
        }
        if (StringUtils.isBlank((String)path)) {
            log.debug("Replication Action path is blank. Skipping this replication.");
            return false;
        }
        return ReplicationActionType.ACTIVATE.equals((Object)replicationAction.getType()) || ReplicationActionType.DEACTIVATE.equals((Object)replicationAction.getType()) || ReplicationActionType.DELETE.equals((Object)replicationAction.getType());
    }

    @Activate
    protected final void activate(Map<String, String> properties) throws Exception {
        this.replicationActionType = this.configureReplicationActionType(PropertiesUtil.toString((Object)properties.get(PROP_REPLICATION_ACTION_TYPE_NAME), (String)"INHERIT"));
        this.hierarchicalFlushRules = this.configureFlushRules(ParameterUtil.toMap(PropertiesUtil.toStringArray((Object)properties.get(PROP_FLUSH_RULES), (String[])DEFAULT_HIERARCHICAL_FLUSH_RULES), "="));
        log.debug("Hierarchical flush rules: {}", this.hierarchicalFlushRules);
        this.resourceOnlyFlushRules = this.configureFlushRules(ParameterUtil.toMap(PropertiesUtil.toStringArray((Object)properties.get(PROP_RESOURCE_ONLY_FLUSH_RULES), (String[])DEFAULT_RESOURCE_ONLY_FLUSH_RULES), "="));
        log.debug("ResourceOnly flush rules: {}", this.resourceOnlyFlushRules);
    }

    protected final Map<Pattern, String[]> configureFlushRules(Map<String, String> configuredRules) throws Exception {
        LinkedHashMap<Pattern, String[]> rules = new LinkedHashMap<Pattern, String[]>();
        for (Map.Entry<String, String> entry : configuredRules.entrySet()) {
            Pattern pattern = Pattern.compile(entry.getKey().trim());
            rules.put(pattern, entry.getValue().trim().split("&"));
        }
        return rules;
    }

    protected final ReplicationActionType configureReplicationActionType(String replicationActionTypeName) {
        try {
            ReplicationActionType repActionType = ReplicationActionType.valueOf((String)replicationActionTypeName);
            log.debug("Using replication action type: {}", (Object)repActionType.name());
            return repActionType;
        }
        catch (IllegalArgumentException ex) {
            log.warn("Illegal action type configured: {}. Falling back to default: {}", (Object)replicationActionTypeName, (Object)"INHERIT");
            return null;
        }
    }

    @Deactivate
    protected final void deactivate(Map<String, String> properties) {
        this.hierarchicalFlushRules = new HashMap<Pattern, String[]>();
        this.resourceOnlyFlushRules = new HashMap<Pattern, String[]>();
        this.replicationActionType = null;
    }

    protected void bindDispatcherFlusher(DispatcherFlusher dispatcherFlusher) {
        this.dispatcherFlusher = dispatcherFlusher;
    }

    protected void unbindDispatcherFlusher(DispatcherFlusher dispatcherFlusher) {
        if (this.dispatcherFlusher == dispatcherFlusher) {
            this.dispatcherFlusher = null;
        }
    }

    protected void bindAgentManager(AgentManager agentManager) {
        this.agentManager = agentManager;
    }

    protected void unbindAgentManager(AgentManager agentManager) {
        if (this.agentManager == agentManager) {
            this.agentManager = null;
        }
    }

    protected void bindResourceResolverFactory(ResourceResolverFactory resourceResolverFactory) {
        this.resourceResolverFactory = resourceResolverFactory;
    }

    protected void unbindResourceResolverFactory(ResourceResolverFactory resourceResolverFactory) {
        if (this.resourceResolverFactory == resourceResolverFactory) {
            this.resourceResolverFactory = null;
        }
    }

    protected static final class DispatcherFlushRulesFilter
    extends DispatcherFlushFilter {
        public DispatcherFlushRulesFilter(DispatcherFlushFilter.FlushType flushType) {
            super(flushType);
        }
    }
}

