/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.acs.commons.users.impl;

import com.adobe.acs.commons.users.impl.Ace;
import com.adobe.acs.commons.users.impl.EnsureAuthorizableException;
import com.adobe.acs.commons.users.impl.ProtectedAuthorizables;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.jcr.RepositoryException;
import org.apache.commons.lang.StringUtils;
import org.apache.jackrabbit.api.security.JackrabbitAccessControlEntry;
import org.apache.jackrabbit.vault.util.PathUtil;
import org.apache.sling.commons.osgi.PropertiesUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractAuthorizable {
    private static final Logger log = LoggerFactory.getLogger(AbstractAuthorizable.class);
    protected String principalName;
    protected String intermediatePath;
    protected List<Ace> aces = new ArrayList<Ace>();

    public AbstractAuthorizable(Map<String, Object> config) throws EnsureAuthorizableException {
        String[] acesProperty;
        String tmp = PropertiesUtil.toString((Object)config.get("principalName"), null);
        if (StringUtils.contains((String)tmp, (String)"/")) {
            tmp = StringUtils.removeStart((String)tmp, (String)this.getDefaultPath());
            tmp = StringUtils.removeStart((String)tmp, (String)"/");
            this.principalName = StringUtils.substringAfterLast((String)tmp, (String)"/");
            this.intermediatePath = PathUtil.makePath((String)this.getDefaultPath(), (String)StringUtils.removeEnd((String)tmp, (String)this.principalName));
        } else {
            this.principalName = tmp;
            this.intermediatePath = this.getDefaultPath();
        }
        if (StringUtils.isBlank((String)this.principalName)) {
            throw new EnsureAuthorizableException("No Principal Name provided to Ensure Service User");
        }
        if (ProtectedAuthorizables.isProtected(this.principalName)) {
            throw new EnsureAuthorizableException(String.format("[ %s ] is an System User provided by AEM or ACS AEM Commons. You cannot ensure this user.", this.principalName));
        }
        for (String entry : acesProperty = PropertiesUtil.toStringArray((Object)config.get("aces"), (String[])new String[0])) {
            if (!StringUtils.isNotBlank((String)entry)) continue;
            String aceConfig = entry.trim();
            try {
                this.aces.add(new Ace(aceConfig));
            }
            catch (EnsureAuthorizableException e) {
                log.warn("Malformed ACE config [ " + aceConfig + " ] for Service User [ " + StringUtils.defaultIfEmpty((String)this.principalName, (String)"NOT PROVIDED") + " ]", (Throwable)e);
            }
        }
    }

    public boolean hasAceAt(String path) {
        return this.getAces().stream().anyMatch(ace -> StringUtils.equals((String)path, (String)ace.getContentPath()));
    }

    public String getIntermediatePath() {
        return this.intermediatePath;
    }

    public String getPrincipalName() {
        return this.principalName;
    }

    public List<Ace> getAces() {
        return this.aces;
    }

    public Ace getAce(JackrabbitAccessControlEntry actual, String path) throws RepositoryException {
        for (Ace ace : this.getAces()) {
            if (!StringUtils.equals((String)path, (String)ace.getContentPath()) || !ace.isSameAs(actual)) continue;
            return ace;
        }
        return null;
    }

    public List<Ace> getMissingAces() {
        return this.getAces().stream().filter(ace -> !ace.isExists()).collect(Collectors.toList());
    }

    public abstract String getDefaultPath();
}

