/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.acs.commons.contentsync;

import com.adobe.acs.commons.contentsync.impl.LastModifiedStrategy;
import java.util.HashMap;
import org.apache.sling.api.resource.PersistenceException;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.resource.ResourceResolver;
import org.apache.sling.api.resource.ResourceUtil;

public class ConfigurationUtils {
    public static final String CONFIG_PATH = "/var/acs-commons/contentsync";
    public static final String SETTINGS_PATH = "/var/acs-commons/contentsync/settings";
    public static final String HOSTS_PATH = "/var/acs-commons/contentsync/hosts";
    public static final String UPDATE_STRATEGY_KEY = "update-strategy";
    public static final String EVENT_USER_DATA_KEY = "event-user-data";
    public static final String SO_TIMEOUT_STRATEGY_KEY = "soTimeout";
    public static final String CONNECT_TIMEOUT_KEY = "connTimeout";
    public static final String DISABLE_CERT_CHECK_KEY = "disableCertCheck";

    private ConfigurationUtils() {
    }

    public static Resource getSettingsResource(ResourceResolver resourceResolver) throws PersistenceException {
        HashMap<String, Object> resourceProperties = new HashMap<String, Object>();
        resourceProperties.put("jcr:primaryType", "nt:unstructured");
        resourceProperties.put(UPDATE_STRATEGY_KEY, LastModifiedStrategy.class.getName());
        resourceProperties.put(EVENT_USER_DATA_KEY, "changedByPageManagerCopy");
        resourceProperties.put(SO_TIMEOUT_STRATEGY_KEY, 300000);
        resourceProperties.put(CONNECT_TIMEOUT_KEY, 5000);
        return ResourceUtil.getOrCreateResource((ResourceResolver)resourceResolver, (String)SETTINGS_PATH, resourceProperties, (String)"sling:Folder", (boolean)true);
    }

    public static Resource getHostsResource(ResourceResolver resourceResolver) throws PersistenceException {
        HashMap<String, String> resourceProperties = new HashMap<String, String>();
        resourceProperties.put("jcr:primaryType", "nt:unstructured");
        return ResourceUtil.getOrCreateResource((ResourceResolver)resourceResolver, (String)HOSTS_PATH, resourceProperties, (String)"sling:Folder", (boolean)true);
    }
}

