/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.acs.commons.contentsync.impl;

import com.adobe.acs.commons.contentsync.CatalogItem;
import com.adobe.acs.commons.contentsync.UpdateStrategy;
import com.day.cq.dam.api.Asset;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.json.Json;
import javax.json.JsonObjectBuilder;
import org.apache.sling.api.SlingHttpServletRequest;
import org.apache.sling.api.resource.Resource;
import org.osgi.service.component.annotations.Component;

@Component
public class AssetChecksumStrategy
implements UpdateStrategy {
    private static final String DAM_SHA1 = "dam:sha1";

    @Override
    public boolean isModified(CatalogItem remoteResource, Resource localResource) {
        String remoteChecksum = this.getChecksum(remoteResource);
        String localChecksum = this.getChecksum(localResource);
        return remoteChecksum != null && !remoteChecksum.equals(localChecksum);
    }

    @Override
    public List<CatalogItem> getItems(SlingHttpServletRequest request) {
        String rootPath = request.getParameter("root");
        if (rootPath == null) {
            throw new IllegalArgumentException("root request parameter is required");
        }
        String query = "SELECT * FROM [dam:Asset] AS s WHERE ISDESCENDANTNODE([" + rootPath + "]) ORDER BY s.[jcr:path]";
        Iterator it = request.getResourceResolver().findResources(query, "JCR-SQL2");
        ArrayList<CatalogItem> items = new ArrayList<CatalogItem>();
        while (it.hasNext()) {
            Resource res = (Resource)it.next();
            Asset asset = (Asset)res.adaptTo(Asset.class);
            if (asset == null) continue;
            JsonObjectBuilder json = Json.createObjectBuilder();
            this.writeMetadata(json, res);
            items.add(new CatalogItem(json.build()));
        }
        return items;
    }

    @Override
    public String getMessage(CatalogItem remoteResource, Resource localResource) {
        String remoteChecksum = this.getChecksum(remoteResource);
        String localChecksum = this.getChecksum(localResource);
        boolean modified = remoteChecksum != null && !remoteChecksum.equals(localChecksum);
        StringBuilder msg = new StringBuilder();
        if (localResource == null) {
            msg.append("resource does not exist");
        } else {
            msg.append(modified ? "resource modified ... " : "replacing ... ");
            if (localChecksum != null) {
                msg.append('\n');
                msg.append("\tlocal checksum: " + localChecksum);
            }
            if (remoteChecksum != null) {
                msg.append('\n');
                msg.append("\tremote checksum: " + remoteChecksum);
            }
        }
        return msg.toString();
    }

    private String getChecksum(CatalogItem remoteItem) {
        return remoteItem.getString(DAM_SHA1);
    }

    private String getChecksum(Resource targetResource) {
        if (targetResource == null) {
            return null;
        }
        Asset asset = (Asset)targetResource.adaptTo(Asset.class);
        return asset == null ? null : (String)asset.getMetadata(DAM_SHA1);
    }

    public void writeMetadata(JsonObjectBuilder jw, Resource res) {
        jw.add("path", res.getPath());
        jw.add("jcr:primaryType", (String)res.getValueMap().get("jcr:primaryType", String.class));
        Resource jcrContent = res.getChild("jcr:content");
        String exportUri = jcrContent != null ? jcrContent.getPath() + ".infinity.json" : res.getPath() + ".json";
        jw.add("exportUri", exportUri);
        jw.add(DAM_SHA1, this.getChecksum(res));
    }
}

