/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.acs.commons.httpcache.filter.impl;

import com.adobe.acs.commons.httpcache.config.HttpCacheConfig;
import com.adobe.acs.commons.httpcache.engine.HttpCacheEngine;
import com.adobe.acs.commons.httpcache.exception.HttpCacheException;
import java.io.IOException;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import org.apache.sling.api.SlingHttpServletRequest;
import org.apache.sling.api.SlingHttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractHttpCacheFilter
implements Filter {
    private static final Logger log = LoggerFactory.getLogger(AbstractHttpCacheFilter.class);

    public abstract void doFilter(ServletRequest var1, ServletResponse var2, FilterChain var3) throws IOException, ServletException;

    protected void doFilter(ServletRequest request, ServletResponse response, FilterChain chain, HttpCacheEngine cacheEngine, HttpCacheConfig.FilterScope filterScope) throws IOException, ServletException {
        log.trace("In HttpCache filter.");
        long start = System.currentTimeMillis();
        SlingHttpServletRequest slingRequest = (SlingHttpServletRequest)request;
        Object slingResponse = (SlingHttpServletResponse)response;
        HttpCacheConfig cacheConfig = null;
        boolean isResponseCacheable = false;
        try {
            cacheConfig = cacheEngine.getCacheConfig(slingRequest, filterScope);
            if (cacheConfig != null && cacheEngine.isRequestCacheable(slingRequest, cacheConfig)) {
                if (cacheEngine.isCacheHit(slingRequest, cacheConfig)) {
                    if (cacheEngine.deliverCacheContent(slingRequest, (SlingHttpServletResponse)slingResponse, cacheConfig)) {
                        if (log.isDebugEnabled()) {
                            log.debug("Delivered cached request [ {} ] in {} ms", (Object)slingRequest.getResource().getPath(), (Object)(System.currentTimeMillis() - start));
                        }
                        return;
                    }
                } else {
                    isResponseCacheable = true;
                    slingResponse = cacheEngine.wrapResponse(slingRequest, (SlingHttpServletResponse)slingResponse, cacheConfig);
                }
            }
        }
        catch (HttpCacheException e) {
            log.error("HttpCache exception while dealing with request. Passed on the control to filter chain.", (Throwable)e);
        }
        chain.doFilter(request, (ServletResponse)slingResponse);
        try {
            if (isResponseCacheable) {
                cacheEngine.cacheResponse(slingRequest, (SlingHttpServletResponse)slingResponse, cacheConfig);
            }
            if (log.isTraceEnabled()) {
                log.trace("Delivered un-cached request [ {} ] in {} ms", (Object)slingRequest.getResource().getPath(), (Object)(System.currentTimeMillis() - start));
            }
        }
        catch (HttpCacheException e) {
            log.error("HttpCache exception while dealing with response. Returned the filter chain response", (Throwable)e);
        }
    }

    public void init(FilterConfig filterConfig) throws ServletException {
    }

    public void destroy() {
    }
}

