/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.acs.commons.redirects.models;

import com.adobe.acs.commons.redirects.filter.RedirectFilter;
import com.adobe.acs.commons.redirects.models.RedirectMatch;
import com.adobe.acs.commons.redirects.models.RedirectRule;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.TreeMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.sling.api.SlingHttpServletRequest;
import org.apache.sling.api.resource.Resource;

public class RedirectConfiguration {
    private boolean nonRegexRequestURIRules = false;
    private Map<String, RedirectRule> pathRules = new LinkedHashMap<String, RedirectRule>();
    private Map<String, RedirectRule> caseInsensitiveRules;
    private Map<Pattern, RedirectRule> patternRules;
    private String path;
    private String name;
    public static final RedirectConfiguration EMPTY = new RedirectConfiguration();

    private RedirectConfiguration() {
        this.patternRules = new LinkedHashMap<Pattern, RedirectRule>();
    }

    public RedirectConfiguration(Resource resource, String storageSuffix) {
        this.caseInsensitiveRules = new TreeMap<String, RedirectRule>(String.CASE_INSENSITIVE_ORDER);
        this.patternRules = new LinkedHashMap<Pattern, RedirectRule>();
        this.path = resource.getPath();
        this.name = this.path.replace("/" + storageSuffix, "");
        Collection<RedirectRule> rules = RedirectFilter.getRules(resource);
        for (RedirectRule rule : rules) {
            Map<String, RedirectRule> map;
            if (rule.getRegex() != null) {
                this.patternRules.put(rule.getRegex(), rule);
                continue;
            }
            Map<String, RedirectRule> map2 = map = rule.isCaseInsensitive() ? this.caseInsensitiveRules : this.pathRules;
            if (rule.getEvaluateURI()) {
                this.nonRegexRequestURIRules = true;
                map.put(rule.getSource(), rule);
                continue;
            }
            map.put(RedirectConfiguration.normalizePath(rule.getSource()), rule);
        }
    }

    public static String normalizePath(String resourcePath) {
        int sep = resourcePath.lastIndexOf(46);
        if (sep != -1 && !resourcePath.startsWith("/content/dam/")) {
            resourcePath = resourcePath.replaceAll("\\.html(\\?.*)?$", "");
        }
        return resourcePath;
    }

    static String determinePathToEvaluate(String path, boolean evaluateURI, SlingHttpServletRequest request) {
        return evaluateURI && request != null ? request.getRequestURI() : path;
    }

    public Map<String, RedirectRule> getPathRules() {
        return this.pathRules;
    }

    public Map<String, RedirectRule> getCaseInsensitivePathRules() {
        return this.caseInsensitiveRules;
    }

    public Map<Pattern, RedirectRule> getPatternRules() {
        return this.patternRules;
    }

    public String getPath() {
        return this.path;
    }

    public String getName() {
        return this.name;
    }

    public RedirectMatch match(String requestPath) {
        return this.match(requestPath, "", null);
    }

    public RedirectMatch match(String resourcePath, String contextPrefix, SlingHttpServletRequest request) {
        String normalizedPath = RedirectConfiguration.normalizePath(resourcePath);
        RedirectMatch match = null;
        RedirectRule rule = this.getPathRule(normalizedPath, contextPrefix);
        if (rule == null && this.hasNonRegexRequestURIRules()) {
            String pathToEvaluate = RedirectConfiguration.determinePathToEvaluate(normalizedPath, true, request);
            rule = this.getPathRule(pathToEvaluate, contextPrefix);
        }
        if (rule != null) {
            match = new RedirectMatch(rule, null);
        } else {
            for (Map.Entry<Pattern, RedirectRule> entry : this.getPatternRules().entrySet()) {
                boolean evaluateURI = entry.getValue().getEvaluateURI();
                String pathToEvaluate = RedirectConfiguration.determinePathToEvaluate(normalizedPath, evaluateURI, request);
                Matcher m = this.getRuleMatch(entry.getKey(), pathToEvaluate, contextPrefix, entry.getValue().isCaseInsensitive());
                if (!m.matches()) continue;
                match = new RedirectMatch(entry.getValue(), m);
                break;
            }
        }
        return match;
    }

    private Matcher getRuleMatch(Pattern rulePattern, String pathToEvaluate, String contextPrefix, boolean nc) {
        Matcher matcher;
        if ("".equals(contextPrefix)) {
            return rulePattern.matcher(pathToEvaluate);
        }
        if (!rulePattern.toString().startsWith(contextPrefix)) {
            rulePattern = RedirectRule.toRegex(contextPrefix + rulePattern.toString(), nc);
        }
        if (!(matcher = rulePattern.matcher(pathToEvaluate)).matches()) {
            matcher = pathToEvaluate.startsWith(contextPrefix) ? rulePattern.matcher(pathToEvaluate.replace(contextPrefix, "")) : rulePattern.matcher(contextPrefix + pathToEvaluate);
        }
        return matcher;
    }

    private RedirectRule getPathRule(String normalizedPath, String contextPrefix) {
        if ("".equals(contextPrefix)) {
            return this.getPathRule(normalizedPath);
        }
        RedirectRule rule = this.getPathRule(normalizedPath);
        if (rule == null) {
            rule = normalizedPath.startsWith(contextPrefix) ? this.getPathRule(normalizedPath.replace(contextPrefix, "")) : this.getPathRule(contextPrefix + normalizedPath);
        }
        return rule;
    }

    private RedirectRule getPathRule(String normalizedPath) {
        RedirectRule rule = this.getPathRules().get(normalizedPath);
        if (rule == null) {
            rule = this.getCaseInsensitivePathRules().get(normalizedPath);
        }
        return rule;
    }

    private boolean hasNonRegexRequestURIRules() {
        return this.nonRegexRequestURIRules;
    }
}

