/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.acs.commons.replication.impl;

import com.adobe.acs.commons.replication.AgentHosts;
import com.day.cq.replication.Agent;
import com.day.cq.replication.AgentFilter;
import com.day.cq.replication.AgentManager;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.apache.felix.scr.annotations.Component;
import org.apache.felix.scr.annotations.Reference;
import org.apache.felix.scr.annotations.Service;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component
@Service
public class AgentHostsImpl
implements AgentHosts {
    private static final Logger log = LoggerFactory.getLogger(AgentHostsImpl.class);
    private static final String DEFAULT_SCHEME = "http";
    @Reference
    private AgentManager agentManager;

    @Override
    public final List<String> getHosts(AgentFilter agentFilter) {
        ArrayList<String> hosts = new ArrayList<String>();
        Map agents = this.agentManager.getAgents();
        for (Agent agent : agents.values()) {
            if (!agentFilter.isIncluded(agent)) continue;
            try {
                URI uri = new URI(agent.getConfiguration().getTransportURI());
                String tmp = (String)StringUtils.defaultIfEmpty((CharSequence)uri.getScheme(), (CharSequence)DEFAULT_SCHEME) + "://" + uri.getHost();
                if (uri.getPort() > 0) {
                    tmp = tmp + ":" + uri.getPort();
                }
                hosts.add(tmp);
            }
            catch (URISyntaxException e) {
                log.error("Unable to extract a scheme/host/port from Agent transport URI [ {} ]", (Object)agent.getConfiguration().getTransportURI());
            }
        }
        return hosts;
    }

    protected void bindAgentManager(AgentManager agentManager) {
        this.agentManager = agentManager;
    }

    protected void unbindAgentManager(AgentManager agentManager) {
        if (this.agentManager == agentManager) {
            this.agentManager = null;
        }
    }
}

