/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.acs.commons.workflow.bulk.execution.model;

import com.adobe.acs.commons.workflow.bulk.execution.model.Workspace;
import javax.inject.Inject;
import org.apache.commons.lang3.StringUtils;
import org.apache.sling.api.resource.ModifiableValueMap;
import org.apache.sling.api.resource.PersistenceException;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.resource.ResourceResolver;
import org.apache.sling.models.annotations.Default;
import org.apache.sling.models.annotations.Model;
import org.apache.sling.models.annotations.Optional;

@Model(adaptables={Resource.class})
public class Config {
    private final Resource resource;
    private final ModifiableValueMap properties;
    private Workspace workspace;
    @Inject
    @Default(values={"com.adobe.acs.commons.workflow.bulk.execution.impl.runners.AEMWorkflowRunnerImpl"})
    private String runnerType;
    @Inject
    @Optional
    private String queryStatement;
    @Inject
    @Default(values={"queryBuilder"})
    private String queryType;
    @Inject
    @Default(intValues={10})
    private int timeout;
    @Inject
    @Default(booleanValues={false})
    private boolean purgeWorkflow;
    @Inject
    @Default(intValues={0})
    private int batchSize;
    @Inject
    @Default(intValues={10})
    private int interval;
    @Inject
    @Default(intValues={10})
    private int throttle;
    @Inject
    @Optional
    private String relativePath;
    @Inject
    @Optional
    private String workflowModel;
    @Inject
    @Default(intValues={10})
    private int retryCount;
    @Inject
    @Default(booleanValues={true})
    private boolean autoThrottle;
    @Inject
    @Optional
    private String userEventData;

    public Config(Resource resource) {
        this.resource = resource;
        this.properties = (ModifiableValueMap)resource.adaptTo(ModifiableValueMap.class);
    }

    public int getTimeout() {
        return this.timeout;
    }

    public int getThrottle() {
        return this.throttle;
    }

    public int getBatchSize() {
        return this.batchSize;
    }

    public int getInterval() {
        return this.interval;
    }

    public String getRelativePath() {
        return this.relativePath;
    }

    public String getRunnerType() {
        return this.runnerType;
    }

    public String getWorkflowModelId() {
        return this.workflowModel;
    }

    public String getPath() {
        return this.resource.getPath();
    }

    public ResourceResolver getResourceResolver() {
        return this.resource.getResourceResolver();
    }

    public String getQueryStatement() {
        return this.queryStatement;
    }

    public String getQueryType() {
        return this.queryType;
    }

    public Resource getResource() {
        return this.resource;
    }

    public int getRetryCount() {
        return this.retryCount;
    }

    public boolean isAutoThrottle() {
        return this.autoThrottle;
    }

    public String getUserEventData() {
        return this.userEventData;
    }

    public boolean isUserEventData() {
        return StringUtils.isNotBlank((CharSequence)this.userEventData);
    }

    public Workspace getWorkspace() {
        if (this.workspace == null) {
            this.workspace = (Workspace)this.resource.getChild("workspace").adaptTo(Workspace.class);
        }
        return this.workspace;
    }

    public boolean isPurgeWorkflow() {
        return this.purgeWorkflow;
    }

    public void setInterval(int interval) {
        if (interval < 1) {
            interval = 0;
        }
        this.interval = interval;
        this.properties.put((Object)"interval", (Object)this.interval);
    }

    public void setThrottle(int throttle) {
        if (throttle < 1) {
            throttle = 0;
        }
        this.throttle = throttle;
        this.properties.put((Object)"throttle", (Object)this.throttle);
    }

    public void commit() throws PersistenceException {
        if (this.getResourceResolver().hasChanges()) {
            this.getResourceResolver().commit();
        }
    }
}

