/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.acs.commons.workflow.process.impl;

import com.day.cq.replication.Agent;
import com.day.cq.replication.AgentFilter;
import com.day.cq.replication.ReplicationOptions;
import com.day.cq.wcm.workflow.process.ActivatePageProcess;
import com.day.cq.workflow.WorkflowException;
import com.day.cq.workflow.WorkflowSession;
import com.day.cq.workflow.exec.WorkItem;
import com.day.cq.workflow.metadata.MetaDataMap;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.felix.scr.annotations.Component;
import org.apache.felix.scr.annotations.Properties;
import org.apache.felix.scr.annotations.Property;
import org.apache.felix.scr.annotations.Service;

@Component(metatype=true, label="ACS AEM Commons - Workflow Process - Parameterized Activate Resource", description="Triggers an activation replication event, but only to specifically configured agents.")
@Properties(value={@Property(label="Workflow Label", name="process.label", value={"Parameterized Activate Resource Process"}, description="Triggers an activation replication event, but only to specifically configured agents.")})
@Service
public class ParameterizedActivatePageProcess
extends ActivatePageProcess {
    private static final String AGENT_ARG = "replicationAgent";
    private static final String ARG_REPLICATION_SUPPRESS_STATUS_UPDATE = "suppressStatusUpdate";
    private transient ThreadLocal<String[]> agentId = new ThreadLocal();
    private boolean suppressStatusUpdate = false;

    public void execute(WorkItem workItem, WorkflowSession workflowSession, MetaDataMap args) throws WorkflowException {
        this.agentId.set((String[])args.get(AGENT_ARG, (Object)new String[0]));
        this.suppressStatusUpdate = Boolean.parseBoolean((String)args.get(ARG_REPLICATION_SUPPRESS_STATUS_UPDATE, String.class));
        super.execute(workItem, workflowSession, args);
    }

    protected ReplicationOptions prepareOptions(ReplicationOptions opts) {
        if (opts == null) {
            opts = new ReplicationOptions();
        }
        opts.setFilter(new AgentFilter(){

            public boolean isIncluded(Agent agent) {
                if (ArrayUtils.isEmpty((Object[])((Object[])ParameterizedActivatePageProcess.this.agentId.get()))) {
                    return false;
                }
                return ArrayUtils.contains((Object[])((Object[])ParameterizedActivatePageProcess.this.agentId.get()), (Object)agent.getId());
            }
        });
        opts.setSuppressStatusUpdate(this.suppressStatusUpdate);
        return opts;
    }
}

