/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.acs.commons.cloudconfig.impl;

import com.adobe.acs.commons.cloudconfig.CloudConfiguration;
import com.drew.lang.annotations.NotNull;
import java.util.Optional;
import javax.inject.Named;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.models.annotations.Model;
import org.apache.sling.models.annotations.injectorspecific.InjectionStrategy;
import org.apache.sling.models.annotations.injectorspecific.ValueMapValue;

@Model(adaptables={Resource.class}, adapters={CloudConfiguration.class})
public class CloudConfigurationImpl
implements CloudConfiguration {
    private String configPath;
    private String path;
    @ValueMapValue(injectionStrategy=InjectionStrategy.OPTIONAL)
    @Named(value="jcr:content/jcr:title")
    private String title;

    public CloudConfigurationImpl(Resource resource) {
        this.path = resource.getPath();
        this.configPath = Optional.ofNullable(resource.getParent()).map(Resource::getParent).map(Resource::getPath).orElse("");
    }

    @Override
    @NotNull
    public String getConfigPath() {
        return this.configPath;
    }

    @Override
    @NotNull
    public String getItemPath() {
        return this.path;
    }

    @Override
    @NotNull
    public String getTitle() {
        return this.title;
    }
}

