/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.acs.commons.granite.ui.components.impl.include;

import com.adobe.acs.commons.granite.ui.components.impl.include.NamespaceDecoratedValueMapBuilder;
import com.adobe.granite.ui.components.ExpressionResolver;
import com.adobe.granite.ui.components.FilteringResourceWrapper;
import java.util.Arrays;
import java.util.Iterator;
import java.util.Optional;
import org.apache.commons.collections4.iterators.FilterIterator;
import org.apache.commons.collections4.iterators.TransformIterator;
import org.apache.sling.api.SlingHttpServletRequest;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.resource.ValueMap;
import org.jetbrains.annotations.NotNull;

public class NamespaceResourceWrapper
extends FilteringResourceWrapper {
    private final ExpressionResolver expressionResolver;
    private final SlingHttpServletRequest request;
    private final String[] namespacedProperties;
    private final ValueMap valueMap;
    private boolean copyToplevelProperties;

    public NamespaceResourceWrapper(@NotNull Resource resource, @NotNull ExpressionResolver expressionResolver, @NotNull SlingHttpServletRequest request, String[] namespacedProperties, boolean copyToplevelProperties) {
        super(resource, expressionResolver, request);
        this.expressionResolver = expressionResolver;
        this.request = request;
        this.namespacedProperties = Optional.ofNullable(namespacedProperties).map(array -> Arrays.copyOf(array, ((String[])array).length)).orElse(new String[0]);
        this.copyToplevelProperties = copyToplevelProperties;
        this.valueMap = new NamespaceDecoratedValueMapBuilder(request, resource, namespacedProperties, copyToplevelProperties).build();
    }

    public Resource getChild(String relPath) {
        Resource child = super.getChild(relPath);
        if (child == null) {
            return null;
        }
        NamespaceResourceWrapper wrapped = new NamespaceResourceWrapper(child, this.expressionResolver, this.request, this.namespacedProperties, this.copyToplevelProperties);
        if (!this.isVisible((Resource)wrapped)) {
            return null;
        }
        return wrapped;
    }

    public Iterator<Resource> listChildren() {
        return new TransformIterator((Iterator)new FilterIterator(super.listChildren(), o -> this.isVisible((Resource)new NamespaceResourceWrapper((Resource)o, this.expressionResolver, this.request, this.namespacedProperties, this.copyToplevelProperties))), o -> new NamespaceResourceWrapper((Resource)o, this.expressionResolver, this.request, this.namespacedProperties, this.copyToplevelProperties));
    }

    private boolean isVisible(Resource o) {
        return (Boolean)o.getValueMap().get("hide", (Object)Boolean.FALSE) == false;
    }

    public <AdapterType> AdapterType adaptTo(Class<AdapterType> type) {
        if (type == ValueMap.class) {
            return (AdapterType)this.getValueMap();
        }
        return (AdapterType)super.adaptTo(type);
    }

    public ValueMap getValueMap() {
        return this.valueMap;
    }
}

