/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.acs.commons.httpcache.store.jcr.impl.visitor;

import com.adobe.acs.commons.httpcache.engine.CacheContent;
import com.adobe.acs.commons.httpcache.keys.CacheKey;
import com.adobe.acs.commons.httpcache.store.jcr.impl.handler.EntryNodeToCacheContentHandler;
import com.adobe.acs.commons.httpcache.store.jcr.impl.handler.EntryNodeToCacheKeyHandler;
import com.adobe.acs.commons.httpcache.store.jcr.impl.visitor.AbstractNodeVisitor;
import java.io.IOException;
import javax.jcr.Node;
import javax.jcr.RepositoryException;
import org.apache.commons.lang3.StringUtils;
import org.apache.sling.commons.classloader.DynamicClassLoaderManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EntryNodeByStringKeyVisitor
extends AbstractNodeVisitor {
    private static final Logger log = LoggerFactory.getLogger(EntryNodeByStringKeyVisitor.class);
    private final DynamicClassLoaderManager dclm;
    private final String cacheKeyStr;
    private CacheContent cacheContent;

    public EntryNodeByStringKeyVisitor(int maxLevel, DynamicClassLoaderManager dclm, String cacheKeyStr) {
        super(maxLevel, -1L);
        this.dclm = dclm;
        this.cacheKeyStr = cacheKeyStr;
    }

    public CacheContent getCacheContentIfPresent() {
        return this.cacheContent;
    }

    @Override
    protected void entering(Node node, int level) throws RepositoryException {
        super.entering(node, level);
        if (EntryNodeByStringKeyVisitor.isCacheEntryNode(node)) {
            try {
                CacheKey cacheKey = this.getCacheKey(node);
                if (StringUtils.equals((CharSequence)cacheKey.toString(), (CharSequence)this.cacheKeyStr)) {
                    this.cacheContent = new EntryNodeToCacheContentHandler(node).get();
                }
            }
            catch (Exception e) {
                log.error("Exception occured in retrieving the cacheKey from the entryNode", (Throwable)e);
                throw new RepositoryException((Throwable)e);
            }
        }
    }

    protected CacheKey getCacheKey(Node node) throws RepositoryException, IOException, ClassNotFoundException {
        return new EntryNodeToCacheKeyHandler(node, this.dclm).get();
    }

    @Override
    public void visit(Node node) throws RepositoryException {
        if (this.cacheContent == null) {
            super.visit(node);
        }
    }
}

