/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.acs.commons.mcp.impl.processes;

import com.adobe.acs.commons.fam.ActionManager;
import com.adobe.acs.commons.fam.actions.Actions;
import com.adobe.acs.commons.mcp.ProcessDefinition;
import com.adobe.acs.commons.mcp.ProcessInstance;
import com.adobe.acs.commons.mcp.form.CheckboxComponent;
import com.adobe.acs.commons.mcp.form.FormField;
import com.adobe.acs.commons.mcp.form.PathfieldComponent;
import com.adobe.acs.commons.mcp.form.RadioComponent;
import com.adobe.acs.commons.mcp.form.TextfieldComponent;
import com.adobe.acs.commons.mcp.impl.processes.ReferenceFinder;
import com.adobe.acs.commons.mcp.model.GenericBlobReport;
import com.adobe.acs.commons.mcp.util.StringUtil;
import com.day.cq.commons.RangeIterator;
import com.day.cq.tagging.Tag;
import com.day.cq.tagging.TagManager;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumMap;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import javax.jcr.RepositoryException;
import org.apache.commons.lang3.tuple.ImmutablePair;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.sling.api.resource.LoginException;
import org.apache.sling.api.resource.PersistenceException;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.resource.ResourceResolver;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TagReporter
extends ProcessDefinition
implements Serializable {
    private static final Logger log = LoggerFactory.getLogger(TagReporter.class);
    public static final String PROCESS_NAME = "Tag Report";
    private static final long serialVersionUID = 4325471295421747160L;
    public static final int CELL_CHAR_LIMIT = Short.MAX_VALUE;
    @FormField(name="Root Search path", description="The path under which to search for references to the tags", component=PathfieldComponent.NodeSelectComponent.class, required=true, options={"default=/content", "base=/"})
    public transient String rootSearchPath = null;
    @FormField(name="Tag path", description="The path to the root tag / namespace of this report, all tags under this tag will be included in the report", component=PathfieldComponent.NodeSelectComponent.class, required=true, options={"default=/content/cq:tags", "base=/"})
    public transient String tagPath = null;
    @FormField(name="Include References", description="Include the references to the tags in the report", component=CheckboxComponent.class)
    public boolean includeReferences = false;
    @FormField(name="References Char Limit", description="Character limit for references when saving to the spreadsheet cells, must be less than 32,767", component=TextfieldComponent.class, required=true, options={"default=4096"})
    public String referencesCharacterLimit = "4096";
    @FormField(name="Reference Method", description="The method used for finding references to the tag", component=RadioComponent.EnumerationSelector.class, options={"vertical", "default=DEFAULT_TAG_FIND"})
    public ReferenceMethod referenceMethod = ReferenceMethod.DEFAULT_TAG_MANAGER_FIND;
    private final transient GenericBlobReport report = new GenericBlobReport();
    private final transient List<EnumMap<ReportColumns, Object>> reportRows = new ArrayList<EnumMap<ReportColumns, Object>>();
    private List<Pair<String, String>> tags = new ArrayList<Pair<String, String>>();

    @Override
    public void buildProcess(ProcessInstance instance, ResourceResolver rr) throws LoginException, RepositoryException {
        log.trace("buildProcess");
        this.report.setName(instance.getName());
        instance.getInfo().setDescription(String.format("Report for tags under [ %s ], referenced from [ %s ]", this.tagPath, this.rootSearchPath));
        instance.defineCriticalAction("Traversing tags", rr, this::traverseTags);
        instance.defineCriticalAction("Finding references", rr, this::recordTags);
    }

    @NotNull
    private List<String> computeReferenceCellValues(Collection<String> references) {
        ArrayList<String> cells = new ArrayList<String>();
        ArrayList<String> cell = new ArrayList<String>();
        int len = 0;
        for (String ref : references) {
            if (len + ref.length() < Short.MAX_VALUE) {
                cell.add(ref);
                len = len + ref.length() + 1;
                continue;
            }
            cells.add(cell.stream().collect(Collectors.joining(",")));
            cell.clear();
            cell.add(ref);
            len = ref.length() + 1;
        }
        if (!cell.isEmpty()) {
            cells.add(cell.stream().collect(Collectors.joining(",")));
        }
        if (cells.isEmpty()) {
            cells.add("");
        }
        return cells;
    }

    private void findReferencesDeep(ResourceResolver resolver, String id, String title) {
        ReferenceFinder referenceFinder = new ReferenceFinder(resolver, id, this.rootSearchPath, true);
        if (this.includeReferences) {
            this.record(ItemStatus.SUCCESS, id, title, referenceFinder.getAllReferences().stream().map(Pair::getLeft).collect(Collectors.toSet()));
        } else {
            this.record(ItemStatus.SUCCESS, id, title, referenceFinder.getAllReferences().size());
        }
    }

    private void findReferencesTagMgr(ResourceResolver resolver, String id, String title) {
        TagManager tagManager = (TagManager)resolver.adaptTo(TagManager.class);
        RangeIterator refs = Optional.ofNullable(tagManager).map(tm -> tm.find(this.rootSearchPath, new String[]{id})).orElse(null);
        ArrayList<String> references = new ArrayList<String>();
        if (refs != null) {
            int count = 0;
            while (refs.hasNext()) {
                ++count;
                Resource ref = (Resource)refs.next();
                if (!this.includeReferences) continue;
                references.add(ref.getPath());
            }
            if (this.includeReferences) {
                this.record(ItemStatus.SUCCESS, id, title, references);
            } else {
                this.record(ItemStatus.SUCCESS, id, title, count);
            }
        } else {
            log.debug("TagManager failed to return reference list for: {}", (Object)id);
            this.record(ItemStatus.INVALID_TAG, id, title, -1L);
        }
    }

    public GenericBlobReport getReport() {
        return this.report;
    }

    public List<EnumMap<ReportColumns, Object>> getReportRows() {
        return Collections.unmodifiableList(this.reportRows);
    }

    @Override
    public void init() throws RepositoryException {
        if (this.referenceMethod == null) {
            this.referenceMethod = ReferenceMethod.DEFAULT_TAG_MANAGER_FIND;
        }
    }

    private void record(ItemStatus status, String tagId, String title, Collection<String> references) {
        if (this.includeReferences) {
            List<String> referenceCellValues = this.computeReferenceCellValues(references);
            for (int i = 0; i < referenceCellValues.size(); ++i) {
                EnumMap<ReportColumns, Object> row = new EnumMap<ReportColumns, Object>(ReportColumns.class);
                ItemStatus stat = i == 0 ? status : ItemStatus.EXTENDED_DATA;
                row.put(ReportColumns.STATUS, StringUtil.getFriendlyName(stat.name()));
                row.put(ReportColumns.TAG_ID, tagId);
                row.put(ReportColumns.REFERENCE_COUNT, Long.valueOf(references.size()));
                row.put(ReportColumns.TAG_TITLE, title);
                row.put(ReportColumns.REFERENCES, referenceCellValues.get(i));
                this.reportRows.add(row);
            }
        } else {
            EnumMap<ReportColumns, Object> row = new EnumMap<ReportColumns, Object>(ReportColumns.class);
            row.put(ReportColumns.STATUS, StringUtil.getFriendlyName(status.name()));
            row.put(ReportColumns.TAG_ID, tagId);
            row.put(ReportColumns.REFERENCE_COUNT, Long.valueOf(references.size()));
            row.put(ReportColumns.TAG_TITLE, title);
            this.reportRows.add(row);
        }
    }

    private void record(ItemStatus status, String tagId, String title, long referenceCount) {
        EnumMap<ReportColumns, Object> row = new EnumMap<ReportColumns, Object>(ReportColumns.class);
        row.put(ReportColumns.STATUS, StringUtil.getFriendlyName(status.name()));
        row.put(ReportColumns.TAG_ID, tagId);
        row.put(ReportColumns.REFERENCE_COUNT, Long.valueOf(referenceCount));
        row.put(ReportColumns.TAG_TITLE, title);
        this.reportRows.add(row);
    }

    private void recordTag(ResourceResolver resolver, Pair<String, String> tag) {
        log.trace("recordTag {}", tag);
        String id = (String)tag.getLeft();
        String title = (String)tag.getRight();
        try {
            if (this.referenceMethod == ReferenceMethod.DEEP_SEARCH) {
                this.findReferencesDeep(resolver, id, title);
            } else {
                this.findReferencesTagMgr(resolver, id, title);
            }
        }
        catch (Exception e) {
            log.warn("Failed to find references to tag due to exception", (Throwable)e);
            this.record(ItemStatus.INVALID_TAG, id, title, -1L);
        }
    }

    public void recordTags(ActionManager manager) {
        log.trace("recordReferences");
        this.tags.forEach(t -> manager.deferredWithResolver(resolver -> {
            log.debug("Recording references to: {}", t.getLeft());
            Actions.setCurrentItem(String.format("Recording references to [ %s ]", t.getLeft()));
            this.recordTag((ResourceResolver)resolver, (Pair<String, String>)t);
        }));
    }

    @Override
    public void storeReport(ProcessInstance instance, ResourceResolver rr) throws RepositoryException, PersistenceException {
        log.trace("storeReport");
        this.report.setRows(this.reportRows, ReportColumns.class);
        this.report.persist(rr, instance.getPath() + "/jcr:content/report");
    }

    public void traverseTags(ActionManager manager) throws Exception {
        log.trace("traverseTags");
        manager.withResolver(resolver -> {
            Resource root = resolver.getResource(this.tagPath);
            log.info("Finding tags under: {}", (Object)root);
            if (root != null) {
                List<Tag> roots = Optional.ofNullable((Tag)root.adaptTo(Tag.class)).map(Collections::singletonList).orElse(StreamSupport.stream(root.getChildren().spliterator(), false).map(c -> {
                    log.debug("Checking if child resource {} is a tag", c);
                    return (Tag)c.adaptTo(Tag.class);
                }).filter(Objects::nonNull).collect(Collectors.toList()));
                roots.forEach(this::traverseTags);
            } else {
                log.warn("Failed to find resource at path: {}", (Object)this.tagPath);
                this.record(ItemStatus.FAILURE, "Failed to find resource at path: " + this.tagPath, "N/A", -1L);
            }
        });
    }

    private void traverseTags(Tag tag) {
        log.debug("traverseTags({})", (Object)tag.getTagID());
        Actions.setCurrentItem("Traversing tags: " + tag.getTagID());
        this.tags.add((Pair<String, String>)new ImmutablePair((Object)tag.getTagID(), (Object)tag.getTitle()));
        Iterator children = tag.listChildren();
        while (children.hasNext()) {
            this.traverseTags((Tag)children.next());
        }
    }

    public static enum ReferenceMethod {
        DEEP_SEARCH,
        DEFAULT_TAG_MANAGER_FIND;

    }

    public static enum ItemStatus {
        EXTENDED_DATA,
        FAILURE,
        INVALID_TAG,
        SUCCESS;

    }

    public static enum ReportColumns {
        REFERENCE_COUNT,
        REFERENCES,
        STATUS,
        TAG_ID,
        TAG_TITLE;

    }
}

