/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.acs.commons.oak.impl;

import com.adobe.acs.commons.analysis.jcrchecksum.ChecksumGenerator;
import com.adobe.acs.commons.oak.EnsureOakIndexManager;
import com.adobe.acs.commons.oak.impl.AppliableEnsureOakIndex;
import com.adobe.acs.commons.oak.impl.EnsureOakIndexJobHandler;
import com.adobe.acs.commons.oak.impl.EnsureOakIndexManagerImpl;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import javax.jcr.RepositoryException;
import org.apache.commons.lang3.StringUtils;
import org.apache.sling.api.resource.ResourceResolverFactory;
import org.apache.sling.commons.scheduler.ScheduleOptions;
import org.apache.sling.commons.scheduler.Scheduler;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.ConfigurationPolicy;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.component.annotations.ReferenceCardinality;
import org.osgi.service.component.annotations.ReferencePolicy;
import org.osgi.service.component.annotations.ReferencePolicyOption;
import org.osgi.service.metatype.annotations.AttributeDefinition;
import org.osgi.service.metatype.annotations.Designate;
import org.osgi.service.metatype.annotations.ObjectClassDefinition;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(configurationPolicy=ConfigurationPolicy.REQUIRE)
@Designate(ocd=Config.class, factory=true)
public class EnsureOakIndex
implements AppliableEnsureOakIndex {
    static final Logger log = LoggerFactory.getLogger(EnsureOakIndex.class);
    private static final String DEFAULT_ENSURE_DEFINITIONS_PATH = "";
    private static final String DEFAULT_OAK_INDEXES_PATH = "/oak:index";
    private static final boolean DEFAULT_IMMEDIATE = true;
    public static final String PROP_ENSURE_DEFINITIONS_PATH = "ensure-definitions.path";
    public static final String PROP_OAK_INDEXES_PATH = "oak-indexes.path";
    public static final String PROP_IMMEDIATE = "immediate";
    public static final String PROP_ADDITIONAL_IGNORE_PROPERTIES = "properties.ignore";
    @Reference
    private ChecksumGenerator checksumGenerator;
    @Reference
    private ResourceResolverFactory resourceResolverFactory;
    @Reference
    private Scheduler scheduler;
    @Reference(cardinality=ReferenceCardinality.OPTIONAL, policy=ReferencePolicy.DYNAMIC, policyOption=ReferencePolicyOption.GREEDY)
    private volatile EnsureOakIndexManager indexManager;
    private String ensureDefinitionsPath;
    private String oakIndexesPath;
    private boolean immediate = true;
    private boolean applied = false;
    private CopyOnWriteArrayList<String> ignoreProperties = new CopyOnWriteArrayList();

    @Activate
    protected final void activate(Config config) throws RepositoryException {
        this.ensureDefinitionsPath = config.ensure$_$definitions_path();
        this.oakIndexesPath = config.oak$_$indexes_path();
        if (StringUtils.isBlank((CharSequence)this.ensureDefinitionsPath)) {
            throw new IllegalArgumentException("OSGi Configuration Property `ensure-definitions.path` cannot be blank.");
        }
        if (StringUtils.isBlank((CharSequence)this.oakIndexesPath)) {
            throw new IllegalArgumentException("OSGi Configuration Property `oak-indexes.path` cannot be blank.");
        }
        this.immediate = config.immediate();
        String[] ignoredProps = config.properties_ignore();
        String[] indexManagerIgnoredProps = this.getIndexManagerConfiguredIgnoreProperties();
        if (ignoredProps.length == 0) {
            if (indexManagerIgnoredProps.length != 0) {
                this.ignoreProperties = new CopyOnWriteArrayList<String>(indexManagerIgnoredProps);
                log.warn("The configuration of ignoredProperties on the EnsureOakIndexManagerImpl is deprecated, these properties should be configured on the EnsureOakIndex service instead. For convenience they are respected for now, but please move them over.");
            }
        } else {
            this.ignoreProperties = new CopyOnWriteArrayList<String>(ignoredProps);
            if (indexManagerIgnoredProps.length != 0) {
                log.warn("Configuration of the ignoredProperties is present on EnsureOakIndex, but there is also a (legacy) configuration at EnsureOakIndexManagerImpl; please delete it");
            }
        }
        if (this.immediate) {
            this.apply(false);
        }
    }

    private String[] getIndexManagerConfiguredIgnoreProperties() {
        if (this.indexManager instanceof EnsureOakIndexManagerImpl) {
            EnsureOakIndexManagerImpl impl = (EnsureOakIndexManagerImpl)this.indexManager;
            return impl.getIgnoredProperties();
        }
        return new String[0];
    }

    @Override
    public final void apply(boolean force) {
        if (!force && this.applied) {
            return;
        }
        log.info("Ensuring Oak Indexes [ {} ~> {} ]", (Object)this.ensureDefinitionsPath, (Object)this.oakIndexesPath);
        EnsureOakIndexJobHandler jobHandler = new EnsureOakIndexJobHandler(this, this.oakIndexesPath, this.ensureDefinitionsPath);
        ScheduleOptions options = this.scheduler.NOW();
        options.name(this.toString());
        options.canRunConcurrently(false);
        this.scheduler.schedule((Object)jobHandler, options);
        this.applied = true;
        log.info("Job scheduled for ensuring Oak Indexes [ {} ~> {} ]", (Object)this.ensureDefinitionsPath, (Object)this.oakIndexesPath);
    }

    @Override
    public final boolean isApplied() {
        return this.applied;
    }

    @Override
    public boolean isImmediate() {
        return this.immediate;
    }

    @Override
    public List<String> getIgnoreProperties() {
        return Collections.unmodifiableList(this.ignoreProperties);
    }

    @Override
    public final String getEnsureDefinitionsPath() {
        return StringUtils.trim((String)this.ensureDefinitionsPath);
    }

    @Override
    public String getOakIndexesPath() {
        return StringUtils.trim((String)this.oakIndexesPath);
    }

    public final String toString() {
        return String.format("EnsureOakIndex( %s => %s )", this.ensureDefinitionsPath, this.oakIndexesPath);
    }

    ChecksumGenerator getChecksumGenerator() {
        return this.checksumGenerator;
    }

    final ResourceResolverFactory getResourceResolverFactory() {
        return this.resourceResolverFactory;
    }

    @ObjectClassDefinition(name="ACS AEM Commons - Ensure Oak Index", description="Component Factory to manage Oak indexes.")
    static @interface Config {
        @AttributeDefinition(name="Ensure Definitions Path", description="The absolute path to the resource containing the ACS AEM Commons ensure definitions")
        public String ensure$_$definitions_path() default "";

        @AttributeDefinition(name="Oak Indexes Path", description="The absolute path to the oak:index to update; Defaults to [ /oak:index ]")
        public String oak$_$indexes_path() default "/oak:index";

        @AttributeDefinition(name="Immediate", description="Apply the indexes on startup of service. Defaults to [ true ]")
        public boolean immediate() default true;

        @AttributeDefinition(name="Additional ignore properties", description="Property names that are to be ignored when determining if an oak index has changed, as well as what properties should be removed/updated.", cardinality=0x7FFFFFFF)
        public String[] properties_ignore() default {};

        public String webconsole_configurationFactory_nameHint() default "Definitions: {ensure-definitions.path}, Indexes: {oak-indexes.path}";
    }

    static class OakIndexDefinitionException
    extends Exception {
        OakIndexDefinitionException(String message) {
            super(message);
        }
    }
}

