/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.acs.commons.oak.impl;

import com.adobe.acs.commons.analysis.jcrchecksum.ChecksumGenerator;
import com.adobe.acs.commons.analysis.jcrchecksum.impl.options.CustomChecksumGeneratorOptions;
import com.adobe.acs.commons.oak.impl.EnsureOakIndex;
import com.day.cq.commons.jcr.JcrUtil;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.jcr.Node;
import javax.jcr.Property;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.sling.api.resource.LoginException;
import org.apache.sling.api.resource.ModifiableValueMap;
import org.apache.sling.api.resource.PersistenceException;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.resource.ResourceResolver;
import org.apache.sling.api.resource.ValueMap;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EnsureOakIndexJobHandler
implements Runnable {
    static final Logger log = LoggerFactory.getLogger(EnsureOakIndexJobHandler.class);
    static final String PN_FORCE_REINDEX = "forceReindex";
    static final String PN_DELETE = "delete";
    static final String PN_IGNORE = "ignore";
    static final String PN_DISABLE = "disable";
    static final String NT_OAK_QUERY_INDEX_DEFINITION = "oak:QueryIndexDefinition";
    static final String NT_OAK_UNSTRUCTURED = "oak:Unstructured";
    static final String PN_TYPE = "type";
    static final String DISABLED = "disabled";
    static final String PN_RECREATE_ON_UPDATE = "recreateOnUpdate";
    static final String PN_REINDEX_COUNT = "reindexCount";
    static final String PN_SEED = "seed";
    static final String PN_REINDEX = "reindex";
    static final String NN_FACETS = "facets";
    static final String ENSURE_OAK_INDEX_USER_NAME = "Ensure Oak Index";
    static final String[] MANDATORY_IGNORE_PROPERTIES = new String[]{"jcr:primaryType", "jcr:lastModified", "jcr:lastModifiedBy", "jcr:mixinTypes", "jcr:created", "jcr:createdBy", "recreateOnUpdate", "forceReindex", "delete", "ignore", "disable", "reindex", "reindexCount", "seed"};
    static final String[] MANDATORY_EXCLUDE_SUB_TREES = new String[]{"[oak:QueryIndexDefinition]/facets/jcr:content", "[oak:Unstructured]/facets/jcr:content"};
    static final String[] MANDATORY_EXCLUDE_NODE_NAMES = new String[0];
    private static final String[] NAME_PROPERTIES = new String[]{"propertyNames", "declaringNodeTypes"};
    static final String SERVICE_NAME = "ensure-oak-index";
    private final EnsureOakIndex ensureOakIndex;
    private final List<String> ignoreProperties = new ArrayList<String>();
    private final List<String> excludeSubTrees = new ArrayList<String>();
    private final List<String> excludeNodeNames = new ArrayList<String>();
    private String oakIndexesPath;
    private String ensureDefinitionsPath;

    EnsureOakIndexJobHandler(EnsureOakIndex ensureOakIndex, String oakIndexPath, String ensureDefinitionsPath) {
        this.ensureOakIndex = ensureOakIndex;
        this.oakIndexesPath = oakIndexPath;
        this.ensureDefinitionsPath = ensureDefinitionsPath;
        this.ignoreProperties.addAll(Arrays.asList(MANDATORY_IGNORE_PROPERTIES));
        this.excludeSubTrees.addAll(Arrays.asList(MANDATORY_EXCLUDE_SUB_TREES));
        this.excludeNodeNames.addAll(Arrays.asList(MANDATORY_EXCLUDE_NODE_NAMES));
        if (ensureOakIndex != null) {
            this.ignoreProperties.addAll(ensureOakIndex.getIgnoreProperties());
        }
    }

    @Override
    public void run() {
        Map<String, String> authInfo = Collections.singletonMap("sling.service.subservice", SERVICE_NAME);
        try (ResourceResolver resourceResolver = this.ensureOakIndex.getResourceResolverFactory().getServiceResourceResolver(authInfo);){
            try {
                this.ensure(resourceResolver, this.ensureDefinitionsPath, this.oakIndexesPath);
            }
            catch (IOException e) {
                log.error("Could not ensure management of Oak Index [ {} ]", (Object)this.oakIndexesPath, (Object)e);
            }
        }
        catch (IllegalArgumentException e) {
            log.error("Could not ensure oak indexes due to illegal arguments.", (Throwable)e);
        }
        catch (LoginException e) {
            log.error("Could not get an admin resource resolver to ensure Oak Indexes", (Throwable)e);
        }
        catch (Exception e) {
            log.error("Unknown error occurred while ensuring indexes", (Throwable)e);
        }
    }

    private void ensure(ResourceResolver resourceResolver, String ensureDefinitionsPath, String oakIndexesPath) throws RepositoryException, IOException {
        Resource ensureDefinitions = resourceResolver.getResource(ensureDefinitionsPath);
        Resource oakIndexes = resourceResolver.getResource(oakIndexesPath);
        if (ensureDefinitions == null) {
            throw new IllegalArgumentException("Unable to find Ensure Definitions resource at [ " + ensureDefinitionsPath + " ]");
        }
        if (oakIndexes == null) {
            throw new IllegalArgumentException("Unable to find Oak Indexes resource at [ " + oakIndexesPath + " ]");
        }
        Iterator ensureDefinitionsIterator = ensureDefinitions.listChildren();
        if (!ensureDefinitionsIterator.hasNext()) {
            log.info("Ensure Definitions path [ {} ] does NOT have children to process", (Object)ensureDefinitions.getPath());
        }
        ArrayList<Resource> delayedProcessing = new ArrayList<Resource>();
        while (ensureDefinitionsIterator.hasNext()) {
            Resource ensureDefinition = (Resource)ensureDefinitionsIterator.next();
            Resource oakIndex = oakIndexes.getChild(ensureDefinition.getName());
            log.debug("Ensuring Oak Index [ {} ] ~> [ {}/{} ]", new Object[]{ensureDefinition.getPath(), oakIndexesPath, ensureDefinition.getName()});
            if (this.handleLightWeightIndexOperations(ensureDefinition, oakIndex)) continue;
            delayedProcessing.add(ensureDefinition);
        }
        if (resourceResolver.hasChanges()) {
            log.info("Saving all DELETES, IGNORES, and DISABLES to [ {} ]", (Object)oakIndexesPath);
            resourceResolver.commit();
            log.debug("Commit succeeded");
        }
        for (Resource ensureDefinition : delayedProcessing) {
            Resource oakIndex = oakIndexes.getChild(ensureDefinition.getName());
            this.handleHeavyWeightIndexOperations(oakIndexes, ensureDefinition, oakIndex);
        }
        if (resourceResolver.hasChanges()) {
            log.info("Saving all CREATE, UPDATES, and RE-INDEXES, re-indexing may start now.");
            resourceResolver.commit();
            log.debug("Commit succeeded");
        }
    }

    void handleHeavyWeightIndexOperations(Resource oakIndexes, @NotNull Resource ensureDefinition, @Nullable Resource oakIndex) throws RepositoryException, IOException {
        ValueMap ensureDefinitionProperties = ensureDefinition.getValueMap();
        try {
            Resource ensuredOakIndex = null;
            this.validateEnsureDefinition(ensureDefinition);
            if (oakIndex == null) {
                ensuredOakIndex = this.create(ensureDefinition, oakIndexes);
                if (((Boolean)ensureDefinitionProperties.get(PN_FORCE_REINDEX, (Object)false)).booleanValue()) {
                    this.forceRefresh(ensuredOakIndex);
                }
            } else {
                boolean forceReindex = (Boolean)ensureDefinitionProperties.get(PN_FORCE_REINDEX, (Object)false);
                if (((Boolean)ensureDefinitionProperties.get(PN_RECREATE_ON_UPDATE, (Object)false)).booleanValue()) {
                    this.delete(oakIndex);
                    this.create(ensureDefinition, oakIndexes);
                } else {
                    this.update(ensureDefinition, oakIndexes, forceReindex);
                }
            }
        }
        catch (EnsureOakIndex.OakIndexDefinitionException e) {
            log.error("Skipping processing of {}", (Object)ensureDefinition.getPath(), (Object)e);
        }
    }

    boolean handleLightWeightIndexOperations(@NotNull Resource ensureDefinition, @Nullable Resource oakIndex) throws RepositoryException, PersistenceException {
        ValueMap ensureDefinitionProperties = ensureDefinition.getValueMap();
        boolean result = true;
        if (((Boolean)ensureDefinitionProperties.get(PN_IGNORE, (Object)false)).booleanValue()) {
            log.debug("Ignoring index definition at [ {} ]", (Object)ensureDefinition.getPath());
        } else if (((Boolean)ensureDefinitionProperties.get(PN_DELETE, (Object)false)).booleanValue()) {
            if (oakIndex != null) {
                this.delete(oakIndex);
            } else {
                log.info("Requesting deletion of a non-existent Oak Index at [ {}/{} ].\nConsider removing the Ensure Definition at [ {} ] if it is no longer needed.", new Object[]{this.oakIndexesPath, ensureDefinition.getName(), ensureDefinition.getPath()});
            }
        } else if (((Boolean)ensureDefinitionProperties.get(PN_DISABLE, (Object)false)).booleanValue()) {
            if (oakIndex != null) {
                this.disableIndex(oakIndex);
            } else {
                log.info("Requesting disable of a non-existent Oak Index at [ {}/{} ].\nConsider removing the Ensure Definition at [ {} ] if it is no longer needed.", new Object[]{this.oakIndexesPath, ensureDefinition.getName(), ensureDefinition.getPath()});
            }
        } else {
            result = false;
        }
        return result;
    }

    public void forceRefresh(@NotNull Resource oakIndex) throws PersistenceException {
        ModifiableValueMap mvm = (ModifiableValueMap)oakIndex.adaptTo(ModifiableValueMap.class);
        if (mvm == null) {
            String msg = String.format("Cannot adapt %s to a ModifiableValueMap (permissions?)", oakIndex.getPath());
            throw new PersistenceException(msg);
        }
        mvm.put((Object)PN_REINDEX, (Object)true);
        log.info("Forcing re-index of [ {} ]", (Object)oakIndex.getPath());
    }

    public Resource create(@NotNull Resource ensuredDefinition, @NotNull Resource oakIndexes) throws RepositoryException {
        Node oakIndex = JcrUtil.copy((Node)((Node)ensuredDefinition.adaptTo(Node.class)), (Node)((Node)oakIndexes.adaptTo(Node.class)), (String)ensuredDefinition.getName());
        oakIndex.setPrimaryType(NT_OAK_QUERY_INDEX_DEFINITION);
        oakIndex.setProperty("jcr:created", Calendar.getInstance());
        oakIndex.setProperty("jcr:createdBy", ENSURE_OAK_INDEX_USER_NAME);
        log.info("Created Oak Index at [ {} ] with Ensure Definition [ {} ]", (Object)oakIndex.getPath(), (Object)ensuredDefinition.getPath());
        return ensuredDefinition.getResourceResolver().getResource(oakIndex.getPath());
    }

    public Resource update(@NotNull Resource ensureDefinition, @NotNull Resource oakIndexes, boolean forceReindex) throws RepositoryException, IOException {
        ValueMap ensureDefinitionProperties = ensureDefinition.getValueMap();
        Resource oakIndex = oakIndexes.getChild(ensureDefinition.getName());
        Node oakIndexNode = (Node)oakIndex.adaptTo(Node.class);
        Node ensureDefinitionNode = (Node)ensureDefinition.adaptTo(Node.class);
        if (!this.needsUpdate(ensureDefinition, oakIndex)) {
            if (((Boolean)ensureDefinitionProperties.get(PN_FORCE_REINDEX, (Object)false)).booleanValue()) {
                log.info("Skipping update... Oak Index at [ {} ] is the same as [ {} ] and forceIndex flag is ignored", (Object)oakIndex.getPath(), (Object)ensureDefinition.getPath());
            } else {
                log.info("Skipping update... Oak Index at [ {} ] is the same as [ {} ]", (Object)oakIndex.getPath(), (Object)ensureDefinition.getPath());
            }
            return null;
        }
        Iterator<Property> existingOakIndexProperties = this.copyIterator((Iterator<Property>)oakIndexNode.getProperties());
        while (existingOakIndexProperties.hasNext()) {
            Property property = existingOakIndexProperties.next();
            String propertyName = property.getName();
            if (this.ignoreProperties.contains(propertyName)) continue;
            JcrUtil.setProperty((Node)oakIndexNode, (String)propertyName, null);
        }
        Iterator<Property> addProperties = this.copyIterator((Iterator<Property>)ensureDefinitionNode.getProperties());
        while (addProperties.hasNext()) {
            Property property = addProperties.next();
            if (this.ignoreProperties.contains(property.getName())) continue;
            if (ArrayUtils.contains((Object[])NAME_PROPERTIES, (Object)property.getName()) && property.getType() != 7) {
                log.warn("{}@{} property should be of type: Name[]", (Object)oakIndex.getPath(), (Object)property.getName());
            }
            JcrUtil.copy((Property)property, (Node)oakIndexNode, (String)property.getName());
        }
        JcrUtil.setProperty((Node)oakIndexNode, (String)"jcr:lastModifiedBy", (Object)ENSURE_OAK_INDEX_USER_NAME);
        JcrUtil.setProperty((Node)oakIndexNode, (String)"jcr:lastModified", (Object)Calendar.getInstance());
        Iterator children = oakIndex.listChildren();
        while (children.hasNext()) {
            ((Node)((Resource)children.next()).adaptTo(Node.class)).remove();
        }
        children = ensureDefinition.listChildren();
        while (children.hasNext()) {
            Resource child = (Resource)children.next();
            JcrUtil.copy((Node)((Node)child.adaptTo(Node.class)), (Node)((Node)oakIndex.adaptTo(Node.class)), (String)child.getName());
        }
        if (forceReindex) {
            log.info("Updated Oak Index at [ {} ] with configuration [ {} ], triggering reindex", (Object)oakIndex.getPath(), (Object)ensureDefinition.getPath());
            this.forceRefresh(oakIndex);
        } else {
            log.warn("Updated Oak Index at [ {} ] with configuration [ {} ], but no reindex requested!", (Object)oakIndex.getPath(), (Object)ensureDefinition.getPath());
        }
        return oakIndex;
    }

    public void disableIndex(@NotNull Resource oakIndex) throws PersistenceException {
        ModifiableValueMap oakIndexProperties = (ModifiableValueMap)oakIndex.adaptTo(ModifiableValueMap.class);
        oakIndexProperties.put((Object)PN_TYPE, (Object)DISABLED);
        log.info("Disabled index at {}", (Object)oakIndex.getPath());
    }

    boolean needsUpdate(@NotNull Resource ensureDefinition, @NotNull Resource oakIndex) throws IOException, RepositoryException {
        Session session = (Session)ensureDefinition.getResourceResolver().adaptTo(Session.class);
        ChecksumGenerator checksumGenerator = this.ensureOakIndex.getChecksumGenerator();
        CustomChecksumGeneratorOptions ensureDefinitionOptions = new CustomChecksumGeneratorOptions();
        ensureDefinitionOptions.addIncludedNodeTypes(new String[]{NT_OAK_UNSTRUCTURED});
        ensureDefinitionOptions.addExcludedProperties(this.ignoreProperties);
        ensureDefinitionOptions.addExcludedSubTrees(this.excludeSubTrees);
        ensureDefinitionOptions.addExcludedNodeNames(this.excludeNodeNames);
        Map<String, String> srcChecksum = checksumGenerator.generateChecksums(session, ensureDefinition.getPath(), ensureDefinitionOptions);
        CustomChecksumGeneratorOptions oakIndexOptions = new CustomChecksumGeneratorOptions();
        oakIndexOptions.addIncludedNodeTypes(new String[]{NT_OAK_QUERY_INDEX_DEFINITION});
        oakIndexOptions.addExcludedProperties(this.ignoreProperties);
        oakIndexOptions.addExcludedSubTrees(this.excludeSubTrees);
        oakIndexOptions.addExcludedNodeNames(this.excludeNodeNames);
        Map<String, String> destChecksum = checksumGenerator.generateChecksums(session, oakIndex.getPath(), oakIndexOptions);
        return !StringUtils.equals((CharSequence)srcChecksum.get(ensureDefinition.getPath()), (CharSequence)destChecksum.get(oakIndex.getPath()));
    }

    public void delete(@NotNull Resource oakIndex) throws RepositoryException {
        if (oakIndex.adaptTo(Node.class) != null) {
            ((Node)oakIndex.adaptTo(Node.class)).remove();
        } else {
            log.warn("Oak Index at [ {} ] could not be adapted to a Node for removal.", (Object)oakIndex.getPath());
        }
    }

    public void validateEnsureDefinition(@NotNull Resource ensureDefinition) throws RepositoryException, EnsureOakIndex.OakIndexDefinitionException {
        Node node = (Node)ensureDefinition.adaptTo(Node.class);
        if (node == null) {
            throw new EnsureOakIndex.OakIndexDefinitionException("Resource " + ensureDefinition.getPath() + " cannot be adapted to a Node");
        }
        if (!node.isNodeType(NT_OAK_UNSTRUCTURED)) {
            throw new EnsureOakIndex.OakIndexDefinitionException("Resource " + ensureDefinition.getPath() + " is not of jcr:primaryType " + NT_OAK_UNSTRUCTURED);
        }
        ValueMap properties = ensureDefinition.getValueMap();
        if (StringUtils.isBlank((CharSequence)((CharSequence)properties.get(PN_TYPE, String.class)))) {
            throw new EnsureOakIndex.OakIndexDefinitionException("Ensure Definition at " + ensureDefinition.getPath() + " missing required property 'type'");
        }
    }

    private Iterator<Property> copyIterator(Iterator<Property> src) {
        ArrayList<Property> dest = new ArrayList<Property>();
        while (src.hasNext()) {
            dest.add(src.next());
        }
        return dest.iterator();
    }
}

