/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.acs.commons.redirects.servlets;

import acscommons.com.google.common.collect.ImmutableMap;
import com.adobe.acs.commons.redirects.filter.RedirectFilterMBean;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.io.Writer;
import java.util.HashMap;
import javax.servlet.Servlet;
import javax.servlet.ServletException;
import org.apache.commons.lang3.StringUtils;
import org.apache.sling.api.SlingHttpServletRequest;
import org.apache.sling.api.SlingHttpServletResponse;
import org.apache.sling.api.resource.PersistenceException;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.resource.ResourceResolver;
import org.apache.sling.api.servlets.SlingAllMethodsServlet;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.component.annotations.ReferenceCardinality;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(service={Servlet.class}, immediate=true, name="CreateRedirectConfigurationServlet", property={"sling.servlet.label=ACS AEM Commons - Create Redirect Configuration", "sling.servlet.methods=POST", "sling.servlet.selectors=create", "sling.servlet.resourceTypes=acs-commons/components/utilities/manage-redirects/redirects"})
public class CreateRedirectConfigurationServlet
extends SlingAllMethodsServlet {
    public static final String REDIRECTS_RESOURCE_PATH = "acs-commons/components/utilities/manage-redirects/redirects";
    private static final String REQ_PARAM_PATH = "path";
    private static final String REQ_PARAM_CTX_PREFIX = "contextPrefix";
    private static final Logger log = LoggerFactory.getLogger(CreateRedirectConfigurationServlet.class);
    private static final long serialVersionUID = -3564475196678277711L;
    @Reference(cardinality=ReferenceCardinality.OPTIONAL)
    transient RedirectFilterMBean redirectFilter;

    protected void doPost(SlingHttpServletRequest request, SlingHttpServletResponse response) throws ServletException, IOException {
        response.setContentType("application/json");
        String rootPath = request.getParameter(REQ_PARAM_PATH);
        if (StringUtils.isEmpty((CharSequence)rootPath) || !rootPath.startsWith("/conf")) {
            throw new IllegalArgumentException("root path should be not empty and start with /conf");
        }
        ResourceResolver resolver = request.getResourceResolver();
        Resource root = resolver.getResource(rootPath);
        if (root == null) {
            throw new IllegalArgumentException("not found: " + rootPath);
        }
        HashMap<String, String> rsp = new HashMap<String, String>();
        ObjectMapper om = new ObjectMapper();
        try {
            Resource config;
            String bucketName = this.redirectFilter == null ? "settings" : this.redirectFilter.getBucket();
            String configName = this.redirectFilter == null ? "redirects" : this.redirectFilter.getConfigName();
            Resource bucket = root.getChild(bucketName);
            if (bucket == null) {
                bucket = resolver.create(root, bucketName, ImmutableMap.of("jcr:primaryType", "sling:Folder"));
                log.info("created {}", (Object)bucket.getPath());
            }
            if ((config = bucket.getChild(configName)) == null) {
                String contextPrefix = StringUtils.defaultString((String)request.getParameter(REQ_PARAM_CTX_PREFIX));
                config = resolver.create(bucket, configName, ImmutableMap.of("jcr:primaryType", "sling:Folder", "sling:resourceType", REDIRECTS_RESOURCE_PATH, REQ_PARAM_CTX_PREFIX, contextPrefix));
                log.info("created {} with context prefix '{}'", (Object)config.getPath(), (Object)contextPrefix);
                resolver.commit();
                rsp.put(REQ_PARAM_PATH, config.getPath());
                rsp.put(REQ_PARAM_CTX_PREFIX, contextPrefix);
            } else {
                resolver.revert();
                String msg = "Configuration already exist: " + rootPath + "/" + bucketName + "/" + configName;
                rsp.put("message", msg);
                response.setStatus(409);
            }
        }
        catch (PersistenceException e) {
            rsp.put("message", e.getMessage());
            response.setStatus(500);
            log.error("failed to create configuration", (Throwable)e);
        }
        om.writeValue((Writer)response.getWriter(), rsp);
    }
}

