/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.acs.commons.workflow.process.impl;

import com.adobe.acs.commons.util.ParameterUtil;
import com.adobe.acs.commons.util.WorkflowHelper;
import com.adobe.granite.workflow.WorkflowException;
import com.adobe.granite.workflow.WorkflowSession;
import com.adobe.granite.workflow.exec.WorkItem;
import com.adobe.granite.workflow.exec.WorkflowData;
import com.adobe.granite.workflow.exec.WorkflowProcess;
import com.adobe.granite.workflow.metadata.MetaDataMap;
import com.adobe.granite.workflow.model.WorkflowModel;
import com.day.cq.commons.inherit.HierarchyNodeInheritanceValueMap;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.apache.felix.scr.annotations.Component;
import org.apache.felix.scr.annotations.Properties;
import org.apache.felix.scr.annotations.Property;
import org.apache.felix.scr.annotations.Reference;
import org.apache.felix.scr.annotations.Service;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.resource.ResourceResolver;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component
@Properties(value={@Property(label="Workflow Label", name="process.label", value={"Workflow Delegation"}, description="Invokes a new workflow for this payload based on a content-hierarchy based configuration")})
@Service
public class WorkflowDelegationStep
implements WorkflowProcess {
    private static final Logger log = LoggerFactory.getLogger(WorkflowDelegationStep.class);
    @Reference
    WorkflowHelper workflowHelper;
    private static final String WORKFLOW_PROPERTY_NAME = "workflowModelProperty";
    private static final String DEFAULT_WORKFLOW_MODEL = "defaultWorkflowModel";
    private static final String TERMINATE_ON_DELEGATION = "terminateWorkflowOnDelegation";

    public void execute(WorkItem workItem, WorkflowSession workflowSession, MetaDataMap metadata) throws WorkflowException {
        Map<String, String> args = this.getProcessArgsMap(metadata);
        String propertyName = args.get(WORKFLOW_PROPERTY_NAME);
        String defaultWorkflowModelId = args.get(DEFAULT_WORKFLOW_MODEL);
        boolean terminateOnDelegation = Boolean.parseBoolean(StringUtils.lowerCase((String)args.get(TERMINATE_ON_DELEGATION)));
        if (StringUtils.isBlank((CharSequence)propertyName)) {
            throw new WorkflowException("PROCESS_ARG [ workflowModelProperty ] not defined");
        }
        log.debug("Provided PROCESS_ARGS: propertyName = [ {} ], Default Workflow Model = [ {} ]", (Object)propertyName, (Object)defaultWorkflowModelId);
        ResourceResolver resolver = null;
        WorkflowData wfData = workItem.getWorkflowData();
        if (!this.workflowHelper.isPathTypedPayload(wfData)) {
            log.warn("Could not locate a JCR_PATH payload for this workflow. Skipping delegation.");
            return;
        }
        String path = wfData.getPayload().toString();
        resolver = this.workflowHelper.getResourceResolver(workflowSession);
        if (resolver == null) {
            throw new WorkflowException("Could not adapt the WorkflowSession to a ResourceResolver. Something has gone terribly wrong!");
        }
        Resource pageOrAssetResource = this.workflowHelper.getPageOrAssetResource(resolver, path);
        if (pageOrAssetResource == null) {
            log.warn("Could not resolve [ {} ] to an Asset or Page. Skipping delegation.", (Object)path);
            return;
        }
        Resource jcrContentResource = pageOrAssetResource.getChild("jcr:content");
        if (jcrContentResource == null) {
            throw new WorkflowException(String.format("Could not find a child jcr:content resource for [ %s ]", pageOrAssetResource.getPath()));
        }
        HierarchyNodeInheritanceValueMap inheritance = new HierarchyNodeInheritanceValueMap(jcrContentResource);
        String foundWorkflowModelId = StringUtils.trim((String)((String)inheritance.getInherited(propertyName, String.class)));
        WorkflowModel delegateWorkflowModel = this.getDelegateWorkflowModel(workflowSession, foundWorkflowModelId, defaultWorkflowModelId);
        WorkflowData newProcessWfData = workflowSession.newWorkflowData("JCR_PATH", wfData.getPayload());
        if (delegateWorkflowModel != null) {
            workflowSession.startWorkflow(delegateWorkflowModel, newProcessWfData);
            log.info("Delegating payload [ {} ] to Workflow Model [ {} ]", wfData.getPayload(), (Object)delegateWorkflowModel.getId());
            if (terminateOnDelegation) {
                log.info("Terminating current workflow due to PROCESS_ARGS[ {} ] = [ {} ]", (Object)TERMINATE_ON_DELEGATION, (Object)terminateOnDelegation);
                workflowSession.terminateWorkflow(workItem.getWorkflow());
            }
        } else {
            log.warn("No valid delegate Workflow Model could be located. Skipping workflow delegation.");
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private WorkflowModel getDelegateWorkflowModel(WorkflowSession workflowSession, String foundWorkflowModelId, String defaultWorkflowModelId) throws WorkflowException {
        WorkflowModel workflowModel = null;
        if (StringUtils.isNotBlank((CharSequence)foundWorkflowModelId)) {
            workflowModel = this.getWorkflowModel(workflowSession, foundWorkflowModelId);
            if (workflowModel == null) throw new WorkflowException(String.format("Could not find configured Workflow Model at [ %s ]", foundWorkflowModelId));
            log.debug("Using configured delegate Workflow Model [ {} ]", (Object)workflowModel.getId());
            return workflowModel;
        } else {
            if (!StringUtils.isNotBlank((CharSequence)defaultWorkflowModelId)) return workflowModel;
            workflowModel = this.getWorkflowModel(workflowSession, defaultWorkflowModelId);
            if (workflowModel == null) throw new WorkflowException(String.format("Could not find default Workflow Model at [ %s ]", defaultWorkflowModelId));
            log.debug("Using default delegate Workflow Model [ {} ]", (Object)workflowModel.getId());
        }
        return workflowModel;
    }

    private WorkflowModel getWorkflowModel(WorkflowSession workflowSession, String workflowModelId) {
        workflowModelId = StringUtils.stripToEmpty((String)workflowModelId);
        WorkflowModel workflowModel = null;
        if (StringUtils.isNotBlank((CharSequence)workflowModelId)) {
            ResourceResolver resourceResolver;
            Resource resource;
            if (!workflowModelId.endsWith("/jcr:content/model") && (resource = (resourceResolver = this.workflowHelper.getResourceResolver(workflowSession)).getResource(workflowModelId + "/jcr:content/model")) != null && StringUtils.equals((CharSequence)((CharSequence)resource.getValueMap().get("jcr:primaryType", String.class)), (CharSequence)"cq:WorkflowModel")) {
                workflowModelId = resource.getPath();
            }
            try {
                workflowModel = workflowSession.getModel(workflowModelId);
            }
            catch (WorkflowException e) {
                log.warn("Could not find Workflow Model for [ {} ]", (Object)workflowModelId);
            }
        }
        return workflowModel;
    }

    private Map<String, String> getProcessArgsMap(MetaDataMap metaDataMap) {
        String processArgs = (String)metaDataMap.get("PROCESS_ARGS", (Object)"");
        return ParameterUtil.toMap(StringUtils.split((String)processArgs, (String)System.getProperty("line.separator")), "=");
    }

    protected void bindWorkflowHelper(WorkflowHelper workflowHelper) {
        this.workflowHelper = workflowHelper;
    }

    protected void unbindWorkflowHelper(WorkflowHelper workflowHelper) {
        if (this.workflowHelper == workflowHelper) {
            this.workflowHelper = null;
        }
    }
}

