/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.acs.commons.analysis.jcrchecksum.impl.options;

import aQute.bnd.annotation.ProviderType;
import com.adobe.acs.commons.analysis.jcrchecksum.impl.options.AbstractChecksumGeneratorOptions;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.Charset;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import org.apache.commons.lang.StringUtils;
import org.apache.sling.api.SlingHttpServletRequest;
import org.apache.sling.api.request.RequestParameter;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.resource.ResourceResolver;

@ProviderType
public class RequestChecksumGeneratorOptions
extends AbstractChecksumGeneratorOptions {
    public RequestChecksumGeneratorOptions(SlingHttpServletRequest request) throws IOException {
        this.addIncludedNodeTypes(request.getParameterValues("nodeTypes"));
        this.addExcludedNodeTypes(request.getParameterValues("excludeNodeTypes"));
        this.addExcludedProperties(request.getParameterValues("excludeProperties"));
        this.addSortedProperties(request.getParameterValues("sortedProperties"));
    }

    public static Set<String> getPaths(SlingHttpServletRequest request) throws IOException {
        HashSet<String> paths = new HashSet<String>();
        if (request.getParameterValues("paths") != null) {
            String[] pathArr;
            for (String path : pathArr = request.getParameterValues("paths")) {
                if (path.length() <= 0) continue;
                paths.add(path);
            }
        }
        paths.addAll(RequestChecksumGeneratorOptions.getPathsFromQuery(request.getResourceResolver(), request.getParameter("queryType"), request.getParameter("query")));
        RequestParameter data = request.getRequestParameter("data");
        if (data != null && data.getInputStream() != null) {
            paths.addAll(RequestChecksumGeneratorOptions.getPathsFromInputstream(data.getInputStream(), request.getCharacterEncoding()));
        }
        return paths;
    }

    private static Set<String> getPathsFromQuery(ResourceResolver resourceResolver, String language, String query) {
        if (StringUtils.isBlank((String)query)) {
            return Collections.EMPTY_SET;
        }
        HashSet<String> paths = new HashSet<String>();
        language = StringUtils.defaultIfEmpty((String)language, (String)"xpath");
        Iterator resources = resourceResolver.findResources(query, language);
        while (resources.hasNext()) {
            paths.add(((Resource)resources.next()).getPath());
        }
        return paths;
    }

    private static Set<String> getPathsFromInputstream(InputStream is, String encoding) throws IOException {
        if (is == null) {
            return Collections.EMPTY_SET;
        }
        HashSet<String> paths = new HashSet<String>();
        encoding = encoding != null ? encoding : Charset.defaultCharset().name();
        try (BufferedReader br = new BufferedReader(new InputStreamReader(is, encoding));){
            String path;
            while ((path = br.readLine()) != null) {
                paths.add(path);
            }
        }
        return paths;
    }
}

