/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.acs.commons.dam;

import aQute.bnd.annotation.ConsumerType;
import com.adobe.acs.commons.util.WorkflowHelper;
import com.day.cq.dam.api.Asset;
import com.day.cq.dam.api.Rendition;
import com.day.cq.dam.api.RenditionPicker;
import com.day.cq.dam.commons.util.PrefixRenditionPicker;
import com.day.cq.workflow.WorkflowException;
import com.day.cq.workflow.WorkflowSession;
import com.day.cq.workflow.exec.WorkItem;
import com.day.cq.workflow.metadata.MetaDataMap;
import com.day.image.Layer;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import javax.imageio.IIOException;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ConsumerType
public abstract class AbstractRenditionModifyingProcess {
    private static final int MAX_GIF_QUALITY = 255;
    private static final String DEFAULT_QUALITY = "60";
    private static final String ARG_QUALITY = "quality";
    private static final String ARG_RENDITION_NAME = "renditionName";
    private static final Logger log = LoggerFactory.getLogger(AbstractRenditionModifyingProcess.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void execute(WorkItem workItem, WorkflowSession workflowSession, MetaDataMap metaData, WorkflowHelper workflowHelper) throws WorkflowException {
        String qualityStr;
        String[] args = workflowHelper.buildArguments(metaData);
        String renditionName = workflowHelper.getValuesFromArgs(ARG_RENDITION_NAME, args).size() > 0 ? workflowHelper.getValuesFromArgs(ARG_RENDITION_NAME, args).get(0) : null;
        String string = qualityStr = workflowHelper.getValuesFromArgs(ARG_QUALITY, args).size() > 0 ? workflowHelper.getValuesFromArgs(ARG_QUALITY, args).get(0) : DEFAULT_QUALITY;
        if (renditionName == null) {
            log.warn("Rendition name was not configured in arguments. Skipping.");
            return;
        }
        WorkflowHelper.AssetResourceResolverPair pair = workflowHelper.getAssetFromPayload(workItem, workflowSession);
        if (pair == null) {
            return;
        }
        Rendition rendition = pair.asset.getRendition((RenditionPicker)new PrefixRenditionPicker(renditionName));
        if (rendition == null) {
            log.warn("Rendition name {} was not available for asset {}. Skipping.", (Object)renditionName, (Object)pair.asset);
            return;
        }
        Layer layer = null;
        try {
            layer = new Layer(rendition.getStream());
            layer = this.processLayer(layer, rendition, workflowSession, args);
            String mimetype = layer.getMimeType();
            double quality = mimetype.equals("image/gif") ? workflowHelper.getQuality(255.0, qualityStr) : workflowHelper.getQuality(1.0, qualityStr);
            this.saveImage(pair.asset, rendition, layer, mimetype, quality, workflowHelper);
        }
        catch (IIOException e) {
            log.warn("Unable to load image layer from " + rendition.getPath(), (Throwable)e);
        }
        catch (IOException e) {
            log.warn("Unable to load image layer from " + rendition.getPath(), (Throwable)e);
        }
        finally {
            if (layer != null) {
                layer.dispose();
                layer = null;
            }
            pair.resourceResolver.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void saveImage(Asset asset, Rendition toReplace, Layer layer, String mimetype, double quality, WorkflowHelper workflowHelper) throws IOException {
        File tmpFile = File.createTempFile(this.getTempFileSpecifier(), "." + workflowHelper.getExtension(mimetype));
        FileOutputStream out = FileUtils.openOutputStream((File)tmpFile);
        FileInputStream is = null;
        try {
            layer.write(mimetype, quality, (OutputStream)out);
            is = FileUtils.openInputStream((File)tmpFile);
            asset.addRendition(toReplace.getName(), (InputStream)is, mimetype);
        }
        catch (Throwable throwable) {
            IOUtils.closeQuietly((OutputStream)out);
            IOUtils.closeQuietly(is);
            FileUtils.deleteQuietly((File)tmpFile);
            throw throwable;
        }
        IOUtils.closeQuietly((OutputStream)out);
        IOUtils.closeQuietly((InputStream)is);
        FileUtils.deleteQuietly((File)tmpFile);
    }

    protected abstract String getTempFileSpecifier();

    protected abstract Layer processLayer(Layer var1, Rendition var2, WorkflowSession var3, String[] var4);
}

