/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.acs.commons.dam.audio.impl;

import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.attribute.FileAttribute;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FFMpegAudioUtils {
    private static final Logger log = LoggerFactory.getLogger(FFMpegAudioUtils.class);

    private FFMpegAudioUtils() {
    }

    public static File resolveWorkingDir(String slingHome, String path) {
        File workingDir;
        if (path == null) {
            path = "";
        }
        if (!(workingDir = new File(path = path.replace('/', File.separatorChar))).isAbsolute()) {
            File baseDir = slingHome == null ? new File("").getAbsoluteFile() : new File(slingHome).getAbsoluteFile();
            workingDir = new File(baseDir, path).getAbsoluteFile();
        }
        try {
            log.info("ffmpeg working directory: {}", (Object)workingDir.getCanonicalPath());
        }
        catch (IOException e) {
            log.info("ffmpeg working directory: {}", (Object)workingDir.getAbsolutePath());
        }
        return workingDir;
    }

    public static final File createTempDir(File parentDir) throws IOException {
        return Files.createTempDirectory(parentDir.toPath(), "cqdam", new FileAttribute[0]).toFile();
    }
}

