/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.acs.commons.dam.audio.watson.impl;

import com.adobe.acs.commons.dam.audio.watson.impl.TranscriptionService;
import com.adobe.acs.commons.http.HttpClientFactory;
import com.adobe.acs.commons.http.JsonObjectResponseHandler;
import java.io.InputStream;
import org.apache.commons.lang3.StringUtils;
import org.apache.felix.scr.annotations.Component;
import org.apache.felix.scr.annotations.Reference;
import org.apache.felix.scr.annotations.Service;
import org.apache.http.client.ResponseHandler;
import org.apache.http.client.fluent.Request;
import org.apache.sling.commons.json.JSONArray;
import org.apache.sling.commons.json.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component
@Service
public class TranscriptionServiceImpl
implements TranscriptionService {
    private static final Logger log = LoggerFactory.getLogger(TranscriptionServiceImpl.class);
    private static final JsonObjectResponseHandler HANDLER = new JsonObjectResponseHandler();
    @Reference(target="(factory.name=watson-speech-to-text)")
    private HttpClientFactory httpClientFactory;

    @Override
    public String startTranscriptionJob(InputStream stream, String mimeType) {
        Request request = this.httpClientFactory.post("/speech-to-text/api/v1/recognitions?continuous=true&timestamps=true").addHeader("Content-Type", mimeType).bodyStream(stream);
        try {
            JSONObject json = (JSONObject)this.httpClientFactory.getExecutor().execute(request).handleResponse((ResponseHandler)HANDLER);
            log.trace("content: {}", (Object)json.toString(2));
            return json.getString("id");
        }
        catch (Exception e) {
            log.error("error submitting job", (Throwable)e);
            return null;
        }
    }

    @Override
    public TranscriptionService.Result getResult(String jobId) {
        log.debug("getting result for {}", (Object)jobId);
        Request request = this.httpClientFactory.get("/speech-to-text/api/v1/recognitions/" + jobId);
        try {
            JSONObject json = (JSONObject)this.httpClientFactory.getExecutor().execute(request).handleResponse((ResponseHandler)HANDLER);
            log.trace("content: {}", (Object)json.toString(2));
            if (json.getString("status").equals("completed")) {
                JSONArray results = json.getJSONArray("results").getJSONObject(0).getJSONArray("results");
                StringBuilder builder = new StringBuilder();
                for (int i = 0; i < results.length(); ++i) {
                    JSONObject firstAlternative;
                    String line;
                    JSONObject result = results.getJSONObject(i);
                    if (!result.getBoolean("final") || !StringUtils.isNotBlank((CharSequence)(line = (firstAlternative = result.getJSONArray("alternatives").getJSONObject(0)).getString("transcript")))) continue;
                    double firstTimestamp = firstAlternative.getJSONArray("timestamps").getJSONArray(0).getDouble(1);
                    builder.append("[").append(firstTimestamp).append("s]: ").append(line).append("\n");
                }
                String concatenated = builder.toString();
                concatenated = concatenated.replace("%HESITATION ", "");
                return new ResultImpl(true, concatenated);
            }
            return new ResultImpl(false, null);
        }
        catch (Exception e) {
            log.error("Unable to get result. assuming failure.", (Throwable)e);
            return new ResultImpl(true, "error");
        }
    }

    protected void bindHttpClientFactory(HttpClientFactory httpClientFactory) {
        this.httpClientFactory = httpClientFactory;
    }

    protected void unbindHttpClientFactory(HttpClientFactory httpClientFactory) {
        if (this.httpClientFactory == httpClientFactory) {
            this.httpClientFactory = null;
        }
    }

    private static class ResultImpl
    implements TranscriptionService.Result {
        private final boolean completed;
        private final String content;

        public ResultImpl(boolean completed, String content) {
            this.completed = completed;
            this.content = content;
        }

        @Override
        public boolean isCompleted() {
            return this.completed;
        }

        @Override
        public String getContent() {
            return this.content;
        }
    }
}

