/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.acs.commons.data;

import aQute.bnd.annotation.ProviderType;
import com.adobe.acs.commons.data.CompositeVariant;
import com.adobe.acs.commons.data.Variant;
import java.io.IOException;
import java.io.InputStream;
import java.lang.constant.Constable;
import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import org.apache.commons.lang3.StringUtils;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.xssf.usermodel.XSSFSheet;
import org.apache.poi.xssf.usermodel.XSSFWorkbook;
import org.apache.sling.api.request.RequestParameter;

@ProviderType
public class Spreadsheet {
    public static final String DEFAULT_DELIMITER = ",";
    public static final String ROW_NUMBER = "~~ROWNUM~~";
    private String fileName = "unknown";
    private int rowCount;
    private transient List<Map<String, CompositeVariant>> dataRows;
    private final List<String> requiredColumns;
    private Map<String, Class> headerTypes;
    private List<String> headerRow;
    private final Map<String, String> delimiters;
    private boolean enableHeaderNameConversion = true;

    public Spreadsheet(boolean convertHeaderNames, String ... headerArray) {
        this.enableHeaderNameConversion = convertHeaderNames;
        this.headerTypes = Arrays.stream(headerArray).collect(Collectors.toMap(this::convertHeaderName, this::detectTypeFromName));
        this.headerRow = Arrays.asList(headerArray);
        this.requiredColumns = Collections.EMPTY_LIST;
        this.dataRows = new ArrayList<Map<String, CompositeVariant>>();
        this.delimiters = new HashMap<String, String>();
    }

    public Spreadsheet(boolean convertHeaderNames, InputStream file, String ... required) throws IOException {
        this.delimiters = new HashMap<String, String>();
        this.enableHeaderNameConversion = convertHeaderNames;
        this.requiredColumns = required == null || required.length == 0 ? Collections.EMPTY_LIST : Arrays.stream(required).map(this::convertHeaderName).collect(Collectors.toList());
        this.parseInputFile(file);
    }

    public Spreadsheet(boolean convertHeaderNames, RequestParameter file, String ... required) throws IOException {
        this(convertHeaderNames, file.getInputStream(), required);
        this.fileName = file.getFileName();
    }

    public Spreadsheet(InputStream file, String ... required) throws IOException {
        this(true, file, required);
    }

    public Spreadsheet(RequestParameter file, String ... required) throws IOException {
        this(true, file, required);
    }

    private void parseInputFile(InputStream file) throws IOException {
        XSSFWorkbook workbook = new XSSFWorkbook(file);
        XSSFSheet sheet = workbook.getSheetAt(0);
        this.rowCount = sheet.getLastRowNum();
        Iterator rows = sheet.rowIterator();
        Row firstRow = (Row)rows.next();
        this.headerRow = this.readRow(firstRow).stream().map(Variant::toString).map(this::convertHeaderName).collect(Collectors.toList());
        this.headerTypes = this.readRow(firstRow).stream().map(Variant::toString).collect(Collectors.toMap(this::convertHeaderName, this::detectTypeFromName, this::upgradeToArray));
        Iterable remainingRows = () -> rows;
        this.dataRows = StreamSupport.stream(remainingRows.spliterator(), false).map(this::buildRow).filter(Optional::isPresent).map(Optional::get).collect(Collectors.toList());
    }

    private List<Variant> readRow(Row row) {
        Iterator iterator = row.cellIterator();
        ArrayList<Variant> rowOut = new ArrayList<Variant>();
        while (iterator.hasNext()) {
            Cell c = (Cell)iterator.next();
            while (c.getColumnIndex() > rowOut.size()) {
                rowOut.add(null);
            }
            Variant val = new Variant(c);
            rowOut.add(val.isEmpty() ? null : val);
        }
        return rowOut;
    }

    private Optional<Map<String, CompositeVariant>> buildRow(Row row) {
        LinkedHashMap<String, CompositeVariant<Constable>> out = new LinkedHashMap<String, CompositeVariant<Constable>>();
        out.put(ROW_NUMBER, new CompositeVariant<Integer>(row.getRowNum()));
        List<Variant> data = this.readRow(row);
        boolean empty = true;
        for (int i = 0; i < data.size() && i < this.getHeaderRow().size(); ++i) {
            String colName = this.getHeaderRow().get(i);
            if (data.get(i) == null || data.get(i).isEmpty()) continue;
            empty = false;
            if (!out.containsKey(colName)) {
                out.put(colName, new CompositeVariant<Class>(this.headerTypes.get(colName)));
            }
            if (this.headerTypes.get(colName).isArray()) {
                String[] values;
                for (String value : values = data.get(i).toString().split(Pattern.quote(this.delimiters.getOrDefault(colName, DEFAULT_DELIMITER)))) {
                    if (value == null || value.isEmpty()) continue;
                    ((CompositeVariant)out.get(colName)).addValue(value.trim());
                }
                continue;
            }
            ((CompositeVariant)out.get(colName)).addValue(data.get(i));
        }
        if (empty || !this.requiredColumns.isEmpty() && !out.keySet().containsAll(this.requiredColumns)) {
            return Optional.empty();
        }
        return Optional.of(out);
    }

    public String getFileName() {
        return this.fileName;
    }

    public int getRowCount() {
        return this.rowCount;
    }

    public List<String> getHeaderRow() {
        return this.headerRow;
    }

    public List<Map<String, CompositeVariant>> getDataRowsAsCompositeVariants() {
        return this.dataRows;
    }

    public Long getRowNum(Map<String, CompositeVariant> row) {
        if (row.containsKey(ROW_NUMBER)) {
            return row.get(ROW_NUMBER).getValueAs(Long.class);
        }
        return this.dataRows.indexOf(row);
    }

    public List<String> getRequiredColumns() {
        return this.requiredColumns;
    }

    public String convertHeaderName(String str) {
        if (this.enableHeaderNameConversion) {
            if (str.contains("@")) {
                str = StringUtils.substringBefore((String)str, (String)"@");
            }
            return String.valueOf(str).toLowerCase().replaceAll("[^0-9a-zA-Z:\\-]+", "_");
        }
        return String.valueOf(str);
    }

    private Class detectTypeFromName(String name) {
        boolean isArray = false;
        Class detectedClass = String.class;
        if (name.contains("@")) {
            String typeStr = StringUtils.substringAfter((String)name, (String)"@");
            if (name.endsWith("]")) {
                String colName = this.convertHeaderName(name);
                isArray = true;
                String delimiter = StringUtils.substringBetween((String)name, (String)"[", (String)"]");
                typeStr = StringUtils.substringBefore((String)"[", (String)delimiter);
                if (!StringUtils.isEmpty((CharSequence)delimiter)) {
                    this.delimiters.put(colName, delimiter);
                }
            }
            detectedClass = this.getClassFromName(typeStr);
        }
        if (isArray) {
            return Spreadsheet.getArrayType(detectedClass);
        }
        return detectedClass;
    }

    private Class getClassFromName(String typeStr) {
        switch (typeStr.toLowerCase()) {
            case "int": 
            case "integer": {
                return Integer.TYPE;
            }
            case "long": {
                return Long.TYPE;
            }
            case "double": 
            case "number": {
                return Double.TYPE;
            }
            case "date": 
            case "calendar": 
            case "cal": 
            case "time": {
                return Date.class;
            }
            case "boolean": 
            case "bool": {
                return Boolean.TYPE;
            }
        }
        return String.class;
    }

    private Class upgradeToArray(Class a, Class b) {
        if (a == null) {
            return b;
        }
        if (b == null) {
            return a;
        }
        if (a.equals(b) || b == String.class) {
            return Spreadsheet.getArrayType(a);
        }
        return Spreadsheet.getArrayType(b);
    }

    private static Class getArrayType(Class clazz) {
        if (clazz.isArray()) {
            return clazz;
        }
        return Array.newInstance(clazz, 0).getClass();
    }
}

