/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.acs.commons.fam.actions;

import aQute.bnd.annotation.ProviderType;
import com.adobe.acs.commons.fam.actions.Actions;
import com.adobe.acs.commons.functions.CheckedBiConsumer;
import com.adobe.acs.commons.functions.CheckedConsumer;
import com.adobe.acs.commons.functions.RoundRobin;
import com.day.cq.replication.ReplicationActionType;
import com.day.cq.replication.ReplicationOptions;
import com.day.cq.replication.Replicator;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import javax.jcr.Session;
import org.apache.sling.api.resource.ResourceResolver;

@ProviderType
public class ReplicationActions {
    private static final String PREFIX_ACTIVATE = "activate-";
    private static final String PREFIX_DEACTIVATE = "deactivate-";

    private ReplicationActions() {
    }

    public static final CheckedBiConsumer<ResourceResolver, String> activateAll(Replicator replicator) {
        return (r, path) -> {
            Actions.nameThread(PREFIX_ACTIVATE + path);
            replicator.replicate((Session)r.adaptTo(Session.class), ReplicationActionType.ACTIVATE, path);
        };
    }

    public static final CheckedBiConsumer<ResourceResolver, String> activateAllWithOptions(Replicator replicator, ReplicationOptions options) {
        return (r, path) -> {
            Actions.nameThread(PREFIX_ACTIVATE + path);
            replicator.replicate((Session)r.adaptTo(Session.class), ReplicationActionType.ACTIVATE, path, options);
        };
    }

    public static final CheckedBiConsumer<ResourceResolver, String> activateAllWithRoundRobin(Replicator replicator, ReplicationOptions ... options) {
        List<ReplicationOptions> allTheOptions = Arrays.asList(options);
        Iterator<ReplicationOptions> roundRobin = new RoundRobin<ReplicationOptions>(allTheOptions).iterator();
        return (r, path) -> {
            Actions.nameThread(PREFIX_ACTIVATE + path);
            replicator.replicate((Session)r.adaptTo(Session.class), ReplicationActionType.ACTIVATE, path, (ReplicationOptions)roundRobin.next());
        };
    }

    public static final CheckedBiConsumer<ResourceResolver, String> deactivateAll(Replicator replicator) {
        return (r, path) -> {
            Actions.nameThread(PREFIX_DEACTIVATE + path);
            replicator.replicate((Session)r.adaptTo(Session.class), ReplicationActionType.DEACTIVATE, path);
        };
    }

    public static final CheckedBiConsumer<ResourceResolver, String> deactivateAllWithOptions(Replicator replicator, ReplicationOptions options) {
        return (r, path) -> {
            Actions.nameThread(PREFIX_DEACTIVATE + path);
            replicator.replicate((Session)r.adaptTo(Session.class), ReplicationActionType.DEACTIVATE, path, options);
        };
    }

    public static final CheckedConsumer<ResourceResolver> activate(Replicator replicator, String path) {
        return res -> ReplicationActions.activateAll(replicator).accept((ResourceResolver)res, path);
    }

    public static final CheckedConsumer<ResourceResolver> activateWithOptions(Replicator replicator, String path, ReplicationOptions options) {
        return res -> ReplicationActions.activateAllWithOptions(replicator, options).accept((ResourceResolver)res, path);
    }

    public static final CheckedConsumer<ResourceResolver> deactivate(Replicator replicator, String path) {
        return res -> ReplicationActions.deactivateAll(replicator).accept((ResourceResolver)res, path);
    }

    public static final CheckedConsumer<ResourceResolver> deactivateWithOptions(Replicator replicator, String path, ReplicationOptions options) {
        return res -> ReplicationActions.deactivateAllWithOptions(replicator, options).accept((ResourceResolver)res, path);
    }
}

