/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.acs.commons.fam.impl;

import com.adobe.acs.commons.fam.ActionManager;
import com.adobe.acs.commons.fam.CancelHandler;
import com.adobe.acs.commons.fam.Failure;
import com.adobe.acs.commons.fam.ThrottledTaskRunner;
import com.adobe.acs.commons.fam.actions.Actions;
import com.adobe.acs.commons.fam.impl.ReusableResolver;
import com.adobe.acs.commons.functions.BiConsumer;
import com.adobe.acs.commons.functions.BiFunction;
import com.adobe.acs.commons.functions.CheckedBiConsumer;
import com.adobe.acs.commons.functions.CheckedBiFunction;
import com.adobe.acs.commons.functions.CheckedConsumer;
import com.adobe.acs.commons.functions.Consumer;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import javax.jcr.NodeIterator;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import javax.jcr.query.Query;
import javax.jcr.query.QueryManager;
import javax.jcr.query.QueryResult;
import javax.management.openmbean.CompositeData;
import javax.management.openmbean.CompositeDataSupport;
import javax.management.openmbean.CompositeType;
import javax.management.openmbean.OpenDataException;
import javax.management.openmbean.OpenType;
import javax.management.openmbean.SimpleType;
import javax.management.openmbean.TabularType;
import org.apache.sling.api.resource.LoginException;
import org.apache.sling.api.resource.PersistenceException;
import org.apache.sling.api.resource.ResourceResolver;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class ActionManagerImpl
extends CancelHandler
implements ActionManager,
Serializable {
    private static final long serialVersionUID = 7526472295622776150L;
    private static final transient Logger LOG = LoggerFactory.getLogger(ActionManagerImpl.class);
    public static final transient int HESITATION_DELAY = 50;
    public static final transient int COMPLETION_CHECK_INTERVAL = 100;
    private final AtomicInteger tasksAdded = new AtomicInteger();
    private final AtomicInteger tasksCompleted = new AtomicInteger();
    private final AtomicInteger tasksFilteredOut = new AtomicInteger();
    private final AtomicInteger tasksSuccessful = new AtomicInteger();
    private final AtomicInteger tasksError = new AtomicInteger();
    private final String name;
    private final AtomicLong started = new AtomicLong(0L);
    private long finished;
    private int saveInterval;
    private final transient ResourceResolver baseResolver;
    private final transient List<ReusableResolver> resolvers = Collections.synchronizedList(new ArrayList());
    private final transient ThreadLocal<ReusableResolver> currentResolver = new ThreadLocal();
    private final transient ThrottledTaskRunner taskRunner;
    private final transient ThreadLocal<String> currentPath;
    private final List<Failure> failures;
    private final transient AtomicBoolean cleanupHandlerRegistered = new AtomicBoolean(false);
    private final transient List<CheckedConsumer<ResourceResolver>> successHandlers = Collections.synchronizedList(new ArrayList());
    private final transient List<CheckedBiConsumer<List<Failure>, ResourceResolver>> errorHandlers = Collections.synchronizedList(new ArrayList());
    private final transient List<Runnable> finishHandlers = Collections.synchronizedList(new ArrayList());
    private static transient String[] statsItemNames;
    private static transient CompositeType statsCompositeType;
    private static transient TabularType statsTabularType;
    private static transient String[] failureItemNames;
    private static transient CompositeType failureCompositeType;
    private static transient TabularType failureTabularType;

    ActionManagerImpl(String name, ThrottledTaskRunner taskRunner, ResourceResolver resolver, int saveInterval) throws LoginException {
        this.name = name;
        this.taskRunner = taskRunner;
        this.saveInterval = saveInterval;
        this.baseResolver = resolver.clone(null);
        this.currentPath = new ThreadLocal();
        this.failures = new ArrayList<Failure>();
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public int getAddedCount() {
        return this.tasksAdded.get();
    }

    @Override
    public int getSuccessCount() {
        return this.tasksSuccessful.get();
    }

    @Override
    public int getErrorCount() {
        return Math.max(this.tasksError.get(), this.failures.size());
    }

    @Override
    public int getCompletedCount() {
        return this.tasksCompleted.get();
    }

    @Override
    public int getRemainingCount() {
        return this.getAddedCount() - (this.getSuccessCount() + this.tasksError.get());
    }

    @Override
    public List<Failure> getFailureList() {
        return this.failures;
    }

    @Override
    public void deferredWithResolver(Consumer<ResourceResolver> action) {
        this.deferredWithResolver((CheckedConsumer<ResourceResolver>)action);
    }

    @Override
    public void deferredWithResolver(CheckedConsumer<ResourceResolver> action) {
        this.deferredWithResolver(action, false);
    }

    private void deferredWithResolver(CheckedConsumer<ResourceResolver> action, boolean closesResolver) {
        if (!closesResolver) {
            this.tasksAdded.incrementAndGet();
        }
        this.taskRunner.scheduleWork(() -> this.runActionAndLogErrors(action, closesResolver), this);
    }

    private void runActionAndLogErrors(CheckedConsumer<ResourceResolver> action, Boolean closesResolver) {
        block7: {
            this.started.compareAndSet(0L, System.currentTimeMillis());
            try {
                this.withResolver(action);
                if (!closesResolver.booleanValue()) {
                    this.logCompletetion();
                }
            }
            catch (Error e) {
                LOG.error("Fatal uncaught error in action " + this.getName(), (Throwable)e);
                if (!closesResolver.booleanValue()) {
                    this.logError(new RuntimeException(e));
                }
                throw e;
            }
            catch (Exception t) {
                LOG.error("Error in action " + this.getName(), (Throwable)t);
                if (!closesResolver.booleanValue()) {
                    this.logError(t);
                }
            }
            catch (Throwable t) {
                LOG.error("Fatal uncaught error in action " + this.getName(), t);
                if (closesResolver.booleanValue()) break block7;
                this.logError(new RuntimeException(t));
            }
        }
    }

    @Override
    public void withResolver(Consumer<ResourceResolver> action) throws Exception {
        this.withResolver((CheckedConsumer<ResourceResolver>)action);
    }

    @Override
    public void withResolver(CheckedConsumer<ResourceResolver> action) throws Exception {
        Actions.setCurrentActionManager(this);
        ReusableResolver resolver = this.getResourceResolver();
        resolver.setCurrentItem(this.currentPath.get());
        try {
            action.accept(resolver.getResolver());
        }
        catch (Throwable ex) {
            throw ex;
        }
        finally {
            try {
                resolver.free();
            }
            catch (PersistenceException ex) {
                this.logPersistenceException(resolver.getPendingItems(), ex);
                throw ex;
            }
            Actions.setCurrentActionManager(null);
        }
    }

    @Override
    public int withQueryResults(String queryStatement, String language, BiConsumer<ResourceResolver, String> callback, BiFunction<ResourceResolver, String, Boolean> ... filters) throws RepositoryException, PersistenceException, Exception {
        return this.withQueryResults(queryStatement, language, callback, (CheckedBiFunction[])Arrays.copyOf(filters, filters.length, CheckedBiFunction[].class));
    }

    @Override
    public int withQueryResults(String queryStatement, String language, CheckedBiConsumer<ResourceResolver, String> callback, CheckedBiFunction<ResourceResolver, String, Boolean> ... filters) throws RepositoryException, PersistenceException, Exception {
        this.withResolver((ResourceResolver resolver) -> {
            try {
                Session session = (Session)resolver.adaptTo(Session.class);
                QueryManager queryManager = session.getWorkspace().getQueryManager();
                Query query = queryManager.createQuery(queryStatement, language);
                QueryResult results = query.execute();
                NodeIterator nodeIterator = results.getNodes();
                while (nodeIterator.hasNext()) {
                    String nodePath = nodeIterator.nextNode().getPath();
                    LOG.info("Processing found result " + nodePath);
                    this.deferredWithResolver((ResourceResolver r) -> {
                        this.currentPath.set(nodePath);
                        if (filters != null) {
                            for (CheckedBiFunction filter : filters) {
                                if (((Boolean)filter.apply(r, nodePath)).booleanValue()) continue;
                                this.logFilteredOutItem(nodePath);
                                return;
                            }
                        }
                        callback.accept((ResourceResolver)r, nodePath);
                    });
                }
            }
            catch (RepositoryException ex) {
                LOG.error("Repository exception processing query " + queryStatement, (Throwable)ex);
            }
        });
        return this.tasksAdded.get();
    }

    @Override
    public void cancel(boolean useForce) {
        super.cancel(useForce);
        if (this.getErrorCount() > 0) {
            this.processErrorHandlers();
        }
    }

    @Override
    public void addCleanupTask() {
    }

    @Override
    public void onSuccess(CheckedConsumer<ResourceResolver> successTask) {
        this.successHandlers.add(successTask);
    }

    @Override
    public void onFailure(CheckedBiConsumer<List<Failure>, ResourceResolver> failureTask) {
        this.errorHandlers.add(failureTask);
    }

    @Override
    public void onFinish(Runnable finishHandler) {
        this.finishHandlers.add(finishHandler);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void runCompletionTasks() {
        List<Object> list;
        if (this.getErrorCount() == 0) {
            list = this.successHandlers;
            synchronized (list) {
                this.successHandlers.forEach(handler -> {
                    try {
                        this.withResolver((CheckedConsumer<ResourceResolver>)handler);
                    }
                    catch (Exception ex) {
                        LOG.error("Error in success handler for action " + this.getName(), (Throwable)ex);
                    }
                });
            }
        } else {
            this.processErrorHandlers();
        }
        list = this.finishHandlers;
        synchronized (list) {
            this.finishHandlers.forEach(Runnable::run);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void processErrorHandlers() {
        ArrayList<CheckedBiConsumer<List<Failure>, ResourceResolver>> handlerList = new ArrayList<CheckedBiConsumer<List<Failure>, ResourceResolver>>();
        List<CheckedBiConsumer<List<Failure>, ResourceResolver>> list = this.errorHandlers;
        synchronized (list) {
            handlerList.addAll(this.errorHandlers);
            this.errorHandlers.clear();
        }
        handlerList.forEach(handler -> {
            try {
                this.withResolver((ResourceResolver res) -> handler.accept(this.getFailureList(), res));
            }
            catch (Exception ex) {
                LOG.error("Error in error handler for action " + this.getName(), (Throwable)ex);
            }
        });
    }

    private void performAutomaticCleanup() {
        if (!this.cleanupHandlerRegistered.getAndSet(true)) {
            this.taskRunner.scheduleWork(() -> {
                while (!this.isComplete()) {
                    try {
                        Thread.sleep(100L);
                    }
                    catch (InterruptedException ex) {
                        this.logError(ex);
                    }
                }
                this.runCompletionTasks();
                this.closeAllResolvers();
            });
        }
    }

    @Override
    public void setCurrentItem(String item) {
        this.currentPath.set(item);
    }

    private ReusableResolver getResourceResolver() throws LoginException {
        ReusableResolver resolver = this.currentResolver.get();
        if (resolver == null || !resolver.getResolver().isLive()) {
            resolver = new ReusableResolver(this.baseResolver.clone(null), this.saveInterval);
            this.currentResolver.set(resolver);
            this.resolvers.add(resolver);
        }
        return resolver;
    }

    private void logCompletetion() {
        this.tasksCompleted.incrementAndGet();
        this.tasksSuccessful.incrementAndGet();
        if (this.isComplete()) {
            this.finished = System.currentTimeMillis();
            this.performAutomaticCleanup();
        }
    }

    private void logError(Exception ex) {
        LOG.error("Caught exception in task: " + ex.getMessage(), (Throwable)ex);
        Failure fail = new Failure();
        fail.setNodePath(this.currentPath.get());
        fail.setException(ex);
        this.failures.add(fail);
        this.tasksCompleted.incrementAndGet();
        this.tasksError.incrementAndGet();
        if (this.isComplete()) {
            this.finished = System.currentTimeMillis();
            this.performAutomaticCleanup();
        }
    }

    private void logPersistenceException(List<String> items, PersistenceException ex) {
        StringBuilder itemList = new StringBuilder();
        for (String item : items) {
            itemList.append(item).append("; ");
            Failure fail = new Failure();
            fail.setNodePath(item);
            fail.setException((Exception)((Object)ex));
            this.failures.add(fail);
            this.tasksError.incrementAndGet();
            this.tasksSuccessful.decrementAndGet();
        }
        LOG.error("Persistence error prevented saving changes for: " + itemList, (Throwable)ex);
    }

    private void logFilteredOutItem(String path) {
        this.tasksFilteredOut.incrementAndGet();
        LOG.info("Filtered out " + path);
    }

    public long getRuntime() {
        if (this.isComplete()) {
            return this.finished - this.started.get();
        }
        if (this.tasksAdded.get() == 0) {
            return 0L;
        }
        return System.currentTimeMillis() - this.started.get();
    }

    public static TabularType getStaticsTableType() {
        return statsTabularType;
    }

    @Override
    public boolean isComplete() {
        if (this.tasksCompleted.get() == this.tasksAdded.get()) {
            try {
                Thread.sleep(50L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            return this.tasksCompleted.get() == this.tasksAdded.get();
        }
        return false;
    }

    @Override
    public CompositeData getStatistics() throws OpenDataException {
        return new CompositeDataSupport(statsCompositeType, statsItemNames, new Object[]{this.name, this.tasksAdded.get(), this.tasksCompleted.get(), this.tasksFilteredOut.get(), this.tasksSuccessful.get(), this.tasksError.get(), this.getRuntime()});
    }

    @Override
    public synchronized void closeAllResolvers() {
        if (!this.resolvers.isEmpty()) {
            this.resolvers.stream().map(ReusableResolver::getResolver).filter(ResourceResolver::isLive).forEach(ResourceResolver::close);
            this.resolvers.clear();
        }
        this.baseResolver.close();
    }

    public static TabularType getFailuresTableType() {
        return failureTabularType;
    }

    @Override
    public List<CompositeData> getFailures() throws OpenDataException {
        ArrayList<CompositeData> failureData = new ArrayList<CompositeData>();
        int count = 0;
        for (Failure fail : this.failures) {
            if (count > 5000) break;
            failureData.add(new CompositeDataSupport(failureCompositeType, failureItemNames, new Object[]{this.name, ++count, fail.getNodePath(), fail.getException() == null ? "Unknown" : fail.getException().getMessage()}));
        }
        return failureData;
    }

    static {
        try {
            statsItemNames = new String[]{"_taskName", "started", "completed", "filtered", "successful", "errors", "runtime"};
            statsCompositeType = new CompositeType("Statics Row", "Single row of statistics", statsItemNames, new String[]{"Name", "Started", "Completed", "Filtered", "Successful", "Errors", "Runtime"}, new OpenType[]{SimpleType.STRING, SimpleType.INTEGER, SimpleType.INTEGER, SimpleType.INTEGER, SimpleType.INTEGER, SimpleType.INTEGER, SimpleType.LONG});
            statsTabularType = new TabularType("Statistics", "Collected statistics", statsCompositeType, new String[]{"_taskName"});
            failureItemNames = new String[]{"_taskName", "_count", "item", "error"};
            failureCompositeType = new CompositeType("Failure", "Failure", failureItemNames, new String[]{"Name", "#", "Item", "Error"}, new OpenType[]{SimpleType.STRING, SimpleType.INTEGER, SimpleType.STRING, SimpleType.STRING});
            failureTabularType = new TabularType("Errors", "Collected failures", failureCompositeType, new String[]{"_taskName", "_count"});
        }
        catch (OpenDataException ex) {
            LOG.error("Unable to build MBean composite types", (Throwable)ex);
        }
    }
}

