/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.acs.commons.fam.impl;

import com.adobe.acs.commons.fam.CancelHandler;
import com.adobe.acs.commons.fam.ThrottledTaskRunner;
import java.util.Optional;
import java.util.concurrent.Semaphore;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TimedRunnable
implements Runnable {
    long created = System.currentTimeMillis();
    long started = -1L;
    long executed = -1L;
    long finished = -1L;
    Runnable work;
    ThrottledTaskRunner runner;
    int timeout;
    TimeUnit timeoutUnit;
    Optional<CancelHandler> cancelHandler = Optional.empty();
    private static final Logger LOG = LoggerFactory.getLogger(TimedRunnable.class);

    public TimedRunnable(Runnable work, ThrottledTaskRunner runner, int timeout, TimeUnit timeoutUnit) {
        this.work = work;
        this.runner = runner;
        this.timeout = timeout;
        this.timeoutUnit = timeoutUnit;
        LOG.debug("Task created");
    }

    public TimedRunnable(Runnable work, ThrottledTaskRunner runner, int timeout, TimeUnit timeoutUnit, CancelHandler cancelHandler) {
        this(work, runner, timeout, timeoutUnit);
        this.cancelHandler = Optional.of(cancelHandler);
    }

    @Override
    public void run() {
        if (this.cancelHandler.isPresent() && this.cancelHandler.get().isCancelled()) {
            return;
        }
        Thread thisThread = Thread.currentThread();
        Semaphore timerSemaphore = new Semaphore(0);
        Thread watchDog = new Thread(this.watchThread(thisThread, timerSemaphore));
        boolean successful = false;
        Throwable error = null;
        try {
            this.started = System.currentTimeMillis();
            this.runner.waitForLowCpuAndLowMemory();
            this.executed = System.currentTimeMillis();
            if (this.timeout > 0) {
                watchDog.start();
            }
            this.cancelHandler.ifPresent(h -> h.trackActiveWork(thisThread));
            this.work.run();
            this.finished = System.currentTimeMillis();
            this.cancelHandler.ifPresent(h -> h.untrackActiveWork(thisThread));
            timerSemaphore.release();
            successful = true;
        }
        catch (Throwable ex) {
            this.finished = System.currentTimeMillis();
            this.cancelHandler.ifPresent(h -> h.untrackActiveWork(thisThread));
            LOG.error("Task encountered an uncaught exception", ex);
        }
        this.runner.logCompletion(this.created, this.started, this.executed, this.finished, successful, error);
    }

    private Runnable watchThread(Thread workThread, Semaphore timerSemaphore) {
        return () -> {
            boolean finished1 = false;
            try {
                finished1 = timerSemaphore.tryAcquire(this.timeout, this.timeoutUnit);
            }
            catch (InterruptedException ex) {
                LOG.error("Watchdog thread interrupted", (Throwable)ex);
            }
            if (!finished1) {
                LOG.error("Watchdog reached interval timeout, worker thread will now be interrupted!");
                workThread.interrupt();
            }
        };
    }
}

