/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.acs.commons.http.headers.impl;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Dictionary;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.StringUtils;
import org.apache.felix.scr.annotations.Activate;
import org.apache.felix.scr.annotations.Deactivate;
import org.apache.sling.commons.osgi.PropertiesUtil;
import org.osgi.framework.ServiceRegistration;
import org.osgi.service.cm.ConfigurationException;
import org.osgi.service.component.ComponentContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractDispatcherCacheHeaderFilter
implements Filter {
    private static final Logger log = LoggerFactory.getLogger(AbstractDispatcherCacheHeaderFilter.class);
    public static final String PROP_FILTER_PATTERN = "filter.pattern";
    protected static final String SERVER_AGENT_NAME = "Server-Agent";
    protected static final String DISPATCHER_AGENT_HEADER_VALUE = "Communique-Dispatcher";
    private List<ServiceRegistration> filterRegistrations = new ArrayList<ServiceRegistration>();
    private static final Object MARKER = new Object();

    protected abstract String getHeaderName();

    protected abstract String getHeaderValue();

    protected abstract void doActivate(ComponentContext var1) throws Exception;

    public void init(FilterConfig filterConfig) throws ServletException {
    }

    public final void doFilter(ServletRequest servletRequest, ServletResponse servletResponse, FilterChain filterChain) throws IOException, ServletException {
        if (!(servletRequest instanceof HttpServletRequest) || !(servletResponse instanceof HttpServletResponse)) {
            filterChain.doFilter(servletRequest, servletResponse);
            return;
        }
        HttpServletRequest request = (HttpServletRequest)servletRequest;
        HttpServletResponse response = (HttpServletResponse)servletResponse;
        if (this.accepts(request)) {
            String header = this.getHeaderName();
            String val = this.getHeaderValue();
            String attributeName = AbstractDispatcherCacheHeaderFilter.class.getName() + ".header." + header;
            if (request.getAttribute(attributeName) == null) {
                log.debug("Adding header {}: {}", (Object)header, (Object)val);
                response.addHeader(header, val);
                request.setAttribute(attributeName, MARKER);
            } else {
                log.debug("Header {} was already set. Skipping.", (Object)header);
            }
        }
        filterChain.doFilter((ServletRequest)request, (ServletResponse)response);
    }

    public void destroy() {
    }

    protected boolean accepts(HttpServletRequest request) {
        List serverAgents;
        Enumeration agentsEnum = request.getHeaders(SERVER_AGENT_NAME);
        List list = serverAgents = agentsEnum != null ? Collections.list(agentsEnum) : Collections.emptyList();
        return StringUtils.equalsIgnoreCase((CharSequence)"get", (CharSequence)request.getMethod()) && request.getParameterMap().isEmpty() && serverAgents.contains(DISPATCHER_AGENT_HEADER_VALUE);
    }

    @Activate
    protected final void activate(ComponentContext context) throws Exception {
        Dictionary properties = context.getProperties();
        this.doActivate(context);
        String[] filters = PropertiesUtil.toStringArray(properties.get(PROP_FILTER_PATTERN));
        if (filters == null || filters.length == 0) {
            throw new ConfigurationException(PROP_FILTER_PATTERN, "At least one filter pattern must be specified.");
        }
        for (String pattern : filters) {
            Hashtable<String, String> filterProps = new Hashtable<String, String>();
            log.debug("Adding filter ({}) to pattern: {}", (Object)this.toString(), (Object)pattern);
            ((Dictionary)filterProps).put("osgi.http.whiteboard.filter.regex", pattern);
            ((Dictionary)filterProps).put("osgi.http.whiteboard.context.select", "(osgi.http.whiteboard.context.name=*)");
            ServiceRegistration filterReg = context.getBundleContext().registerService(Filter.class.getName(), (Object)this, filterProps);
            this.filterRegistrations.add(filterReg);
        }
    }

    @Deactivate
    protected final void deactivate(ComponentContext context) {
        Iterator<ServiceRegistration> it = this.filterRegistrations.iterator();
        while (it.hasNext()) {
            ServiceRegistration registration = it.next();
            registration.unregister();
            it.remove();
        }
    }
}

