/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.acs.commons.httpcache.engine;

import com.adobe.acs.commons.httpcache.engine.impl.TeePrintWriter;
import com.adobe.acs.commons.httpcache.engine.impl.TeeServletOutputStream;
import com.adobe.acs.commons.httpcache.exception.HttpCacheDataStreamException;
import com.adobe.acs.commons.httpcache.store.TempSink;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.util.Collection;
import java.util.Collections;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletResponseWrapper;
import org.apache.sling.api.SlingHttpServletResponse;
import org.apache.sling.api.wrappers.SlingHttpServletResponseWrapper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HttpCacheServletResponseWrapper
extends SlingHttpServletResponseWrapper {
    private static final Logger log = LoggerFactory.getLogger(HttpServletResponseWrapper.class);
    private PrintWriter printWriter;
    private ServletOutputStream servletOutputStream;
    private final TempSink tempSink;

    public HttpCacheServletResponseWrapper(SlingHttpServletResponse wrappedResponse, TempSink tempSink) throws IOException {
        super(wrappedResponse);
        this.tempSink = tempSink;
    }

    public ServletOutputStream getOutputStream() throws IOException {
        if (this.printWriter != null) {
            throw new IllegalStateException("Cannot invoke getOutputStream() once getWriter() has been called.");
        }
        if (this.servletOutputStream == null) {
            try {
                this.servletOutputStream = new TeeServletOutputStream((OutputStream)super.getOutputStream(), this.tempSink.createOutputStream());
            }
            catch (HttpCacheDataStreamException e) {
                log.error("Temp sink is unable to provide an output stream.");
            }
        }
        return this.servletOutputStream;
    }

    public PrintWriter getWriter() throws IOException {
        if (this.servletOutputStream != null) {
            throw new IllegalStateException("Cannot invoke getWriter() once getOutputStream() has been called.");
        }
        if (this.printWriter == null) {
            try {
                OutputStreamWriter tempWriter = new OutputStreamWriter(this.tempSink.createOutputStream(), this.getResponse().getCharacterEncoding());
                this.printWriter = new TeePrintWriter(super.getWriter(), new PrintWriter(tempWriter));
            }
            catch (HttpCacheDataStreamException e) {
                log.error("Temp sink is unable to provide an output stream.");
            }
        }
        return this.printWriter;
    }

    public Collection<String> getHeaderNames() {
        try {
            return super.getHeaderNames();
        }
        catch (AbstractMethodError e) {
            log.debug("Known issue when internal sling redirects are made - the call to getHeaders() will throw an exception.", (Throwable)e);
            return Collections.EMPTY_LIST;
        }
    }

    public TempSink getTempSink() {
        return this.tempSink;
    }
}

