/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.acs.commons.httpcache.engine.impl;

import com.adobe.acs.commons.httpcache.config.HttpCacheConfig;
import com.adobe.acs.commons.httpcache.config.impl.HttpCacheConfigComparator;
import com.adobe.acs.commons.httpcache.config.impl.HttpCacheConfigImpl;
import com.adobe.acs.commons.httpcache.engine.CacheContent;
import com.adobe.acs.commons.httpcache.engine.HttpCacheEngine;
import com.adobe.acs.commons.httpcache.engine.HttpCacheServletResponseWrapper;
import com.adobe.acs.commons.httpcache.engine.impl.HttpCacheEngineMBean;
import com.adobe.acs.commons.httpcache.exception.HttpCacheConfigConflictException;
import com.adobe.acs.commons.httpcache.exception.HttpCacheDataStreamException;
import com.adobe.acs.commons.httpcache.exception.HttpCacheKeyCreationException;
import com.adobe.acs.commons.httpcache.exception.HttpCachePersistenceException;
import com.adobe.acs.commons.httpcache.exception.HttpCacheRepositoryAccessException;
import com.adobe.acs.commons.httpcache.keys.CacheKey;
import com.adobe.acs.commons.httpcache.rule.HttpCacheHandlingRule;
import com.adobe.acs.commons.httpcache.store.HttpCacheStore;
import com.adobe.granite.jmx.annotation.AnnotatedStandardMBean;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.function.Function;
import javax.management.DynamicMBean;
import javax.management.NotCompliantMBeanException;
import javax.management.openmbean.CompositeDataSupport;
import javax.management.openmbean.CompositeType;
import javax.management.openmbean.OpenDataException;
import javax.management.openmbean.OpenType;
import javax.management.openmbean.SimpleType;
import javax.management.openmbean.TabularData;
import javax.management.openmbean.TabularDataSupport;
import javax.management.openmbean.TabularType;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.felix.scr.annotations.Activate;
import org.apache.felix.scr.annotations.Component;
import org.apache.felix.scr.annotations.Deactivate;
import org.apache.felix.scr.annotations.Properties;
import org.apache.felix.scr.annotations.Property;
import org.apache.felix.scr.annotations.PropertyUnbounded;
import org.apache.felix.scr.annotations.Reference;
import org.apache.felix.scr.annotations.ReferenceCardinality;
import org.apache.felix.scr.annotations.ReferencePolicy;
import org.apache.felix.scr.annotations.References;
import org.apache.felix.scr.annotations.Service;
import org.apache.sling.api.SlingHttpServletRequest;
import org.apache.sling.api.SlingHttpServletResponse;
import org.apache.sling.commons.osgi.PropertiesUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(label="ACS AEM Commons - HTTP Cache - Engine", description="Controlling service for http cache implementation.", metatype=true)
@Properties(value={@Property(name="jmx.objectname", value={"com.adobe.acs.httpcache:type=HTTP Cache Engine"}, propertyPrivate=true), @Property(name="webconsole.configurationFactory.nameHint", value={"Global handling rules: {httpcache.engine.cache-handling-rules.global}"}, propertyPrivate=true)})
@References(value={@Reference(name="httpCacheConfig", referenceInterface=HttpCacheConfig.class, policy=ReferencePolicy.DYNAMIC, cardinality=ReferenceCardinality.MANDATORY_MULTIPLE), @Reference(name="httpCacheHandlingRule", referenceInterface=HttpCacheHandlingRule.class, policy=ReferencePolicy.DYNAMIC, cardinality=ReferenceCardinality.OPTIONAL_MULTIPLE), @Reference(name="httpCacheStore", referenceInterface=HttpCacheStore.class, policy=ReferencePolicy.DYNAMIC, cardinality=ReferenceCardinality.MANDATORY_MULTIPLE)})
@Service(value={DynamicMBean.class, HttpCacheEngine.class})
public class HttpCacheEngineImpl
extends AnnotatedStandardMBean
implements HttpCacheEngine,
HttpCacheEngineMBean {
    private static final Logger log = LoggerFactory.getLogger(HttpCacheConfigImpl.class);
    static final String METHOD_NAME_TO_BIND_CONFIG = "httpCacheConfig";
    static final String JMX_PN_ORDER = "Order";
    static final String JMX_PN_OSGICOMPONENT = "OSGi Component";
    static final String JMX_PN_HTTPCACHE_CONFIGS = "HTTP Cache Configs";
    static final String JMX_PN_HTTPCACHE_CONFIG = "HTTP Cache Config";
    static final String JMX_PN_HTTPCACHE_STORE = "HTTP Cache Store";
    static final String JMX_PN_HTTPCACHE_STORES = "HTTP Cache Stores";
    static final String JMX_HTTPCACHE_HANDLING_RULE = "HTTP Cache Handling Rule";
    static final String JMX_PN_HTTPCACHE_HANDLING_RULES = "HTTP Cache Handling Rules";
    private CopyOnWriteArrayList<HttpCacheConfig> cacheConfigs = new CopyOnWriteArrayList();
    static final String METHOD_NAME_TO_BIND_CACHE_STORE = "httpCacheStore";
    private static final ConcurrentHashMap<String, HttpCacheStore> cacheStoresMap = new ConcurrentHashMap();
    static final String METHOD_NAME_TO_BIND_CACHE_HANDLING_RULES = "httpCacheHandlingRule";
    private static final ConcurrentHashMap<String, HttpCacheHandlingRule> cacheHandlingRules = new ConcurrentHashMap();
    @Property(label="Global HttpCacheHandlingRules", description="List of Service pid of HttpCacheHandlingRule applicable for all cache configs.", unbounded=PropertyUnbounded.ARRAY, value={"com.adobe.acs.commons.httpcache.rule.impl.CacheOnlyGetRequest", "com.adobe.acs.commons.httpcache.rule.impl.CacheOnlyResponse200", "com.adobe.acs.commons.httpcache.rule.impl.HonorCacheControlHeaders", "com.adobe.acs.commons.httpcache.rule.impl.DoNotCacheZeroSizeResponse"})
    private static final String PROP_GLOBAL_CACHE_HANDLING_RULES_PID = "httpcache.engine.cache-handling-rules.global";
    private List<String> globalCacheHandlingRulesPid;
    private final ConcurrentHashMap<HttpCacheConfig, Map<String, Object>> cacheConfigConfigs = new ConcurrentHashMap();

    protected void bindHttpCacheConfig(HttpCacheConfig cacheConfig, Map<String, Object> configs) {
        if (!cacheConfig.isValid()) {
            log.info("Http cache config rejected as the request uri is absent.");
            return;
        }
        if (this.cacheConfigs.contains(cacheConfig)) {
            log.trace("Http cache config object already exists in the cacheConfigs map and hence ignored.");
            return;
        }
        CopyOnWriteArrayList<HttpCacheConfig> tmp = new CopyOnWriteArrayList<HttpCacheConfig>(this.cacheConfigs);
        tmp.add(cacheConfig);
        Collections.sort(tmp, new HttpCacheConfigComparator());
        this.cacheConfigs = tmp;
        this.cacheConfigConfigs.put(cacheConfig, configs);
        log.debug("Total number of cache configs added: {}", (Object)this.cacheConfigs.size());
    }

    protected void unbindHttpCacheConfig(HttpCacheConfig cacheConfig, Map<String, Object> config) {
        if (this.cacheConfigs.contains(cacheConfig)) {
            if (cacheStoresMap.containsKey(cacheConfig.getCacheStoreName())) {
                cacheStoresMap.get(cacheConfig.getCacheStoreName()).invalidate(cacheConfig);
            } else {
                log.debug("Configured cache store is unavailable and hence nothing to invalidate.");
            }
            this.cacheConfigs.remove(cacheConfig);
            this.cacheConfigConfigs.remove(cacheConfig);
            log.debug("Total number of cache configs after removal: {}", (Object)this.cacheConfigs.size());
            return;
        }
        log.debug("This cache config entry was not bound and hence nothing to unbind.");
    }

    protected void bindHttpCacheStore(HttpCacheStore cacheStore, Map<String, Object> properties) {
        String cacheStoreType = PropertiesUtil.toString((Object)properties.get("httpcache.cachestore.type"), null);
        if (cacheStoreType != null && cacheStoresMap.putIfAbsent(cacheStoreType, cacheStore) == null) {
            log.debug("Cache store implementation {} has been added", (Object)((String)properties.get("httpcache.cachestore.type")));
            log.debug("Total number of cache stores in the map: {}", (Object)cacheStoresMap.size());
        }
    }

    protected void unbindHttpCacheStore(HttpCacheStore cacheStore, Map<String, Object> properties) {
        String cacheStoreType = PropertiesUtil.toString((Object)properties.get("httpcache.cachestore.type"), null);
        if (cacheStoreType != null && cacheStoresMap.remove(cacheStoreType) != null) {
            log.debug("Cache store removed - {}.", (Object)((String)properties.get("httpcache.cachestore.type")));
            log.debug("Total number of cache stores after removal: {}", (Object)cacheStoresMap.size());
        }
    }

    protected void bindHttpCacheHandlingRule(HttpCacheHandlingRule cacheHandlingRule, Map<String, Object> properties) {
        String servicePid = PropertiesUtil.toString((Object)properties.get("service.pid"), (String)"");
        if (cacheHandlingRules.putIfAbsent(servicePid, cacheHandlingRule) == null) {
            log.debug("Cache handling rule implementation {} has been added", (Object)cacheHandlingRule.getClass().getName());
            log.debug("Total number of cache handling rule available after addition: {}", (Object)cacheHandlingRules.size());
        }
    }

    protected void unbindHttpCacheHandlingRule(HttpCacheHandlingRule cacheHandlingRule, Map<String, Object> configs) {
        String servicePid = PropertiesUtil.toString((Object)configs.get("service.pid"), (String)"");
        if (cacheHandlingRules.remove(servicePid) != null) {
            log.debug("Cache handling rule removed - {}.", (Object)cacheHandlingRule.getClass().getName());
            log.debug("Total number of cache handling rules available after removal: {}", (Object)cacheHandlingRules.size());
        }
    }

    @Activate
    protected void activate(Map<String, Object> configs) {
        this.globalCacheHandlingRulesPid = new ArrayList<String>(Arrays.asList(PropertiesUtil.toStringArray((Object)configs.get(PROP_GLOBAL_CACHE_HANDLING_RULES_PID), (String[])new String[0])));
        ListIterator<String> listIterator = this.globalCacheHandlingRulesPid.listIterator();
        while (listIterator.hasNext()) {
            String value = listIterator.next();
            if (!StringUtils.isBlank((String)value)) continue;
            listIterator.remove();
        }
        log.info("HttpCacheEngineImpl activated.");
    }

    @Deactivate
    protected void deactivate(Map<String, Object> configs) {
        log.info("HttpCacheEngineImpl deactivated.");
    }

    @Override
    public boolean isRequestCacheable(SlingHttpServletRequest request, HttpCacheConfig cacheConfig) throws HttpCacheRepositoryAccessException {
        for (Map.Entry<String, HttpCacheHandlingRule> entry : cacheHandlingRules.entrySet()) {
            HttpCacheHandlingRule rule;
            if (!this.globalCacheHandlingRulesPid.contains(entry.getKey()) && !cacheConfig.acceptsRule(entry.getKey()) || (rule = entry.getValue()).onRequestReceive(request)) continue;
            if (log.isDebugEnabled()) {
                log.debug("Request cannot be cached for the url {} honoring the rule {}", (Object)request.getRequestURL(), (Object)rule.getClass().getName());
            }
            return false;
        }
        return true;
    }

    @Override
    public HttpCacheConfig getCacheConfig(SlingHttpServletRequest request) throws HttpCacheRepositoryAccessException, HttpCacheConfigConflictException {
        return this.getCacheConfig(request, HttpCacheConfig.FilterScope.REQUEST);
    }

    @Override
    public HttpCacheConfig getCacheConfig(SlingHttpServletRequest request, HttpCacheConfig.FilterScope filterScope) throws HttpCacheConfigConflictException, HttpCacheRepositoryAccessException {
        HttpCacheConfig bestCacheConfig = null;
        for (HttpCacheConfig cacheConfig : this.cacheConfigs) {
            if (bestCacheConfig != null) {
                if (bestCacheConfig.getOrder() == cacheConfig.getOrder()) {
                    if (!cacheConfig.accepts(request)) continue;
                    throw new HttpCacheConfigConflictException();
                }
                if (bestCacheConfig.getOrder() >= cacheConfig.getOrder()) continue;
                break;
            }
            if (!filterScope.equals((Object)cacheConfig.getFilterScope()) || !cacheConfig.accepts(request)) continue;
            bestCacheConfig = cacheConfig;
        }
        if (bestCacheConfig == null && log.isDebugEnabled()) {
            log.debug("Matching cache config not found.");
        }
        return bestCacheConfig;
    }

    @Override
    public boolean isCacheHit(SlingHttpServletRequest request, HttpCacheConfig cacheConfig) throws HttpCacheKeyCreationException, HttpCachePersistenceException {
        return this.getCacheStore(cacheConfig).contains(cacheConfig.buildCacheKey(request));
    }

    @Override
    public boolean deliverCacheContent(SlingHttpServletRequest request, SlingHttpServletResponse response, HttpCacheConfig cacheConfig) throws HttpCacheKeyCreationException, HttpCacheDataStreamException, HttpCachePersistenceException {
        CacheContent cacheContent = this.getCacheStore(cacheConfig).getIfPresent(cacheConfig.buildCacheKey(request));
        if (!this.isRequestDeliverableFromCacheAccordingToHandlingRules(request, response, cacheConfig, cacheContent)) {
            return false;
        }
        this.prepareCachedResponse(response, cacheContent);
        return this.executeCacheContentDeliver(request, response, cacheContent);
    }

    @Override
    public HttpCacheServletResponseWrapper wrapResponse(SlingHttpServletRequest request, SlingHttpServletResponse response, HttpCacheConfig cacheConfig) throws HttpCacheDataStreamException, HttpCacheKeyCreationException, HttpCachePersistenceException {
        try {
            return new HttpCacheServletResponseWrapper(response, this.getCacheStore(cacheConfig).createTempSink());
        }
        catch (IOException e) {
            throw new HttpCacheDataStreamException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void cacheResponse(SlingHttpServletRequest request, SlingHttpServletResponse response, HttpCacheConfig cacheConfig) throws HttpCacheKeyCreationException, HttpCacheDataStreamException, HttpCachePersistenceException {
        CacheContent cacheContent = null;
        try {
            HttpCacheServletResponseWrapper responseWrapper = null;
            if (!(response instanceof HttpCacheServletResponseWrapper)) {
                throw new AssertionError((Object)"Programming error.");
            }
            responseWrapper = (HttpCacheServletResponseWrapper)response;
            CacheKey cacheKey = cacheConfig.buildCacheKey(request);
            cacheContent = new CacheContent().build(responseWrapper);
            if (this.isRequestCachableAccordingToHandlingRules(request, response, cacheConfig, cacheContent)) {
                this.getCacheStore(cacheConfig).put(cacheKey, cacheContent);
                log.debug("Response for the URI cached - {}", (Object)request.getRequestURI());
            }
        }
        finally {
            if (null != cacheContent) {
                IOUtils.closeQuietly((InputStream)cacheContent.getInputDataStream());
            }
        }
    }

    @Override
    public boolean isPathPotentialToInvalidate(String path) {
        for (HttpCacheConfig config : this.cacheConfigs) {
            if (!config.canInvalidate(path)) continue;
            return true;
        }
        return false;
    }

    @Override
    public void invalidateCache(String path) throws HttpCachePersistenceException, HttpCacheKeyCreationException {
        for (HttpCacheConfig cacheConfig : this.cacheConfigs) {
            if (!cacheConfig.canInvalidate(path)) continue;
            this.executeCustomRuleInvalidations(path, cacheConfig);
        }
    }

    private HttpCacheStore getCacheStore(HttpCacheConfig cacheConfig) throws HttpCachePersistenceException {
        if (cacheStoresMap.containsKey(cacheConfig.getCacheStoreName())) {
            return cacheStoresMap.get(cacheConfig.getCacheStoreName());
        }
        throw new HttpCachePersistenceException("Configured cache store unavailable " + cacheConfig.getCacheStoreName());
    }

    public HttpCacheEngineImpl() throws NotCompliantMBeanException {
        super(HttpCacheEngineMBean.class);
    }

    @Override
    public TabularData getRegisteredHttpCacheRules() throws OpenDataException {
        CompositeType cacheEntryType = new CompositeType(JMX_HTTPCACHE_HANDLING_RULE, JMX_HTTPCACHE_HANDLING_RULE, new String[]{JMX_HTTPCACHE_HANDLING_RULE}, new String[]{JMX_HTTPCACHE_HANDLING_RULE}, new OpenType[]{SimpleType.STRING});
        TabularDataSupport tabularData = new TabularDataSupport(new TabularType(JMX_PN_HTTPCACHE_HANDLING_RULES, JMX_PN_HTTPCACHE_HANDLING_RULES, cacheEntryType, new String[]{JMX_HTTPCACHE_HANDLING_RULE}));
        for (Map.Entry<String, HttpCacheHandlingRule> entry : cacheHandlingRules.entrySet()) {
            HashMap<String, String> row = new HashMap<String, String>();
            row.put(JMX_HTTPCACHE_HANDLING_RULE, entry.getValue().getClass().getName());
            tabularData.put(new CompositeDataSupport(cacheEntryType, row));
        }
        return tabularData;
    }

    @Override
    public TabularData getRegisteredHttpCacheConfigs() throws OpenDataException {
        CompositeType cacheEntryType = new CompositeType(JMX_PN_HTTPCACHE_CONFIG, JMX_PN_HTTPCACHE_CONFIG, new String[]{JMX_PN_ORDER, JMX_PN_OSGICOMPONENT}, new String[]{JMX_PN_ORDER, JMX_PN_OSGICOMPONENT}, new OpenType[]{SimpleType.INTEGER, SimpleType.STRING});
        TabularDataSupport tabularData = new TabularDataSupport(new TabularType(JMX_PN_HTTPCACHE_CONFIGS, JMX_PN_HTTPCACHE_CONFIGS, cacheEntryType, new String[]{JMX_PN_OSGICOMPONENT}));
        for (HttpCacheConfig cacheConfig : this.cacheConfigs) {
            HashMap<String, Object> row = new HashMap<String, Object>();
            Map<String, Object> osgiConfig = this.cacheConfigConfigs.get(cacheConfig);
            row.put(JMX_PN_ORDER, cacheConfig.getOrder());
            row.put(JMX_PN_OSGICOMPONENT, (String)osgiConfig.get("service.pid"));
            tabularData.put(new CompositeDataSupport(cacheEntryType, row));
        }
        return tabularData;
    }

    @Override
    public TabularData getRegisteredPersistenceStores() throws OpenDataException {
        CompositeType cacheEntryType = new CompositeType(JMX_PN_HTTPCACHE_STORE, JMX_PN_HTTPCACHE_STORE, new String[]{JMX_PN_HTTPCACHE_STORE}, new String[]{JMX_PN_HTTPCACHE_STORE}, new OpenType[]{SimpleType.STRING});
        TabularDataSupport tabularData = new TabularDataSupport(new TabularType(JMX_PN_HTTPCACHE_STORES, JMX_PN_HTTPCACHE_STORES, cacheEntryType, new String[]{JMX_PN_HTTPCACHE_STORE}));
        Enumeration<String> storeNames = cacheStoresMap.keys();
        while (storeNames.hasMoreElements()) {
            String storeName = storeNames.nextElement();
            HashMap<String, String> row = new HashMap<String, String>();
            row.put(JMX_PN_HTTPCACHE_STORE, storeName);
            tabularData.put(new CompositeDataSupport(cacheEntryType, row));
        }
        return tabularData;
    }

    private boolean isRequestCachableAccordingToHandlingRules(SlingHttpServletRequest request, SlingHttpServletResponse response, HttpCacheConfig cacheConfig, CacheContent cacheContent) {
        return this.checkOnHandlingRule(request, cacheConfig, rule -> rule.onResponseCache(request, response, cacheConfig, cacheContent), "Caching for request {} has been cancelled as per custom rule {}");
    }

    private boolean isRequestDeliverableFromCacheAccordingToHandlingRules(SlingHttpServletRequest request, SlingHttpServletResponse response, HttpCacheConfig cacheConfig, CacheContent cacheContent) {
        return this.checkOnHandlingRule(request, cacheConfig, rule -> rule.onCacheDeliver(request, response, cacheConfig, cacheContent), "Cache cannot be delivered for the url {} honoring the rule {}");
    }

    private boolean checkOnHandlingRule(SlingHttpServletRequest request, HttpCacheConfig cacheConfig, Function<HttpCacheHandlingRule, Boolean> check, String onFailLogMessage) {
        for (Map.Entry<String, HttpCacheHandlingRule> entry : cacheHandlingRules.entrySet()) {
            HttpCacheHandlingRule rule;
            if (!this.globalCacheHandlingRulesPid.contains(entry.getKey()) && !cacheConfig.acceptsRule(entry.getKey()) || check.apply(rule = entry.getValue()).booleanValue()) continue;
            if (log.isDebugEnabled()) {
                log.debug(onFailLogMessage, (Object)request.getRequestURL(), (Object)rule.getClass().getName());
            }
            return false;
        }
        return true;
    }

    private void prepareCachedResponse(SlingHttpServletResponse response, CacheContent cacheContent) {
        response.setStatus(cacheContent.getStatus());
        for (String headerName : cacheContent.getHeaders().keySet()) {
            for (String headerValue : cacheContent.getHeaders().get(headerName)) {
                response.setHeader(headerName, headerValue);
            }
        }
        response.setContentType(cacheContent.getContentType());
        response.setCharacterEncoding(cacheContent.getCharEncoding());
    }

    private boolean executeCacheContentDeliver(SlingHttpServletRequest request, SlingHttpServletResponse response, CacheContent cacheContent) throws HttpCacheDataStreamException {
        try {
            this.serveCacheContentIntoResponse(response, cacheContent);
            if (log.isDebugEnabled()) {
                log.debug("Response delivered from cache for the url [ {} ]", (Object)request.getRequestURI());
            }
            return true;
        }
        catch (IOException e) {
            throw new HttpCacheDataStreamException("Unable to copy from cached data to the servlet output stream.");
        }
    }

    private void serveCacheContentIntoResponse(SlingHttpServletResponse response, CacheContent cacheContent) throws IOException {
        try {
            IOUtils.copy((InputStream)cacheContent.getInputDataStream(), (OutputStream)response.getOutputStream());
        }
        catch (IllegalStateException ex) {
            IOUtils.copy((InputStream)cacheContent.getInputDataStream(), (Writer)response.getWriter(), (String)response.getCharacterEncoding());
        }
    }

    private void executeCustomRuleInvalidations(String path, HttpCacheConfig cacheConfig) throws HttpCachePersistenceException, HttpCacheKeyCreationException {
        for (Map.Entry<String, HttpCacheHandlingRule> entry : cacheHandlingRules.entrySet()) {
            if (!this.globalCacheHandlingRulesPid.contains(entry.getKey()) && !cacheConfig.acceptsRule(entry.getKey())) continue;
            HttpCacheHandlingRule rule = entry.getValue();
            if (rule.onCacheInvalidate(path)) {
                this.getCacheStore(cacheConfig).invalidate(cacheConfig.buildCacheKey(path));
                continue;
            }
            log.debug("Cache invalidation rejected for path {} per custom rule {}", (Object)path, (Object)rule.getClass().getName());
        }
    }
}

