/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.acs.commons.httpcache.store.jcr.impl;

import com.adobe.acs.commons.functions.Consumer;
import com.adobe.acs.commons.functions.Function;
import com.adobe.acs.commons.httpcache.config.HttpCacheConfig;
import com.adobe.acs.commons.httpcache.engine.CacheContent;
import com.adobe.acs.commons.httpcache.exception.HttpCacheDataStreamException;
import com.adobe.acs.commons.httpcache.keys.CacheKey;
import com.adobe.acs.commons.httpcache.keys.CacheKeyFactory;
import com.adobe.acs.commons.httpcache.store.HttpCacheStore;
import com.adobe.acs.commons.httpcache.store.TempSink;
import com.adobe.acs.commons.httpcache.store.jcr.impl.handler.BucketNodeHandler;
import com.adobe.acs.commons.httpcache.store.jcr.impl.handler.EntryNodeToCacheContentHandler;
import com.adobe.acs.commons.httpcache.store.jcr.impl.visitor.AllEntryNodesCountVisitor;
import com.adobe.acs.commons.httpcache.store.jcr.impl.visitor.EntryNodeByStringKeyVisitor;
import com.adobe.acs.commons.httpcache.store.jcr.impl.visitor.EntryNodeMapVisitor;
import com.adobe.acs.commons.httpcache.store.jcr.impl.visitor.ExpiredNodesVisitor;
import com.adobe.acs.commons.httpcache.store.jcr.impl.visitor.InvalidateAllNodesVisitor;
import com.adobe.acs.commons.httpcache.store.jcr.impl.visitor.InvalidateByCacheConfigVisitor;
import com.adobe.acs.commons.httpcache.store.jcr.impl.writer.BucketNodeFactory;
import com.adobe.acs.commons.httpcache.store.jcr.impl.writer.EntryNodeWriter;
import com.adobe.acs.commons.httpcache.store.mem.impl.MemTempSinkImpl;
import com.adobe.acs.commons.util.impl.AbstractJCRCacheMBean;
import com.adobe.acs.commons.util.impl.JcrCacheMBean;
import com.adobe.acs.commons.util.impl.exception.CacheMBeanException;
import java.io.IOException;
import java.io.InputStream;
import java.util.Collections;
import java.util.Dictionary;
import java.util.Map;
import java.util.concurrent.CopyOnWriteArrayList;
import javax.jcr.Node;
import javax.jcr.Session;
import javax.management.NotCompliantMBeanException;
import javax.management.openmbean.CompositeType;
import javax.management.openmbean.OpenDataException;
import javax.management.openmbean.OpenType;
import javax.management.openmbean.SimpleType;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;
import org.apache.felix.scr.annotations.Activate;
import org.apache.felix.scr.annotations.Component;
import org.apache.felix.scr.annotations.Properties;
import org.apache.felix.scr.annotations.Property;
import org.apache.felix.scr.annotations.Reference;
import org.apache.felix.scr.annotations.Service;
import org.apache.sling.api.resource.ResourceResolver;
import org.apache.sling.api.resource.ResourceResolverFactory;
import org.apache.sling.commons.classloader.DynamicClassLoaderManager;
import org.apache.sling.commons.osgi.PropertiesUtil;
import org.osgi.service.component.ComponentContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(label="ACS AEM Commons - Http Cache - JCR Cache Store.", description="Cache data store implementation for JCR storage.", metatype=true)
@Service(value={HttpCacheStore.class, JcrCacheMBean.class, Runnable.class})
@Properties(value={@Property(name="httpcache.cachestore.type", value={"JCR"}, propertyPrivate=true), @Property(name="jmx.objectname", value={"com.adobe.acs.httpcache:type=JCR HTTP Cache Store"}, propertyPrivate=true), @Property(label="Cache clean-up schedule", description="[every minute = 0 * * * * ?] Visit www.cronmaker.com to generate cron expressions.", name="scheduler.expression", value={"0 0 12 1/1 * ? *"}), @Property(label="Allow concurrent executions", description="Allow concurrent executions of this Scheduled Service. This is almost always false.", name="scheduler.concurrent", propertyPrivate=true, boolValue={false}), @Property(label="Cache-root Parent Path location", description="Points to the location of the cache root parent node in the JCR repository", name="httpcache.config.jcr.rootpath", value={"/var/acs-commons/httpcache"}), @Property(label="Cache bucketing tree depth", description="The depth the bucket tree goes. Minimum value is 1. This value can be used for tweaking performance. The more data cached, the higher this value should be. Downside is that the higher the value, the longer the retrieval of cache entries takes if the buckets are relatively low on entries.", name="httpcache.config.jcr.bucketdepth", intValue={10}, propertyPrivate=true), @Property(label="Save threshold", description="The threshold to add,remove and modify nodes when handling the cache", name="httpcache.config.jcr.savedelta", intValue={500}), @Property(label="Expire time in seconds", description="The time seconds after which nodes will be removed by the scheduled cleanup service. ", name="httpcache.config.jcr.expiretimeinseconds", intValue={604800})})
public class JCRHttpCacheStoreImpl
extends AbstractJCRCacheMBean<CacheKey, CacheContent>
implements HttpCacheStore,
JcrCacheMBean,
Runnable {
    public static final String PN_ROOTPATH = "httpcache.config.jcr.rootpath";
    public static final String PN_BUCKETDEPTH = "httpcache.config.jcr.bucketdepth";
    public static final String PN_SAVEDELTA = "httpcache.config.jcr.savedelta";
    public static final String PN_EXPIRETIMEINSECONDS = "httpcache.config.jcr.expiretimeinseconds";
    public static final String DEFAULT_ROOTPATH = "/var/acs-commons/httpcache";
    private static final String SERVICE_NAME = "httpcache-jcr-storage-service";
    private static final Map<String, Object> AUTH_INFO = Collections.singletonMap("sling.service.subservice", "httpcache-jcr-storage-service");
    public static final int DEFAULT_BUCKETDEPTH = 10;
    public static final int DEFAULT_SAVEDELTA = 500;
    public static final int DEFAULT_EXPIRETIMEINSECONDS = 604800;
    private static final Logger log = LoggerFactory.getLogger(JCRHttpCacheStoreImpl.class);
    private String cacheRootPath;
    private int bucketTreeDepth;
    private int deltaSaveThreshold;
    private int expireTimeInSeconds;
    @Reference
    private ResourceResolverFactory resourceResolverFactory;
    @Reference
    private DynamicClassLoaderManager dclm;
    private final CopyOnWriteArrayList<CacheKeyFactory> cacheKeyFactories = new CopyOnWriteArrayList();

    public JCRHttpCacheStoreImpl() throws NotCompliantMBeanException {
        super(JcrCacheMBean.class);
    }

    @Activate
    protected void activate(ComponentContext context) {
        Dictionary properties = context.getProperties();
        this.cacheRootPath = PropertiesUtil.toString(properties.get(PN_ROOTPATH), (String)DEFAULT_ROOTPATH) + "/" + "root";
        this.bucketTreeDepth = PropertiesUtil.toInteger(properties.get(PN_BUCKETDEPTH), (int)10);
        this.deltaSaveThreshold = PropertiesUtil.toInteger(properties.get(PN_SAVEDELTA), (int)500);
        this.expireTimeInSeconds = PropertiesUtil.toInteger(properties.get(PN_EXPIRETIMEINSECONDS), (int)604800);
    }

    @Override
    public void put(final CacheKey key, final CacheContent content) throws HttpCacheDataStreamException {
        final long currentTime = System.currentTimeMillis();
        this.incrementLoadCount();
        this.withSession(new Consumer<Session>(){

            @Override
            public void accept(Session session) throws Exception {
                BucketNodeFactory factory = new BucketNodeFactory(session, JCRHttpCacheStoreImpl.this.cacheRootPath, key, JCRHttpCacheStoreImpl.this.bucketTreeDepth);
                Node bucketNode = factory.getBucketNode();
                Node entryNode = new BucketNodeHandler(bucketNode, JCRHttpCacheStoreImpl.this.dclm).createOrRetrieveEntryNode(key);
                new EntryNodeWriter(session, entryNode, key, content, JCRHttpCacheStoreImpl.this.expireTimeInSeconds).write();
                session.save();
                JCRHttpCacheStoreImpl.this.incrementLoadSuccessCount();
                JCRHttpCacheStoreImpl.this.incrementTotalLoadTime(System.currentTimeMillis() - currentTime);
            }
        }, new Consumer<Exception>(){

            @Override
            public void accept(Exception e) throws Exception {
                JCRHttpCacheStoreImpl.this.incrementLoadExceptionCount();
            }
        });
    }

    @Override
    public boolean contains(final CacheKey key) {
        final long currentTime = System.currentTimeMillis();
        this.incrementRequestCount();
        return this.withSession(new Function<Session, Boolean>(){

            @Override
            public Boolean apply(Session session) throws Exception {
                Node entryNode;
                BucketNodeFactory factory = new BucketNodeFactory(session, JCRHttpCacheStoreImpl.this.cacheRootPath, key, JCRHttpCacheStoreImpl.this.bucketTreeDepth);
                Node bucketNode = factory.getBucketNode();
                if (bucketNode != null && (entryNode = new BucketNodeHandler(bucketNode, JCRHttpCacheStoreImpl.this.dclm).getEntryIfExists(key)) != null) {
                    JCRHttpCacheStoreImpl.this.incrementTotalLookupTime(System.currentTimeMillis() - currentTime);
                    JCRHttpCacheStoreImpl.this.incrementHitCount();
                    return true;
                }
                JCRHttpCacheStoreImpl.this.incrementTotalLookupTime(System.currentTimeMillis() - currentTime);
                JCRHttpCacheStoreImpl.this.incrementMissCount();
                return false;
            }
        });
    }

    @Override
    public CacheContent getIfPresent(final CacheKey key) {
        final long currentTime = System.currentTimeMillis();
        this.incrementRequestCount();
        return this.withSession(new Function<Session, CacheContent>(){

            @Override
            public CacheContent apply(Session session) throws Exception {
                Node entryNode;
                CacheContent content;
                BucketNodeFactory factory = new BucketNodeFactory(session, JCRHttpCacheStoreImpl.this.cacheRootPath, key, JCRHttpCacheStoreImpl.this.bucketTreeDepth);
                Node bucketNode = factory.getBucketNode();
                if (bucketNode != null && (content = new EntryNodeToCacheContentHandler(entryNode = new BucketNodeHandler(bucketNode, JCRHttpCacheStoreImpl.this.dclm).getEntryIfExists(key)).get()) != null) {
                    JCRHttpCacheStoreImpl.this.incrementTotalLookupTime(System.currentTimeMillis() - currentTime);
                    JCRHttpCacheStoreImpl.this.incrementHitCount();
                    return content;
                }
                JCRHttpCacheStoreImpl.this.incrementTotalLookupTime(System.currentTimeMillis() - currentTime);
                JCRHttpCacheStoreImpl.this.incrementMissCount();
                return null;
            }
        });
    }

    @Override
    public long size() {
        return this.withSession(new Function<Session, Long>(){

            @Override
            public Long apply(Session session) throws Exception {
                Node rootNode = session.getNode(JCRHttpCacheStoreImpl.this.cacheRootPath);
                AllEntryNodesCountVisitor visitor = new AllEntryNodesCountVisitor(11);
                visitor.visit(rootNode);
                return visitor.getTotalEntryNodeCount();
            }
        });
    }

    @Override
    public void invalidate(final CacheKey key) {
        this.withSession(new Consumer<Session>(){

            @Override
            public void accept(Session session) throws Exception {
                Node entryNode;
                BucketNodeFactory factory = new BucketNodeFactory(session, JCRHttpCacheStoreImpl.this.cacheRootPath, key, JCRHttpCacheStoreImpl.this.bucketTreeDepth);
                Node bucketNode = factory.getBucketNode();
                if (bucketNode != null && (entryNode = new BucketNodeHandler(bucketNode, JCRHttpCacheStoreImpl.this.dclm).getEntryIfExists(key)) != null) {
                    entryNode.remove();
                    session.save();
                    JCRHttpCacheStoreImpl.this.incrementEvictionCount(1L);
                }
            }
        });
    }

    @Override
    public void invalidate(final HttpCacheConfig cacheConfig) {
        this.withSession(new Consumer<Session>(){

            @Override
            public void accept(Session session) throws Exception {
                InvalidateByCacheConfigVisitor visitor = new InvalidateByCacheConfigVisitor(11, JCRHttpCacheStoreImpl.this.deltaSaveThreshold, cacheConfig, JCRHttpCacheStoreImpl.this.dclm);
                Node rootNode = session.getNode(JCRHttpCacheStoreImpl.this.cacheRootPath);
                visitor.visit(rootNode);
                visitor.close();
                JCRHttpCacheStoreImpl.this.incrementEvictionCount(visitor.getEvictionCount());
            }
        });
    }

    @Override
    public void invalidateAll() {
        this.withSession(new Consumer<Session>(){

            @Override
            public void accept(Session session) throws Exception {
                Node rootNode = session.getNode(JCRHttpCacheStoreImpl.this.cacheRootPath);
                InvalidateAllNodesVisitor visitor = new InvalidateAllNodesVisitor(11, JCRHttpCacheStoreImpl.this.deltaSaveThreshold);
                visitor.visit(rootNode);
                visitor.close();
                JCRHttpCacheStoreImpl.this.incrementEvictionCount(visitor.getEvictionCount());
            }
        });
    }

    @Override
    public TempSink createTempSink() {
        return new MemTempSinkImpl();
    }

    @Override
    public void run() {
        this.purgeExpiredEntries();
    }

    @Override
    public void purgeExpiredEntries() {
        this.withSession(new Consumer<Session>(){

            @Override
            public void accept(Session session) throws Exception {
                Node rootNode = session.getNode(JCRHttpCacheStoreImpl.this.cacheRootPath);
                ExpiredNodesVisitor visitor = new ExpiredNodesVisitor(11, JCRHttpCacheStoreImpl.this.deltaSaveThreshold);
                visitor.visit(rootNode);
                visitor.close();
                JCRHttpCacheStoreImpl.this.incrementEvictionCount(visitor.getEvictionCount());
            }
        });
    }

    @Override
    public long getTtl() {
        return this.expireTimeInSeconds;
    }

    @Override
    public void clearCache() {
        this.invalidateAll();
    }

    @Override
    public String getCacheEntry(final String cacheKeyStr) throws CacheMBeanException {
        return this.withSession(new Function<Session, String>(){

            @Override
            public String apply(Session session) throws Exception {
                EntryNodeByStringKeyVisitor visitor = new EntryNodeByStringKeyVisitor(11, JCRHttpCacheStoreImpl.this.dclm, cacheKeyStr);
                Node rootNode = session.getNode(JCRHttpCacheStoreImpl.this.cacheRootPath);
                visitor.visit(rootNode);
                CacheContent content = visitor.getCacheContentIfPresent();
                if (content != null) {
                    return IOUtils.toString((InputStream)content.getInputDataStream());
                }
                return "not found";
            }
        });
    }

    protected void bindCacheKeyFactory(CacheKeyFactory cacheKeyFactory) {
        this.cacheKeyFactories.add(cacheKeyFactory);
    }

    protected void unbindCacheKeyFactory(CacheKeyFactory cacheKeyFactory) {
        if (this.cacheKeyFactories.contains(cacheKeyFactory)) {
            this.cacheKeyFactories.remove(cacheKeyFactory);
        }
    }

    @Override
    protected Map<CacheKey, CacheContent> getCacheAsMap() {
        return this.withSession(new Function<Session, Map<CacheKey, CacheContent>>(){

            @Override
            public Map<CacheKey, CacheContent> apply(Session session) throws Exception {
                Node rootNode = session.getNode(JCRHttpCacheStoreImpl.this.cacheRootPath);
                EntryNodeMapVisitor visitor = new EntryNodeMapVisitor(11, JCRHttpCacheStoreImpl.this.dclm);
                visitor.visit(rootNode);
                return visitor.getCache();
            }
        });
    }

    @Override
    protected long getBytesLength(CacheContent cacheObj) {
        try {
            return IOUtils.toByteArray((InputStream)cacheObj.getInputDataStream()).length;
        }
        catch (IOException e) {
            log.error("Error reading the byte length on cachecontent {}", (Object)cacheObj);
            return 0L;
        }
    }

    @Override
    protected void addCacheData(Map<String, Object> data, CacheContent cacheObj) {
        data.put("Status", cacheObj.getStatus());
        data.put("Content Type", cacheObj.getContentType());
        data.put("Character Encoding", cacheObj.getCharEncoding());
        try {
            data.put("Size", FileUtils.byteCountToDisplaySize((long)IOUtils.toByteArray((InputStream)cacheObj.getInputDataStream()).length));
        }
        catch (IOException e) {
            log.error("Error adding cache data to JMX data map", (Throwable)e);
            data.put("Size", "0");
        }
    }

    @Override
    protected String toString(CacheContent cacheObj) throws CacheMBeanException {
        try {
            return IOUtils.toString((InputStream)cacheObj.getInputDataStream(), (String)cacheObj.getCharEncoding());
        }
        catch (IOException e) {
            throw new CacheMBeanException("Failed to get the cache contents", e);
        }
    }

    @Override
    protected CompositeType getCacheEntryType() throws OpenDataException {
        return new CompositeType("Cache Entry", "Cache Entry", new String[]{"Cache Key", "Status", "Size", "Content Type", "Character Encoding"}, new String[]{"Cache Key", "Status", "Size", "Content Type", "Character Encoding"}, new OpenType[]{SimpleType.STRING, SimpleType.INTEGER, SimpleType.STRING, SimpleType.STRING, SimpleType.STRING});
    }

    public void withSession(Consumer<Session> onSuccess) {
        this.withSession(onSuccess, null);
    }

    public void withSession(final Consumer<Session> onSuccess, Consumer<Exception> onError) {
        this.withSession(new Function<Session, Object>(){

            @Override
            public Object apply(Session session) throws Exception {
                onSuccess.accept(session);
                return null;
            }
        }, onError);
    }

    public <T> T withSession(Function<Session, T> onSuccess) {
        return this.withSession(onSuccess, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T> T withSession(Function<Session, T> onSuccess, Consumer<Exception> onError) {
        ResourceResolver resourceResolver = null;
        try {
            resourceResolver = this.resourceResolverFactory.getServiceResourceResolver(AUTH_INFO);
            Session session = (Session)resourceResolver.adaptTo(Session.class);
            Object r = onSuccess.apply(session);
            return (T)r;
        }
        catch (Exception e) {
            log.error("Error in executing the session", (Throwable)e);
            try {
                if (onError != null) {
                    onError.accept(e);
                }
            }
            catch (Exception subException) {
                log.error("Error in handling the exception", (Throwable)subException);
            }
        }
        finally {
            if (resourceResolver != null && resourceResolver.isLive()) {
                resourceResolver.close();
            }
        }
        return null;
    }

    protected void bindResourceResolverFactory(ResourceResolverFactory resourceResolverFactory) {
        this.resourceResolverFactory = resourceResolverFactory;
    }

    protected void unbindResourceResolverFactory(ResourceResolverFactory resourceResolverFactory) {
        if (this.resourceResolverFactory == resourceResolverFactory) {
            this.resourceResolverFactory = null;
        }
    }

    protected void bindDclm(DynamicClassLoaderManager dynamicClassLoaderManager) {
        this.dclm = dynamicClassLoaderManager;
    }

    protected void unbindDclm(DynamicClassLoaderManager dynamicClassLoaderManager) {
        if (this.dclm == dynamicClassLoaderManager) {
            this.dclm = null;
        }
    }
}

