/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.acs.commons.httpcache.store.jcr.impl.handler;

import com.adobe.acs.commons.httpcache.keys.CacheKey;
import com.adobe.acs.commons.httpcache.store.jcr.impl.handler.EntryNodeToCacheKeyHandler;
import java.io.IOException;
import javax.jcr.Node;
import javax.jcr.NodeIterator;
import javax.jcr.RepositoryException;
import org.apache.jackrabbit.commons.JcrUtils;
import org.apache.sling.commons.classloader.DynamicClassLoaderManager;

public class BucketNodeHandler {
    private final Node bucketNode;
    private final DynamicClassLoaderManager dynamicClassLoaderManager;

    public BucketNodeHandler(Node node, DynamicClassLoaderManager dynamicClassLoaderManager) {
        this.bucketNode = node;
        this.dynamicClassLoaderManager = dynamicClassLoaderManager;
    }

    public Node createOrRetrieveEntryNode(CacheKey key) throws RepositoryException, IOException, ClassNotFoundException {
        Node existingEntryNode = this.getEntryIfExists(key);
        if (null != existingEntryNode) {
            return existingEntryNode;
        }
        return JcrUtils.getOrCreateUniqueByPath((Node)this.bucketNode, (String)"entry", (String)"oak:Unstructured");
    }

    public Node getEntryIfExists(CacheKey key) throws RepositoryException, IOException, ClassNotFoundException {
        NodeIterator entryNodeIterator = this.bucketNode.getNodes();
        while (entryNodeIterator.hasNext()) {
            Node entryNode = entryNodeIterator.nextNode();
            CacheKey entryKey = new EntryNodeToCacheKeyHandler(entryNode, this.dynamicClassLoaderManager).get();
            if (!key.equals(entryKey)) continue;
            return entryNode;
        }
        return null;
    }
}

