/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.acs.commons.httpcache.store.jcr.impl.handler;

import com.adobe.acs.commons.httpcache.engine.CacheContent;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.jcr.Binary;
import javax.jcr.Node;
import javax.jcr.Property;
import javax.jcr.PropertyIterator;
import javax.jcr.RepositoryException;
import javax.jcr.Value;

public class EntryNodeToCacheContentHandler {
    private final Node entryNode;
    private String contentType;
    private String charEncoding;
    private int status;
    private InputStream inputStream;
    private final Map<String, List<String>> headers = new HashMap<String, List<String>>();
    private Binary binary;
    private static final String SLING_NAMESPACE = "sling:";
    private static final String JCR_NAMESPACE = "jcr:";

    public EntryNodeToCacheContentHandler(Node entryNode) throws RepositoryException {
        this.entryNode = entryNode;
        if (entryNode != null) {
            this.retrieveHeaders();
            this.retrieveProperties();
            this.inputStream = this.retrieveInputStream();
        }
    }

    private void retrieveProperties() throws RepositoryException {
        PropertyIterator propertyIterator = this.entryNode.getProperties();
        while (propertyIterator.hasNext()) {
            Property property = propertyIterator.nextProperty();
            String propName = property.getName();
            Value value = property.getValue();
            if (propName.equals("content-type")) {
                this.contentType = value.getString();
                continue;
            }
            if (propName.equals("char-encoding")) {
                this.charEncoding = value.getString();
                continue;
            }
            if (!propName.equals("status")) continue;
            this.status = (int)value.getLong();
        }
    }

    public CacheContent get() throws RepositoryException {
        return new CacheContent(this.status, this.charEncoding, this.contentType, this.headers, this.inputStream);
    }

    public Binary getBinary() {
        return this.binary;
    }

    private void retrieveHeaders() throws RepositoryException {
        if (this.entryNode.hasNode("headers")) {
            Node headerNode = this.entryNode.getNode("headers");
            PropertyIterator propertyIterator = headerNode.getProperties();
            while (propertyIterator.hasNext()) {
                Property property = propertyIterator.nextProperty();
                String name = property.getName();
                if (this.isNativeProperty(name)) continue;
                Value[] values = property.getValues();
                ArrayList<String> stringValues = new ArrayList<String>(values.length);
                for (Value value : values) {
                    stringValues.add(value.getString());
                }
                this.headers.put(name, stringValues);
            }
        }
    }

    private boolean isNativeProperty(String propertyName) {
        return propertyName.startsWith(JCR_NAMESPACE) && !propertyName.startsWith(SLING_NAMESPACE);
    }

    private InputStream retrieveInputStream() throws RepositoryException {
        if (this.entryNode.hasNode("contents")) {
            Node contentsNode = this.entryNode.getNode("contents");
            Node jcrContent = contentsNode.getNode("jcr:content");
            Property binaryProperty = jcrContent.getProperty("jcr:data");
            this.binary = binaryProperty.getBinary();
            return this.binary.getStream();
        }
        return null;
    }
}

