/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.acs.commons.httpcache.store.jcr.impl.visitor;

import com.adobe.acs.commons.httpcache.store.jcr.impl.visitor.AbstractNodeVisitor;
import java.util.Calendar;
import javax.jcr.Node;
import javax.jcr.Property;
import javax.jcr.RepositoryException;

public class ExpiredNodesVisitor
extends AbstractNodeVisitor {
    public ExpiredNodesVisitor(int maxLevel, long deltaSaveThreshold) {
        super(maxLevel, deltaSaveThreshold);
    }

    @Override
    protected void leaving(Node node, int level) throws RepositoryException {
        if (ExpiredNodesVisitor.isCacheEntryNode(node)) {
            this.checkNodeForExpiry(node);
        } else if (ExpiredNodesVisitor.isEmptyBucketNode(node)) {
            node.remove();
            this.persistSession();
        }
        super.leaving(node, level);
    }

    private void checkNodeForExpiry(Node node) throws RepositoryException {
        Calendar now;
        Property expiryProperty;
        Calendar expireDate;
        if (node.hasProperty("expiresOn") && (expireDate = (expiryProperty = node.getProperty("expiresOn")).getDate()).before(now = Calendar.getInstance())) {
            node.remove();
            this.persistSession();
        }
    }
}

