/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.acs.commons.mcp.form;

import aQute.bnd.annotation.ProviderType;
import com.adobe.acs.commons.mcp.form.FormField;
import com.adobe.acs.commons.mcp.impl.AbstractResourceImpl;
import java.lang.reflect.Field;
import java.util.Optional;
import java.util.stream.Stream;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.resource.ResourceMetadata;
import org.apache.sling.api.scripting.SlingScriptHelper;

@ProviderType
public abstract class FieldComponent {
    private String name;
    protected FormField formField;
    protected Field javaField;
    protected SlingScriptHelper sling;
    private final ResourceMetadata componentMetadata = new ResourceMetadata();
    private String resourceType = "granite/ui/components/coral/foundation/form/textfield";
    private String resourceSuperType = "granite/ui/components/coral/foundation/form/field";
    private Resource resource;

    public final void setup(String name, Field javaField, FormField field, SlingScriptHelper sling) {
        this.name = name;
        this.formField = field;
        this.sling = sling;
        this.javaField = javaField;
        this.componentMetadata.put("name", (Object)name);
        this.componentMetadata.put("fieldLabel", (Object)this.formField.name());
        this.componentMetadata.put("fieldDescription", (Object)this.formField.description());
        this.componentMetadata.put("required", (Object)this.formField.required());
        this.componentMetadata.put("emptyText", (Object)this.formField.hint());
        this.getOption("default").ifPresent(val -> this.componentMetadata.put("value", val));
        this.init();
    }

    public abstract void init();

    public SlingScriptHelper getHelper() {
        return this.sling;
    }

    public Field getField() {
        return this.javaField;
    }

    public FormField getFieldDefinition() {
        return this.formField;
    }

    public String getHtml() {
        this.sling.include(this.getComponentResource());
        return "";
    }

    private Resource getComponentResource() {
        if (this.resource == null) {
            this.resource = this.buildComponentResource();
        }
        return this.resource;
    }

    public Resource buildComponentResource() {
        AbstractResourceImpl res = new AbstractResourceImpl("/fake/path", this.resourceType, this.resourceSuperType, this.componentMetadata);
        res.setResourceResolver(this.sling.getRequest().getResourceResolver());
        return res;
    }

    public ResourceMetadata getComponentMetadata() {
        return this.componentMetadata;
    }

    public String getResourceType() {
        return this.resourceType;
    }

    public void setResourceType(String resourceType) {
        this.resourceType = resourceType;
    }

    public String getResourceSuperType() {
        return this.resourceSuperType;
    }

    public void setResourceSuperType(String resourceSuperType) {
        this.resourceSuperType = resourceSuperType;
    }

    public String getName() {
        return this.name;
    }

    public boolean hasOption(String optionName) {
        return Stream.of(this.formField.options()).filter(s -> s.equalsIgnoreCase(optionName) || s.startsWith(optionName + "=")).findFirst().isPresent();
    }

    public Optional<String> getOption(String option) {
        return Stream.of(this.formField.options()).filter(s -> s.startsWith(option + "=")).findFirst().map(o -> o.split("=")[1]);
    }
}

