/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.acs.commons.mcp.impl;

import com.adobe.acs.commons.fam.ActionManagerFactory;
import com.adobe.acs.commons.mcp.ControlledProcessManager;
import com.adobe.acs.commons.mcp.ProcessDefinition;
import com.adobe.acs.commons.mcp.ProcessDefinitionFactory;
import com.adobe.acs.commons.mcp.ProcessInstance;
import com.adobe.acs.commons.mcp.impl.ProcessInstanceImpl;
import com.adobe.acs.commons.mcp.model.impl.ArchivedProcessInstance;
import com.adobe.acs.commons.util.visitors.TreeFilteringResourceVisitor;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CopyOnWriteArrayList;
import javax.management.openmbean.OpenDataException;
import javax.management.openmbean.TabularDataSupport;
import org.apache.felix.scr.annotations.Component;
import org.apache.felix.scr.annotations.Property;
import org.apache.felix.scr.annotations.Reference;
import org.apache.felix.scr.annotations.ReferenceCardinality;
import org.apache.felix.scr.annotations.ReferencePolicy;
import org.apache.felix.scr.annotations.Service;
import org.apache.sling.api.resource.LoginException;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.resource.ResourceResolver;
import org.apache.sling.api.resource.ResourceResolverFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component
@Service(value={ControlledProcessManager.class})
@Property(name="jmx.objectname", value={"com.adobe.acs.commons:type=Manage Controlled Processes"})
public class ControlledProcessManagerImpl
implements ControlledProcessManager {
    private static final Logger LOG = LoggerFactory.getLogger(ControlledProcessManagerImpl.class);
    private static final String SERVICE_NAME = "manage-controlled-processes";
    private static final Map<String, Object> AUTH_INFO = Collections.singletonMap("sling.service.subservice", "manage-controlled-processes");
    @Reference(cardinality=ReferenceCardinality.MANDATORY_MULTIPLE, bind="bindDefinitionFactory", unbind="unbindDefinitionFactory", referenceInterface=ProcessDefinitionFactory.class, policy=ReferencePolicy.DYNAMIC)
    private final List<ProcessDefinitionFactory> processDefinitionFactories = new CopyOnWriteArrayList<ProcessDefinitionFactory>();
    Map<String, ProcessInstance> activeProcesses = Collections.synchronizedMap(new LinkedHashMap());
    @Reference
    ResourceResolverFactory resourceResolverFactory;
    @Reference
    ActionManagerFactory amf;

    @Override
    public ActionManagerFactory getActionManagerFactory() {
        return this.amf;
    }

    protected void bindDefinitionFactory(ProcessDefinitionFactory fac) {
        this.processDefinitionFactories.add(fac);
    }

    protected void unbindDefinitionFactory(ProcessDefinitionFactory fac) {
        this.processDefinitionFactories.remove(fac);
    }

    @Override
    public ProcessInstance getManagedProcessInstanceByPath(String path) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public ProcessInstance getManagedProcessInstanceByIdentifier(String id) {
        ProcessInstance process = this.activeProcesses.get(id);
        if (process != null) {
            process.updateProgress();
        }
        return process;
    }

    @Override
    public ProcessInstance createManagedProcessInstance(ProcessDefinition definition, String description) {
        ProcessInstanceImpl instance = new ProcessInstanceImpl(this, definition, description);
        this.activeProcesses.put(instance.getId(), instance);
        return instance;
    }

    @Override
    public void haltActiveProcesses() {
        HashSet<ProcessInstance> instances = new HashSet<ProcessInstance>(this.activeProcesses.values());
        this.activeProcesses.clear();
        instances.forEach(ProcessInstance::halt);
    }

    @Override
    public void purgeCompletedProcesses() {
        this.activeProcesses.values().removeIf(proc -> !proc.getInfo().isIsRunning());
    }

    @Override
    public ResourceResolver getServiceResourceResolver() throws LoginException {
        return this.resourceResolverFactory.getServiceResourceResolver(AUTH_INFO);
    }

    @Override
    public ProcessDefinition findDefinitionByNameOrPath(String nameOrPath) throws ReflectiveOperationException {
        if (nameOrPath.startsWith("/")) {
            return this.findDefinitionByPath(nameOrPath);
        }
        return this.findDefinitionByName(nameOrPath);
    }

    private ProcessDefinition findDefinitionByName(String name) throws ReflectiveOperationException {
        ProcessDefinitionFactory factory = this.processDefinitionFactories.stream().filter(f -> name.equals(f.getName())).findFirst().orElseThrow(() -> new IllegalArgumentException("Unable to find process " + name));
        return factory.createProcessDefinition();
    }

    private ProcessDefinition findDefinitionByPath(String path) throws ReflectiveOperationException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public TabularDataSupport getStatistics() throws OpenDataException {
        TabularDataSupport stats = new TabularDataSupport(ProcessInstanceImpl.getStaticsTableType());
        this.activeProcesses.values().stream().map(ProcessInstance::getStatistics).forEach(stats::put);
        return stats;
    }

    @Override
    public void haltProcessById(String id) {
        this.getManagedProcessInstanceByIdentifier(id).halt();
    }

    @Override
    public void haltProcessByPath(String path) {
        this.getManagedProcessInstanceByPath(path).halt();
    }

    @Override
    public Collection<ProcessInstance> getActiveProcesses() {
        this.activeProcesses.forEach((id, process) -> process.updateProgress());
        return this.activeProcesses.values();
    }

    @Override
    public Collection<ProcessInstance> getInactiveProcesses() {
        ArrayList<ProcessInstance> processes = new ArrayList<ProcessInstance>();
        try (ResourceResolver rr = this.getServiceResourceResolver();){
            Resource tree = rr.getResource("/var/acs-commons/mcp/instances");
            TreeFilteringResourceVisitor visitor = new TreeFilteringResourceVisitor();
            visitor.setLeafVisitor((r, l) -> {
                if (!this.activeProcesses.containsKey(r.getName())) {
                    processes.add((ProcessInstance)r.adaptTo(ArchivedProcessInstance.class));
                }
            });
            visitor.accept(tree);
        }
        catch (LoginException ex) {
            LOG.error("Error getting inactive process list", (Throwable)ex);
        }
        return processes;
    }

    protected void bindResourceResolverFactory(ResourceResolverFactory resourceResolverFactory) {
        this.resourceResolverFactory = resourceResolverFactory;
    }

    protected void unbindResourceResolverFactory(ResourceResolverFactory resourceResolverFactory) {
        if (this.resourceResolverFactory == resourceResolverFactory) {
            this.resourceResolverFactory = null;
        }
    }

    protected void bindAmf(ActionManagerFactory actionManagerFactory) {
        this.amf = actionManagerFactory;
    }

    protected void unbindAmf(ActionManagerFactory actionManagerFactory) {
        if (this.amf == actionManagerFactory) {
            this.amf = null;
        }
    }
}

