/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.acs.commons.mcp.impl.processes;

import com.adobe.acs.commons.data.CompositeVariant;
import com.adobe.acs.commons.data.Spreadsheet;
import com.adobe.acs.commons.fam.ActionManager;
import com.adobe.acs.commons.mcp.ProcessDefinition;
import com.adobe.acs.commons.mcp.ProcessInstance;
import com.adobe.acs.commons.mcp.form.CheckboxComponent;
import com.adobe.acs.commons.mcp.form.FileUploadComponent;
import com.adobe.acs.commons.mcp.form.FormField;
import com.adobe.acs.commons.mcp.form.RadioComponent;
import com.adobe.acs.commons.mcp.model.GenericReport;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.jcr.RepositoryException;
import org.apache.commons.lang3.StringUtils;
import org.apache.sling.api.request.RequestParameter;
import org.apache.sling.api.resource.LoginException;
import org.apache.sling.api.resource.ModifiableValueMap;
import org.apache.sling.api.resource.PersistenceException;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.resource.ResourceResolver;
import org.apache.sling.api.resource.ResourceUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DataImporter
extends ProcessDefinition {
    private static final Logger LOG = LoggerFactory.getLogger(DataImporter.class);
    private static final String PATH = "path";
    private boolean enableHeaderNameConversion = false;
    @FormField(name="Excel File", description="Provide the .xlsx file that defines the nodes being imported", component=FileUploadComponent.class, options={"mimeTypes=application/vnd.openxmlformats-officedocument.spreadsheetml.sheet", "required"})
    private transient RequestParameter importFile;
    @FormField(name="Existing action", description="What to do if an asset exists", component=RadioComponent.EnumerationSelector.class, options={"default=create_and_overwrite_properties", "vertical"})
    private MergeMode mergeMode = MergeMode.CREATE_AND_OVERWRITE_PROPERTIES;
    @FormField(name="Structure node type", description="Type assigned to new nodes (ignored if spreadsheet has a jcr:primayType column) -- for ordered folders use sling:OrderedFolder", options={"default=sling:Folder"})
    private String defaultNodeType = "sling:Folder";
    @FormField(name="Dry run", description="If checked, no import happens.  Useful for data validation", component=CheckboxComponent.class)
    private boolean dryRunMode = false;
    @FormField(name="Detailed report", description="If checked, information about every asset is recorded", component=CheckboxComponent.class, options={"checked"})
    private boolean detailedReport = true;
    @FormField(name="Import in sorted order", description="If checked, nodes will be imported in the order determined by their paths", component=CheckboxComponent.class, options={"checked"})
    private boolean presortData = true;
    public static final String TOTAL = "Total";
    EnumMap<ReportColumns, Object> createdNodes = this.trackActivity("Total", "Create", 0);
    EnumMap<ReportColumns, Object> updatedNodes = this.trackActivity("Total", "Updated", 0);
    EnumMap<ReportColumns, Object> skippedNodes = this.trackActivity("Total", "Skipped", 0);
    EnumMap<ReportColumns, Object> noChangeNodes = this.trackActivity("Total", "No Change", 0);
    Spreadsheet data;
    List<EnumMap<ReportColumns, Object>> reportRows;
    private transient GenericReport report = new GenericReport();

    protected synchronized EnumMap<ReportColumns, Object> trackActivity(String item, String action, Integer count) {
        if (this.reportRows == null) {
            this.reportRows = Collections.synchronizedList(new ArrayList());
        }
        EnumMap<ReportColumns, Object> reportRow = new EnumMap<ReportColumns, Object>(ReportColumns.class);
        reportRow.put(ReportColumns.item, item);
        reportRow.put(ReportColumns.action, action);
        reportRow.put(ReportColumns.count, count);
        this.reportRows.add(reportRow);
        return reportRow;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void incrementCount(EnumMap<ReportColumns, Object> row, int amt) {
        EnumMap<ReportColumns, Object> enumMap = row;
        synchronized (enumMap) {
            row.put(ReportColumns.count, (Object)((Integer)row.getOrDefault((Object)ReportColumns.count, 0) + amt));
        }
    }

    @Override
    public void init() throws RepositoryException {
    }

    @Override
    public void buildProcess(ProcessInstance instance, ResourceResolver rr) throws LoginException, RepositoryException {
        try {
            this.data = new Spreadsheet(this.enableHeaderNameConversion, this.importFile, PATH);
            if (this.presortData) {
                Collections.sort(this.data.getDataRowsAsCompositeVariants(), (a, b) -> ((CompositeVariant)b.get(PATH)).toString().compareTo(((CompositeVariant)a.get(PATH)).toString()));
            }
            instance.getInfo().setDescription("Import " + this.data.getFileName() + " (" + this.data.getRowCount() + " rows)");
        }
        catch (IOException ex) {
            LOG.error("Unable to process import", (Throwable)ex);
            instance.getInfo().setDescription("Import " + this.data.getFileName() + " (failed)");
            throw new RepositoryException("Unable to parse input file", (Throwable)ex);
        }
        instance.defineCriticalAction("Import Data", rr, this::importData);
    }

    @Override
    public void storeReport(ProcessInstance instance, ResourceResolver rr) throws RepositoryException, PersistenceException {
        this.report.setRows(this.reportRows, ReportColumns.class);
        this.report.persist(rr, instance.getPath() + "/jcr:content/report");
    }

    private void importData(ActionManager manager) {
        this.data.getDataRowsAsCompositeVariants().forEach(row -> manager.deferredWithResolver(rr -> {
            String path = ((CompositeVariant)row.get(PATH)).toString();
            Resource r = rr.getResource(path);
            if (r == null) {
                this.handleMissingNode(path, (ResourceResolver)rr, (Map<String, CompositeVariant>)row);
            } else if (this.mergeMode.update) {
                this.updateMetadata((ResourceResolver)rr, (Map<String, CompositeVariant>)row);
            } else {
                this.incrementCount(this.skippedNodes, 1);
                if (this.detailedReport) {
                    this.trackActivity(path, "Skipped", null);
                }
            }
        }));
    }

    public void handleMissingNode(String path, ResourceResolver rr, Map<String, CompositeVariant> row) throws PersistenceException {
        if (this.mergeMode.create) {
            if (!this.dryRunMode) {
                this.createMissingNode(path, rr, row);
            }
            this.incrementCount(this.createdNodes, 1);
            if (this.detailedReport) {
                this.trackActivity(path, "Created", null);
            }
        } else {
            this.incrementCount(this.skippedNodes, 1);
            if (this.detailedReport) {
                this.trackActivity(path, "Skipped missing", null);
            }
        }
    }

    public void createMissingNode(String path, ResourceResolver rr, Map<String, CompositeVariant> row) throws PersistenceException {
        String parentPath = StringUtils.substringBeforeLast((String)path, (String)"/");
        Resource parent = ResourceUtil.getOrCreateResource((ResourceResolver)rr, (String)parentPath, (String)this.defaultNodeType, (String)this.defaultNodeType, (boolean)true);
        String nodeName = StringUtils.substringAfterLast((String)path, (String)"/");
        if (!row.containsKey("{http://www.jcp.org/jcr/1.0}primaryType")) {
            row.put("JCR_TYPE", new CompositeVariant<String>(this.defaultNodeType));
        }
        HashMap<String, CompositeVariant> nodeProps = new HashMap<String, CompositeVariant>(row);
        rr.refresh();
        rr.create(parent, nodeName, nodeProps);
    }

    private void updateMetadata(ResourceResolver rr, Map<String, CompositeVariant> nodeInfo) throws PersistenceException {
        ModifiableValueMap resourceProperties = (ModifiableValueMap)rr.getResource(nodeInfo.get(PATH).toString()).adaptTo(ModifiableValueMap.class);
        this.populateMetadataFromRow(resourceProperties, nodeInfo);
        if (rr.hasChanges()) {
            this.incrementCount(this.updatedNodes, 1);
            if (this.detailedReport) {
                this.trackActivity(nodeInfo.get(PATH).toString(), "Updated Properties", null);
            }
            if (!this.dryRunMode) {
                rr.commit();
            }
            rr.refresh();
        } else {
            if (this.detailedReport) {
                this.trackActivity(nodeInfo.get(PATH).toString(), "No Change", null);
            }
            this.incrementCount(this.noChangeNodes, 1);
        }
    }

    public void populateMetadataFromRow(ModifiableValueMap resourceProperties, Map<String, CompositeVariant> nodeInfo) {
        for (String prop : this.data.getHeaderRow()) {
            if (prop.equals(PATH) || !this.mergeMode.overwriteProps && resourceProperties.containsKey((Object)prop)) continue;
            CompositeVariant value = nodeInfo.get(prop);
            if (value == null || value.isEmpty()) {
                nodeInfo.remove(prop);
                continue;
            }
            resourceProperties.put((Object)prop, value.toPropertyValue());
        }
    }

    public static enum ReportColumns {
        item,
        action,
        count;

    }

    public static enum MergeMode {
        CREATE_AND_OVERWRITE_PROPERTIES(true, true, true),
        CREATE_AND_MERGE_PROPERTIES(true, true, false),
        CREATE_ONLY_SKIP_EXISTING(true, false, false),
        OVERWRITE_EXISTING_ONLY(false, true, true),
        MERGE_EXISTING_ONLY(false, true, false),
        DO_NOTHING(false, false, false);

        boolean create = false;
        boolean update = false;
        boolean overwriteProps = false;

        private MergeMode(boolean c, boolean u, boolean o) {
            this.create = c;
            this.update = u;
            this.overwriteProps = o;
        }
    }
}

