/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.acs.commons.mcp.impl.processes;

import com.adobe.acs.commons.fam.ActionManager;
import com.adobe.acs.commons.fam.actions.Actions;
import com.adobe.acs.commons.mcp.ProcessDefinition;
import com.adobe.acs.commons.mcp.ProcessInstance;
import com.adobe.acs.commons.mcp.form.CheckboxComponent;
import com.adobe.acs.commons.mcp.form.FormField;
import com.adobe.acs.commons.mcp.form.PathfieldComponent;
import com.adobe.acs.commons.mcp.form.RadioComponent;
import com.adobe.acs.commons.mcp.form.TextfieldComponent;
import com.adobe.acs.commons.mcp.impl.processes.FolderRelocator;
import com.adobe.acs.commons.mcp.impl.processes.ReplicatorQueue;
import com.adobe.acs.commons.mcp.model.GenericReport;
import com.adobe.acs.commons.mcp.model.ManagedProcess;
import com.adobe.acs.commons.util.visitors.SimpleFilteringResourceVisitor;
import com.adobe.acs.commons.util.visitors.TreeFilteringResourceVisitor;
import com.day.cq.replication.ReplicationActionType;
import com.day.cq.replication.ReplicationException;
import com.day.cq.replication.ReplicationOptions;
import com.day.cq.replication.ReplicationStatus;
import com.day.cq.replication.Replicator;
import com.day.cq.wcm.api.PageManager;
import com.day.cq.wcm.api.PageManagerFactory;
import com.day.cq.wcm.commons.ReferenceSearch;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import javax.jcr.security.AccessControlManager;
import javax.jcr.security.Privilege;
import org.apache.commons.lang.reflect.FieldUtils;
import org.apache.sling.api.resource.LoginException;
import org.apache.sling.api.resource.PersistenceException;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.resource.ResourceResolver;

public class PageRelocator
extends ProcessDefinition {
    private final PageManagerFactory pageManagerFactory;
    private final Replicator replicator;
    @FormField(name="Source page", description="Select page/site to be moved", hint="/content/my-site/en/my-page", component=PathfieldComponent.PageSelectComponent.class, options={"base=/content"})
    private String sourcePath;
    @FormField(name="Destination", description="Destination parent for move, or destination parent folder plus new name for rename", hint="Move: /content/my-site/some-page | Rename: /content/my-site/some-page/new-name", component=PathfieldComponent.PageSelectComponent.class, options={"base=/content"})
    private String destinationPath;
    @FormField(name="Max References", description="Limit of how many page references to handle (max per page)", hint="-1 = All, 0 = None, etc.", component=TextfieldComponent.class, required=false, options={"default=-1"})
    private int maxReferences = -1;
    @FormField(name="Reference Search Root", description="Root for reference searches.  Depending on how indexes are set up, / might be the only working value on your system", hint="/ (all), /content, ...", component=TextfieldComponent.class, required=false, options={"default=/"})
    private String referenceSearchRoot = "/";
    @FormField(name="Mode", description="Move relocates the page keeping the original name.  Rename changes the name, optionally moving the page.", required=false, component=RadioComponent.EnumerationSelector.class, options={"horizontal", "default=MOVE"})
    private Mode mode;
    @FormField(name="Publish", description="Self-managed handles publishing in-process where as Queue will add it to the system publish queue where progress is not tracked here.", required=false, component=RadioComponent.EnumerationSelector.class, options={"horizontal", "default=SELF_MANAGED"})
    public PublishMethod publishMethod;
    @FormField(name="Create versions", description="Create versions for anything being replicated", component=CheckboxComponent.class, options={"checked"})
    private boolean createVerionsOnReplicate;
    @FormField(name="Update status", description="Updates status of content affected by this operation", component=CheckboxComponent.class, options={"checked"})
    private boolean updateStatus;
    @FormField(name="Extensive ACL checks", description="If checked, this evaluates ALL nodes.  If not checked, it only evaluates pages.", component=CheckboxComponent.class)
    private boolean extensiveACLChecks = false;
    @FormField(name="Dry run", description="This runs the ACL checks but doesn't do any actual work.", component=CheckboxComponent.class, options={"checked"})
    private boolean dryRun = true;
    private final transient String[] requiredPrivilegeNames = new String[]{"{http://www.jcp.org/jcr/1.0}read", "{http://www.jcp.org/jcr/1.0}write", "{http://www.jcp.org/jcr/1.0}removeChildNodes", "{http://www.jcp.org/jcr/1.0}removeNode", "{http://www.day.com/crx/1.0}replicate"};
    Privilege[] requiredPrivileges;
    ReplicatorQueue replicatorQueue = new ReplicatorQueue();
    ReplicationOptions replicationOptions;
    ManagedProcess instanceInfo;
    private final Map<String, EnumMap<Report, Object>> reportData = new TreeMap<String, EnumMap<Report, Object>>();

    public PageRelocator(PageManagerFactory pageManagerFactory, Replicator replicator) {
        this.pageManagerFactory = pageManagerFactory;
        this.replicator = replicator;
    }

    @Override
    public void init() throws RepositoryException {
        if (this.mode == Mode.MOVE) {
            String nodeName = this.sourcePath.substring(this.sourcePath.lastIndexOf(47));
            this.destinationPath = this.destinationPath + nodeName;
        }
        this.replicationOptions = new ReplicationOptions();
        switch (this.publishMethod) {
            case SELF_MANAGED: {
                this.replicationOptions.setSynchronous(true);
                break;
            }
            default: {
                this.replicationOptions.setSynchronous(false);
            }
        }
        this.replicationOptions.setSuppressVersions(!this.createVerionsOnReplicate);
        this.replicationOptions.setSuppressStatusUpdate(!this.updateStatus);
        if (this.referenceSearchRoot == null || this.referenceSearchRoot.trim().isEmpty()) {
            this.referenceSearchRoot = "/";
        }
    }

    private void validateInputs(ResourceResolver res) throws RepositoryException {
        if (this.sourcePath == null) {
            throw new RepositoryException("Source path should not be null");
        }
        if (this.destinationPath == null) {
            throw new RepositoryException("Destination path should not be null");
        }
        if (this.destinationPath.contains(this.sourcePath + "/")) {
            throw new RepositoryException("Destination must be outside of source path");
        }
        if (!this.resourceExists(res, this.sourcePath)) {
            if (!this.sourcePath.startsWith("/")) {
                throw new RepositoryException("Paths are not valid unless they start with a forward slash, you provided: " + this.sourcePath);
            }
            throw new RepositoryException("Unable to find source " + this.sourcePath);
        }
        if (!this.resourceExists(res, this.destinationPath.substring(0, this.destinationPath.lastIndexOf(47)))) {
            if (!this.destinationPath.startsWith("/")) {
                throw new RepositoryException("Paths are not valid unless they start with a forward slash, you provided: " + this.destinationPath);
            }
            throw new RepositoryException("Unable to find destination " + this.destinationPath);
        }
    }

    @Override
    public void buildProcess(ProcessInstance instance, ResourceResolver rr) throws LoginException, RepositoryException {
        this.validateInputs(rr);
        this.instanceInfo = instance.getInfo();
        String desc = this.dryRun ? "DRY RUN: " : "";
        desc = desc + this.mode.name().toLowerCase() + " " + this.sourcePath + " to " + this.destinationPath;
        desc = desc + "; Publish mode " + this.publishMethod.name().toLowerCase();
        instance.getInfo().setDescription(desc);
        this.requiredPrivileges = this.getPrivilegesFromNames(rr, this.requiredPrivilegeNames);
        instance.defineCriticalAction("Check ACLs", rr, this::validateAllAcls);
        instance.defineAction("Move Pages", rr, this::movePages);
        if (this.publishMethod != PublishMethod.NONE) {
            instance.defineAction("Activate New", rr, this::activateNew);
            instance.defineAction("Activate References", rr, this::activateReferences);
            instance.defineAction("Deactivate Old", rr, this::deactivateOld);
        }
        instance.defineAction("Remove old pages", rr, this::removeSource);
    }

    protected void validateAllAcls(ActionManager step1) {
        SimpleFilteringResourceVisitor pageVisitor;
        if (this.extensiveACLChecks) {
            pageVisitor = new SimpleFilteringResourceVisitor();
            pageVisitor.setLeafVisitor((resource, level) -> step1.deferredWithResolver(rr -> this.checkNodeAcls((ResourceResolver)rr, resource.getPath(), this.requiredPrivileges)));
        } else {
            pageVisitor = new TreeFilteringResourceVisitor("cq:Page");
        }
        pageVisitor.setBreadthFirstMode();
        pageVisitor.setResourceVisitor((resource, level) -> step1.deferredWithResolver(rr -> this.checkNodeAcls((ResourceResolver)rr, resource.getPath(), this.requiredPrivileges)));
        this.beginStep(step1, this.sourcePath, pageVisitor);
    }

    protected void movePages(ActionManager step2) {
        TreeFilteringResourceVisitor pageVisitor = new TreeFilteringResourceVisitor("cq:Page");
        pageVisitor.setBreadthFirstMode();
        pageVisitor.setResourceVisitor((resource, level) -> step2.deferredWithResolver(rr -> this.movePage((ResourceResolver)rr, resource.getPath())));
        this.beginStep(step2, this.sourcePath, pageVisitor);
    }

    protected void activateNew(ActionManager step3) {
        step3.deferredWithResolver(rr -> this.getAllReplicationPaths().filter(p -> p.startsWith(this.destinationPath) && !p.startsWith(this.sourcePath)).forEach(path -> step3.deferredWithResolver(rr2 -> this.performNecessaryReplication((ResourceResolver)rr2, (String)path))));
    }

    protected void activateReferences(ActionManager step4) {
        step4.deferredWithResolver(rr -> this.getAllReplicationPaths().filter(p -> !p.startsWith(this.destinationPath) && !p.startsWith(this.sourcePath)).forEach(path -> step4.deferredWithResolver(rr2 -> this.performNecessaryReplication((ResourceResolver)rr2, (String)path))));
    }

    protected void deactivateOld(ActionManager step5) {
        step5.deferredWithResolver(rr -> this.getAllReplicationPaths().filter(p -> p.startsWith(this.sourcePath)).forEach(path -> step5.deferredWithResolver(rr2 -> this.performNecessaryReplication((ResourceResolver)rr2, (String)path))));
    }

    protected void removeSource(ActionManager step6) {
        if (this.instanceInfo.getReportedErrorsList().isEmpty() && !this.dryRun) {
            step6.deferredWithResolver(rr -> rr.delete(rr.getResource(this.sourcePath)));
        }
    }

    private void beginStep(ActionManager step, String startingNode, SimpleFilteringResourceVisitor visitor) {
        try {
            step.withResolver(rr -> visitor.accept(rr.getResource(startingNode)));
        }
        catch (Exception ex) {
            Logger.getLogger(FolderRelocator.class.getName()).log(Level.SEVERE, null, ex);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void note(String page, Report col, Object value) {
        Map<String, EnumMap<Report, Object>> map = this.reportData;
        synchronized (map) {
            if (!this.reportData.containsKey(page)) {
                this.reportData.put(page, new EnumMap(Report.class));
            }
            this.reportData.get(page).put(col, value);
        }
    }

    @Override
    public void storeReport(ProcessInstance instance, ResourceResolver rr) throws RepositoryException, PersistenceException {
        GenericReport report = new GenericReport();
        report.setRows(this.reportData, "Source", Report.class);
        report.persist(rr, instance.getPath() + "/jcr:content/report");
    }

    private boolean resourceExists(ResourceResolver rr, String path) {
        Resource res = rr.getResource(path);
        return res != null && !"sling:nonexisting".equals(res.getResourceType());
    }

    private void waitUntilResourceFound(ResourceResolver rr, String path) throws InterruptedException, RepositoryException {
        for (int i = 0; i < 10; ++i) {
            if (this.resourceExists(rr, path)) {
                return;
            }
            Thread.sleep(100L);
            rr.refresh();
        }
        throw new RepositoryException("Resource not found: " + path);
    }

    private Privilege[] getPrivilegesFromNames(ResourceResolver res, String[] names) throws RepositoryException {
        Session session = (Session)res.adaptTo(Session.class);
        AccessControlManager acm = session.getAccessControlManager();
        Privilege[] prvlgs = new Privilege[names.length];
        for (int i = 0; i < names.length; ++i) {
            prvlgs[i] = acm.privilegeFromName(names[i]);
        }
        return prvlgs;
    }

    private void checkNodeAcls(ResourceResolver res, String path, Privilege[] prvlgs) throws RepositoryException {
        Actions.setCurrentItem(path);
        Session session = (Session)res.adaptTo(Session.class);
        boolean report = res.getResource(path).getResourceType().equals("cq:Page");
        if (!session.getAccessControlManager().hasPrivileges(path, prvlgs)) {
            this.note(path, Report.acl_check, "FAIL");
            throw new RepositoryException("Insufficient permissions to permit move operation");
        }
        if (report) {
            this.note(path, Report.acl_check, "PASS");
        }
    }

    private void movePage(ResourceResolver rr, String sourcePage) throws Exception {
        PageManager manager = this.pageManagerFactory.getPageManager(rr);
        Field replicatorField = FieldUtils.getDeclaredField(manager.getClass(), (String)"replicator", (boolean)true);
        FieldUtils.writeField((Field)replicatorField, (Object)manager, (Object)this.replicatorQueue);
        String destination = this.convertSourceToDestination(sourcePage);
        String destinationParent = destination.substring(0, destination.lastIndexOf(47));
        this.note(sourcePage, Report.target, destination);
        String beforeName = "";
        long start = System.currentTimeMillis();
        String contentPath = sourcePage + "/jcr:content";
        ArrayList refs = new ArrayList();
        ArrayList publishRefs = new ArrayList();
        if (this.maxReferences != 0 && this.resourceExists(rr, contentPath)) {
            ReferenceSearch refSearch = new ReferenceSearch();
            refSearch.setExact(true);
            refSearch.setHollow(true);
            refSearch.setMaxReferencesPerPage(this.maxReferences);
            refSearch.setSearchRoot(this.referenceSearchRoot);
            refSearch.search(rr, this.sourcePath).values().stream().peek(p -> refs.add(p.getPagePath())).filter(p -> this.isActivated(rr, p.getPagePath())).map(ReferenceSearch.Info::getPagePath).collect(Collectors.toCollection(() -> publishRefs));
        }
        this.note(sourcePage, Report.all_references, refs.size());
        this.note(sourcePage, Report.published_references, publishRefs.size());
        if (!this.dryRun) {
            Actions.retry(10, 500L, res -> {
                this.waitUntilResourceFound((ResourceResolver)res, destinationParent);
                Resource source = rr.getResource(sourcePage);
                if (this.resourceExists((ResourceResolver)res, contentPath)) {
                    manager.move(source, destination, beforeName, true, true, this.listToStringArray(refs), this.listToStringArray(publishRefs));
                } else {
                    HashMap props = new HashMap();
                    Resource parent = res.getResource(destinationParent);
                    res.create(parent, source.getName(), (Map)source.getValueMap());
                }
                res.commit();
                res.refresh();
                source = rr.getResource(sourcePage);
                if (source != null && source.hasChildren()) {
                    for (Resource child : source.getChildren()) {
                        res.move(child.getPath(), destination);
                    }
                    res.commit();
                }
            }).accept(rr);
        }
        long end = System.currentTimeMillis();
        this.note(sourcePage, Report.move_time, end - start);
    }

    private String convertSourceToDestination(String path) {
        return path.replaceAll(Pattern.quote(this.sourcePath), this.destinationPath);
    }

    private String reversePathLookup(String path) {
        if (path.startsWith(this.destinationPath)) {
            return path.replaceAll(Pattern.quote(this.destinationPath), this.sourcePath);
        }
        return path;
    }

    private Stream<String> getAllReplicationPaths() {
        Stream s1 = this.replicatorQueue.activateOperations.keySet().stream();
        Stream s2 = this.replicatorQueue.deactivateOperations.keySet().stream();
        return Stream.concat(s1, s2);
    }

    private void performNecessaryReplication(ResourceResolver rr, String path) throws ReplicationException {
        ReplicationActionType action = path.startsWith(this.sourcePath) ? ReplicationActionType.DEACTIVATE : ReplicationActionType.ACTIVATE;
        long start = System.currentTimeMillis();
        if (!this.dryRun) {
            this.replicator.replicate((Session)rr.adaptTo(Session.class), action, path);
        }
        long end = System.currentTimeMillis();
        if (path.startsWith(this.sourcePath)) {
            this.note(path, Report.deactivate_time, end - start);
        } else {
            this.note(this.reversePathLookup(path), Report.activate_time, end - start);
        }
    }

    private boolean isActivated(ResourceResolver rr, String path) {
        ReplicationStatus replicationStatus = (ReplicationStatus)rr.getResource(path).adaptTo(ReplicationStatus.class);
        return replicationStatus.isActivated();
    }

    private String[] listToStringArray(List<String> values) {
        return values.toArray(new String[0]);
    }

    static enum Report {
        target,
        acl_check,
        all_references,
        published_references,
        move_time,
        activate_time,
        deactivate_time;

    }

    public static enum PublishMethod {
        NONE,
        SELF_MANAGED,
        QUEUE;

    }

    public static enum Mode {
        RENAME,
        MOVE;

    }
}

