/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.acs.commons.mcp.impl.processes.asset;

import com.adobe.acs.commons.fam.ActionManager;
import com.adobe.acs.commons.functions.CheckedConsumer;
import com.adobe.acs.commons.mcp.ProcessDefinition;
import com.adobe.acs.commons.mcp.ProcessInstance;
import com.adobe.acs.commons.mcp.form.CheckboxComponent;
import com.adobe.acs.commons.mcp.form.FormField;
import com.adobe.acs.commons.mcp.form.PathfieldComponent;
import com.adobe.acs.commons.mcp.form.RadioComponent;
import com.adobe.acs.commons.mcp.model.GenericReport;
import com.day.cq.commons.jcr.JcrUtil;
import com.day.cq.dam.api.Asset;
import com.day.cq.dam.api.AssetManager;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.EnumMap;
import java.util.List;
import javax.jcr.Node;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import org.apache.commons.lang3.StringUtils;
import org.apache.sling.api.resource.PersistenceException;
import org.apache.sling.api.resource.ResourceResolver;
import org.apache.sling.commons.mime.MimeTypeService;

public abstract class AssetIngestor
extends ProcessDefinition {
    public static final String ALL_ASSETS = "All Assets";
    static final String[] AUTHORIZED_GROUPS = new String[]{"administrators", "asset-ingest", "dam-administrators"};
    protected final transient MimeTypeService mimetypeService;
    @FormField(name="Dry run", description="If checked, no import happens.  Useful for data validation", component=CheckboxComponent.class)
    boolean dryRunMode = false;
    @FormField(name="Detailed report", description="If checked, information about every asset is recorded", component=CheckboxComponent.class, options={"checked"})
    boolean detailedReport = true;
    @FormField(name="Inhibit workflow", description="If checked, disables asset processing workflow", component=CheckboxComponent.class, options={"checked"})
    boolean inhibitWorkflow = true;
    @FormField(name="Preserve Filename", description="If checked, file name is preserved as asset name.  If unchecked, asset name is converted to a JCR-friendly name.", component=CheckboxComponent.class, options={"checked"})
    boolean preserveFileName = true;
    @FormField(name="Target JCR Folder", description="Prepended to target path if it does not begin with /content", hint="/content/dam", component=PathfieldComponent.FolderSelectComponent.class, required=true, options={"default=/content/dam", "base=/content/dam"})
    String jcrBasePath = "/content/dam";
    @FormField(name="Ignore folders", description="List of folder names to be ignored", hint="tmp,.DS_STORE", options={"default=tmp,ds_store,.ds_store,.thumbs,.appledouble"})
    String ignoreFolders = "tmp,ds_store,.ds_store,.thumbs,.appledouble";
    List<String> ignoreFolderList;
    @FormField(name="Ignore files", description="List of file names to ignore", hint="full file names, comma separated", options={"default=ds_store,.ds_store"})
    String ignoreFiles = "ds_store,.ds_store";
    List<String> ignoreFileList;
    @FormField(name="Ignore extensions", description="List of file extensions to ignore", hint="mp4,txt, etc.", options={"default=txt,html,css,js,thm,exe,db"})
    String ignoreExtensions = "txt,html,css,js,thm,exe,db";
    List<String> ignoreExtensionList;
    @FormField(name="Existing action", description="What to do if an asset exists", component=RadioComponent.EnumerationSelector.class, options={"default=skip", "vertical"})
    protected transient AssetAction existingAssetAction = AssetAction.skip;
    @FormField(name="Minimum size", description="Min size to import (in bytes), 0=none", hint="1024...", options={"default=1024"})
    private transient long minimumSize = 1024L;
    @FormField(name="Maximum size", description="Max size to import (in bytes), 0=none", hint="1gb = 1073741824", options={"default=1073741824"})
    private transient long maximumSize = 0x40000000L;
    protected static final String DEFAULT_FOLDER_TYPE = "sling:Folder";
    protected static final String CHANGED_BY_WORKFLOW = "changedByWorkflowProcess";
    EnumMap<ReportColumns, Object> createdFolders = this.trackActivity("All folders", "Create", "Count of all folders created", 0L);
    EnumMap<ReportColumns, Object> importedAssets = this.trackActivity("All Assets", "Import", "Count of all assets imports", 0L);
    EnumMap<ReportColumns, Object> skippedFiles = this.trackActivity("All Assets", "Skipped", "Count of skipped files", 0L);
    EnumMap<ReportColumns, Object> importedData = this.trackActivity("All Assets", "Data imported", "Count of bytes imported", 0L);
    List<EnumMap<ReportColumns, Object>> reportRows;
    private transient GenericReport report = new GenericReport();

    public AssetIngestor(MimeTypeService mimeTypeService) {
        this.mimetypeService = mimeTypeService;
    }

    private synchronized EnumMap<ReportColumns, Object> trackActivity(String item, String action, String description, Long bytes) {
        if (this.reportRows == null) {
            this.reportRows = Collections.synchronizedList(new ArrayList());
        }
        EnumMap<ReportColumns, Object> reportRow = new EnumMap<ReportColumns, Object>(ReportColumns.class);
        reportRow.put(ReportColumns.item, item);
        reportRow.put(ReportColumns.action, action);
        reportRow.put(ReportColumns.description, description);
        reportRow.put(ReportColumns.count, Long.valueOf(0L));
        reportRow.put(ReportColumns.bytes, bytes);
        this.reportRows.add(reportRow);
        return reportRow;
    }

    protected synchronized EnumMap<ReportColumns, Object> trackDetailedActivity(String item, String action, String description, Long bytes) {
        if (this.detailedReport) {
            return this.trackActivity(item, action, description, bytes);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void increment(EnumMap<ReportColumns, Object> row, ReportColumns col, long amt) {
        if (row != null) {
            EnumMap<ReportColumns, Object> enumMap = row;
            synchronized (enumMap) {
                row.put(col, (Object)((Long)row.getOrDefault((Object)col, 0) + amt));
            }
        }
    }

    protected void incrementCount(EnumMap<ReportColumns, Object> row, long amt) {
        this.increment(row, ReportColumns.count, amt);
    }

    protected void incrementBytes(EnumMap<ReportColumns, Object> row, long amt) {
        this.increment(row, ReportColumns.bytes, amt);
    }

    protected long getCount(EnumMap<ReportColumns, Object> row) {
        return (Long)row.getOrDefault((Object)ReportColumns.count, 0);
    }

    @Override
    public void init() throws RepositoryException {
        if (this.ignoreFolders == null) {
            this.ignoreFolders = "";
        }
        this.ignoreFolderList = Arrays.asList(this.ignoreFolders.trim().toLowerCase().split(","));
        if (this.ignoreFiles == null) {
            this.ignoreFiles = "";
        }
        this.ignoreFileList = Arrays.asList(this.ignoreFiles.trim().toLowerCase().split(","));
        if (this.ignoreExtensions == null) {
            this.ignoreExtensions = "";
        }
        this.ignoreExtensionList = Arrays.asList(this.ignoreExtensions.trim().toLowerCase().split(","));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void createAsset(Source source, String assetPath, ResourceResolver r, boolean versioning) throws Exception {
        try {
            boolean versioned = false;
            if (!this.dryRunMode) {
                this.disableWorkflowProcessing(r);
                AssetManager assetManager = (AssetManager)r.adaptTo(AssetManager.class);
                String type = this.mimetypeService.getMimeType(source.getName());
                if (versioning) {
                    Asset asset = (Asset)r.getResource(assetPath).adaptTo(Asset.class);
                    versioned = asset != null;
                    assetManager.createRevision(asset, "initial version of asset", asset.getName());
                    r.commit();
                    r.refresh();
                }
                assetManager.createAsset(assetPath, source.getStream(), type, false);
                r.commit();
                r.refresh();
            }
            if (versioned) {
                this.trackDetailedActivity(assetPath, "Revised", "Created new version of asset", source.getLength());
            } else {
                this.trackDetailedActivity(assetPath, "Create", "Imported asset", source.getLength());
            }
            this.incrementBytes(this.importedData, source.getLength());
            this.incrementCount(this.importedAssets, 1L);
        }
        finally {
            source.close();
        }
    }

    protected void handleExistingAsset(Source source, String assetPath, ResourceResolver r) throws Exception {
        switch (this.existingAssetAction) {
            case skip: {
                if (r.getResource(assetPath) == null) {
                    this.createAsset(source, assetPath, r, false);
                    break;
                }
                this.incrementCount(this.skippedFiles, 1L);
                this.trackDetailedActivity(assetPath, "Skip", "Skipped existing asset", 0L);
                break;
            }
            case replace: {
                this.createAsset(source, assetPath, r, false);
                break;
            }
            default: {
                this.versionExistingAsset(source, assetPath, r);
            }
        }
    }

    protected boolean createFolderNode(HierarchialElement el, ResourceResolver r) throws RepositoryException, PersistenceException {
        if (el == null || !el.isFolder()) {
            return false;
        }
        if (this.dryRunMode) {
            return true;
        }
        String folderPath = el.getNodePath();
        String name = el.getName();
        Session s = (Session)r.adaptTo(Session.class);
        if (s.nodeExists(folderPath)) {
            Node folderContentNode;
            Node folderNode = s.getNode(folderPath);
            Node node = folderContentNode = folderNode.hasNode("jcr:content") ? folderNode.getNode("jcr:content") : null;
            if (folderNode.getPath().equals(this.jcrBasePath) || null != folderContentNode && folderContentNode.hasProperty("jcr:title") && folderContentNode.getProperty("jcr:title").getString().equals(name)) {
                return false;
            }
            if (folderContentNode == null) {
                folderContentNode = folderNode.addNode("jcr:content", "nt:unstructured");
            }
            folderContentNode.setProperty("jcr:title", name);
            r.commit();
            r.refresh();
            return true;
        }
        HierarchialElement parent = el.getParent();
        String parentPath = parent == null ? this.jcrBasePath : parent.getNodePath();
        if (!this.jcrBasePath.equals(parentPath)) {
            this.createFolderNode(parent, r);
        }
        Node child = s.getNode(parentPath).addNode(el.getNodeName(), DEFAULT_FOLDER_TYPE);
        this.trackDetailedActivity(el.getNodePath(), "Create Folder", "Create folder", 0L);
        this.setFolderTitle(child, folderPath, name);
        this.incrementCount(this.createdFolders, 1L);
        r.commit();
        r.refresh();
        return true;
    }

    private void setFolderTitle(Node child, String folderPath, String title) throws RepositoryException {
        if (!folderPath.equals(this.jcrBasePath)) {
            if (child.hasNode("jcr:content")) {
                child.getNode("jcr:content").setProperty("jcr:title", title);
            } else {
                child.addNode("jcr:content", "nt:unstructured").setProperty("jcr:title", title);
            }
        }
    }

    private void versionExistingAsset(Source source, String assetPath, ResourceResolver r) throws Exception {
        this.createAsset(source, assetPath, r, r.getResource(assetPath) != null);
    }

    protected CheckedConsumer<ResourceResolver> importAsset(Source source, ActionManager actionManager) {
        return r -> {
            this.createFolderNode(source.getElement().getParent(), (ResourceResolver)r);
            actionManager.setCurrentItem(source.getElement().getItemName());
            HierarchialElement el = source.getElement();
            String path = source.getElement().getNodePath();
            if (null != el && el.isFile() && el.getName().contains(".") && !this.preserveFileName) {
                String baseName = StringUtils.substringBeforeLast((String)el.getName(), (String)".");
                String extension = StringUtils.substringAfterLast((String)el.getName(), (String)".");
                path = (el.getParent() == null ? el.getJcrBasePath() : el.getParent().getNodePath()) + "/" + JcrUtil.createValidName((String)baseName, (String[])JcrUtil.HYPHEN_LABEL_CHAR_MAPPING, (String)"-") + "." + JcrUtil.createValidName((String)extension, (String[])JcrUtil.HYPHEN_LABEL_CHAR_MAPPING, (String)"-");
            }
            this.handleExistingAsset(source, path, (ResourceResolver)r);
        };
    }

    protected boolean canImportFile(Source source) throws IOException {
        int extPos;
        String ext;
        String name = source.getName().toLowerCase();
        if (this.minimumSize > 0L && source.getLength() < this.minimumSize) {
            return false;
        }
        if (this.maximumSize > 0L && source.getLength() > this.maximumSize) {
            return false;
        }
        if (name.startsWith(".") || this.ignoreFileList.contains(name)) {
            return false;
        }
        return !name.contains(".") || !this.ignoreExtensionList.contains(ext = name.substring((extPos = name.lastIndexOf(46)) + 1));
    }

    protected boolean canImportFolder(HierarchialElement element) {
        String name = element.getName();
        if (this.ignoreFolderList.contains(name.toLowerCase())) {
            return false;
        }
        HierarchialElement parent = element.getParent();
        if (parent == null) {
            return true;
        }
        return this.canImportFolder(parent);
    }

    protected boolean canImportContainingFolder(HierarchialElement element) {
        HierarchialElement parent = element.getParent();
        if (parent == null) {
            return true;
        }
        return this.canImportFolder(parent);
    }

    protected void disableWorkflowProcessing(ResourceResolver rr) throws RepositoryException {
        if (this.inhibitWorkflow) {
            ((Session)rr.adaptTo(Session.class)).getWorkspace().getObservationManager().setUserData(CHANGED_BY_WORKFLOW);
        }
    }

    @Override
    public void storeReport(ProcessInstance instance, ResourceResolver rr) throws RepositoryException, PersistenceException {
        this.report.setRows(this.reportRows, ReportColumns.class);
        this.report.persist(rr, instance.getPath() + "/jcr:content/report");
    }

    protected static interface HierarchialElement {
        public boolean isFile();

        public boolean isFolder();

        public HierarchialElement getParent();

        public String getName();

        public String getItemName();

        public Source getSource();

        public String getJcrBasePath();

        default public String getNodePath() {
            HierarchialElement parent = this.getParent();
            return (parent == null ? this.getJcrBasePath() : parent.getNodePath()) + "/" + this.getNodeName();
        }

        default public String getNodeName() {
            String name = this.getName();
            if (this.isFile() && name.contains(".")) {
                return name;
            }
            if (JcrUtil.isValidName((String)name)) {
                return name;
            }
            return JcrUtil.createValidName((String)name, (String[])JcrUtil.HYPHEN_LABEL_CHAR_MAPPING, (String)"-");
        }
    }

    protected static interface Source {
        public String getName();

        public InputStream getStream() throws IOException;

        public long getLength() throws IOException;

        public HierarchialElement getElement();

        public void close() throws IOException;
    }

    public static enum ReportColumns {
        item,
        action,
        description,
        count,
        bytes;

    }

    public static enum AssetAction {
        skip,
        version,
        replace;

    }
}

