/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.acs.commons.mcp.impl.processes.asset;

import com.adobe.acs.commons.fam.ActionManager;
import com.adobe.acs.commons.fam.Failure;
import com.adobe.acs.commons.fam.actions.Actions;
import com.adobe.acs.commons.mcp.ProcessInstance;
import com.adobe.acs.commons.mcp.form.FormField;
import com.adobe.acs.commons.mcp.impl.processes.asset.AssetIngestor;
import com.day.cq.commons.jcr.JcrUtil;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.Path;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import org.apache.sling.api.resource.LoginException;
import org.apache.sling.api.resource.ResourceResolver;
import org.apache.sling.commons.mime.MimeTypeService;

public class FileAssetIngestor
extends AssetIngestor {
    @FormField(name="Source", description="Source folder for content ingestion", hint="/var/mycontent, /tmp, /mnt/all_the_things, ...", required=true)
    String fileBasePath;
    File baseFolder;

    public FileAssetIngestor(MimeTypeService mimeTypeService) {
        super(mimeTypeService);
    }

    @Override
    public void init() throws RepositoryException {
        this.baseFolder = new File(this.fileBasePath);
        if (!this.baseFolder.exists()) {
            throw new RepositoryException("Source folder does not exist!");
        }
        super.init();
    }

    @Override
    public void buildProcess(ProcessInstance instance, ResourceResolver rr) throws LoginException, RepositoryException {
        instance.getInfo().setDescription(this.fileBasePath + "->" + this.jcrBasePath);
        instance.defineCriticalAction("Create Folders", rr, this::createFolders);
        instance.defineCriticalAction("Import Assets", rr, this::importAssets);
    }

    void createFolders(ActionManager manager) throws IOException {
        manager.deferredWithResolver(r -> {
            JcrUtil.createPath((String)this.jcrBasePath, (String)"sling:Folder", (String)"sling:Folder", (Session)((Session)r.adaptTo(Session.class)), (boolean)true);
            manager.setCurrentItem(this.fileBasePath);
            Files.walk(this.baseFolder.toPath(), new FileVisitOption[0]).map(Path::toFile).filter(f -> !f.equals(this.baseFolder)).map(x$0 -> new FileHierarchialElement((File)x$0)).filter(FileHierarchialElement::isFolder).filter(this::canImportFolder).forEach(f -> manager.deferredWithResolver(Actions.retry(10, 100L, rr -> {
                manager.setCurrentItem(f.getItemName());
                this.createFolderNode((AssetIngestor.HierarchialElement)f, (ResourceResolver)rr);
            })));
        });
    }

    void importAssets(ActionManager manager) throws IOException {
        manager.deferredWithResolver(rr -> {
            JcrUtil.createPath((String)this.jcrBasePath, (String)"sling:Folder", (String)"sling:Folder", (Session)((Session)rr.adaptTo(Session.class)), (boolean)true);
            manager.setCurrentItem(this.fileBasePath);
            Files.walk(this.baseFolder.toPath(), new FileVisitOption[0]).map(x$0 -> new FileHierarchialElement((Path)x$0)).filter(FileHierarchialElement::isFile).filter(this::canImportContainingFolder).map(FileHierarchialElement::getSource).forEach(fs -> {
                Failure failure;
                try {
                    if (this.canImportFile((AssetIngestor.Source)fs)) {
                        manager.deferredWithResolver(Actions.retry(5, 25L, this.importAsset((AssetIngestor.Source)fs, manager)));
                    } else {
                        this.incrementCount(this.skippedFiles, 1L);
                        this.trackDetailedActivity(fs.getName(), "Skip", "Skipping file", 0L);
                    }
                }
                catch (IOException ex) {
                    failure = new Failure();
                    failure.setException(ex);
                    failure.setNodePath(fs.getElement().getNodePath());
                    manager.getFailureList().add(failure);
                }
                finally {
                    try {
                        fs.close();
                    }
                    catch (IOException ex) {
                        failure = new Failure();
                        failure.setException(ex);
                        failure.setNodePath(fs.getElement().getNodePath());
                        manager.getFailureList().add(failure);
                    }
                }
            });
        });
    }

    class FileHierarchialElement
    implements AssetIngestor.HierarchialElement {
        private final File file;

        FileHierarchialElement(File f) {
            this.file = f;
        }

        private FileHierarchialElement(Path p) {
            this(p.toFile());
        }

        @Override
        public AssetIngestor.Source getSource() {
            return new FileSource(this.file, this);
        }

        @Override
        public String getItemName() {
            return this.file.getAbsolutePath();
        }

        @Override
        public String getName() {
            return this.file.getName();
        }

        @Override
        public AssetIngestor.HierarchialElement getParent() {
            File parent = this.file.getParentFile();
            if (parent.equals(FileAssetIngestor.this.baseFolder)) {
                return null;
            }
            return new FileHierarchialElement(this.file.getParentFile());
        }

        @Override
        public boolean isFolder() {
            return this.file.isDirectory();
        }

        @Override
        public boolean isFile() {
            return this.file.isFile();
        }

        @Override
        public String getJcrBasePath() {
            return FileAssetIngestor.this.jcrBasePath;
        }
    }

    private class FileSource
    implements AssetIngestor.Source {
        private final File file;
        private final AssetIngestor.HierarchialElement element;
        private InputStream lastOpenStream;

        private FileSource(File f, FileHierarchialElement el) {
            this.file = f;
            this.element = el;
        }

        @Override
        public String getName() {
            return this.file.getName();
        }

        @Override
        public InputStream getStream() throws IOException {
            this.close();
            this.lastOpenStream = new FileInputStream(this.file);
            return this.lastOpenStream;
        }

        @Override
        public long getLength() {
            return this.file.length();
        }

        @Override
        public AssetIngestor.HierarchialElement getElement() {
            return this.element;
        }

        @Override
        public void close() throws IOException {
            if (this.lastOpenStream != null) {
                this.lastOpenStream.close();
            }
            this.lastOpenStream = null;
        }
    }
}

