/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.acs.commons.mcp.impl.processes.asset;

import com.adobe.acs.commons.data.CompositeVariant;
import com.adobe.acs.commons.mcp.impl.processes.asset.AssetIngestor;
import com.adobe.acs.commons.mcp.impl.processes.asset.Folder;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.net.URLConnection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.TreeMap;
import java.util.function.Supplier;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.http.HttpResponse;
import org.apache.http.client.HttpClient;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpUriRequest;

public class FileOrRendition
implements AssetIngestor.HierarchialElement {
    private final String url;
    private final String name;
    private final Folder folder;
    private AssetIngestor.Source fileSource;
    private final Map<String, FileOrRendition> additionalRenditions;
    private String renditionName = null;
    private String originalAssetName = null;
    private Map<String, CompositeVariant> properties;
    private Supplier<HttpClient> clientProvider;

    public FileOrRendition(Supplier<HttpClient> clientProvider, String name, String url, Folder folder, Map<String, CompositeVariant> data) {
        if (folder == null) {
            throw new NullPointerException("Folder cannot be null");
        }
        this.name = name;
        this.url = url;
        this.folder = folder;
        this.properties = new HashMap<String, CompositeVariant>(data);
        this.clientProvider = clientProvider;
        this.additionalRenditions = new TreeMap<String, FileOrRendition>();
    }

    public void setAsRenditionOfImage(String renditonName, String originalAssetName) {
        this.renditionName = renditonName;
        this.originalAssetName = originalAssetName;
    }

    @Override
    public boolean isFile() {
        return true;
    }

    @Override
    public boolean isFolder() {
        return false;
    }

    public boolean isRendition() {
        return this.renditionName != null && !this.renditionName.isEmpty();
    }

    public void addRendition(FileOrRendition rendition) {
        this.additionalRenditions.put(rendition.renditionName, rendition);
    }

    public Map<String, FileOrRendition> getRenditions() {
        return this.additionalRenditions;
    }

    public String getOriginalAssetName() {
        return this.originalAssetName;
    }

    @Override
    public AssetIngestor.HierarchialElement getParent() {
        return this.folder;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public String getItemName() {
        return this.getName();
    }

    @Override
    public AssetIngestor.Source getSource() {
        if (this.fileSource == null) {
            FileOrRendition thizz = this;
            this.fileSource = this.url.toLowerCase().startsWith("http") ? new HttpConnectionSource(thizz) : new UrlConnectionSource(thizz);
        }
        return this.fileSource;
    }

    @Override
    public String getJcrBasePath() {
        return this.folder.getJcrBasePath();
    }

    public String getUrl() {
        return this.url;
    }

    public Map<String, CompositeVariant> getProperties() {
        return Collections.unmodifiableMap(this.properties);
    }

    public CompositeVariant getProperty(String prop) {
        return this.properties.get(prop);
    }

    private class HttpConnectionSource
    implements AssetIngestor.Source {
        private final FileOrRendition thizz;
        private HttpGet lastRequest;
        private Long size = null;
        private HttpResponse connection = null;

        public HttpConnectionSource(FileOrRendition thizz) {
            this.thizz = thizz;
        }

        @Override
        public String getName() {
            return FileOrRendition.this.name;
        }

        private HttpResponse initiateDownload() throws IOException {
            if (this.connection == null) {
                try {
                    this.lastRequest = new HttpGet(FileOrRendition.this.url);
                    this.connection = ((HttpClient)FileOrRendition.this.clientProvider.get()).execute((HttpUriRequest)this.lastRequest);
                    this.size = this.connection.getEntity().getContentLength();
                }
                catch (IOException | IllegalArgumentException ex) {
                    Logger.getLogger(FileOrRendition.class.getName()).log(Level.SEVERE, null, ex);
                    this.size = -1L;
                    throw new IOException("Error with URL " + FileOrRendition.this.url + ": " + ex.getMessage(), ex);
                }
            }
            return this.connection;
        }

        @Override
        public InputStream getStream() throws IOException {
            HttpResponse c = this.initiateDownload();
            return c.getEntity().getContent();
        }

        @Override
        public long getLength() throws IOException {
            if (this.size == null) {
                this.initiateDownload();
            }
            return this.size;
        }

        @Override
        public AssetIngestor.HierarchialElement getElement() {
            return this.thizz;
        }

        @Override
        public void close() throws IOException {
            if (this.lastRequest != null) {
                this.lastRequest.releaseConnection();
                this.lastRequest = null;
            }
            if (this.connection != null && this.connection.getEntity() != null && this.connection.getEntity().getContent() != null) {
                this.connection.getEntity().getContent().close();
                this.connection = null;
            }
        }
    }

    private class UrlConnectionSource
    implements AssetIngestor.Source {
        private final FileOrRendition thizz;
        private Long size = null;
        private URLConnection connection = null;
        private InputStream lastOpenStream = null;

        public UrlConnectionSource(FileOrRendition thizz) {
            this.thizz = thizz;
        }

        @Override
        public String getName() {
            return FileOrRendition.this.name;
        }

        private URLConnection getConnection() throws IOException {
            if (this.connection == null) {
                URL theUrl = new URL(FileOrRendition.this.url);
                this.connection = theUrl.openConnection();
            }
            return this.connection;
        }

        @Override
        public InputStream getStream() throws IOException {
            this.close();
            URLConnection c = this.getConnection();
            this.connection = null;
            return c.getInputStream();
        }

        @Override
        public long getLength() throws IOException {
            if (this.size == null) {
                try {
                    this.size = this.getConnection().getContentLengthLong();
                }
                catch (IOException ex) {
                    Logger.getLogger(FileOrRendition.class.getName()).log(Level.SEVERE, null, ex);
                    this.size = -1L;
                    throw ex;
                }
            }
            return this.size;
        }

        @Override
        public AssetIngestor.HierarchialElement getElement() {
            return this.thizz;
        }

        @Override
        public void close() throws IOException {
            if (this.lastOpenStream != null) {
                this.lastOpenStream.close();
            }
            this.lastOpenStream = null;
        }
    }
}

