/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.acs.commons.mcp.model;

import com.adobe.acs.commons.mcp.model.FieldFormat;
import java.lang.reflect.Field;
import java.util.function.Function;

public enum ValueFormat {
    plain,
    storageSize("_short", ValueFormat::getHumanSize);

    int columnCount = 1;
    String suffix = "";
    Function<Object, Object> altFunction;

    private ValueFormat() {
    }

    private ValueFormat(String alternate, Function<Object, Object> altFunc) {
        this.columnCount = 2;
        this.suffix = alternate;
        this.altFunction = altFunc;
    }

    public static ValueFormat forField(Enum anEnum) {
        try {
            Field field = anEnum.getDeclaringClass().getField(anEnum.name());
            if (!field.isAnnotationPresent(FieldFormat.class)) {
                return plain;
            }
            FieldFormat rf = field.getAnnotation(FieldFormat.class);
            return rf.value();
        }
        catch (IllegalArgumentException | NoSuchFieldException | SecurityException exception) {
            return plain;
        }
    }

    public Object getAlternateValue(Object val) {
        return this.altFunction.apply(val);
    }

    public static String getHumanSize(Object val) {
        if (val == null) {
            return null;
        }
        Long bytes = val instanceof Long ? (Long)val : Long.parseLong(String.valueOf(val));
        if (bytes < 1024L) {
            return bytes + " b";
        }
        int exp = (int)(Math.log(bytes.longValue()) / Math.log(1024.0));
        char pre = "kmgtpe".charAt(exp - 1);
        return String.format("%.1f %cb", (double)bytes.longValue() / Math.pow(1024.0, exp), Character.valueOf(pre));
    }
}

