/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.acs.commons.oak.impl;

import com.adobe.acs.commons.analysis.jcrchecksum.ChecksumGenerator;
import com.adobe.acs.commons.oak.impl.AppliableEnsureOakIndex;
import com.adobe.acs.commons.oak.impl.EnsureOakIndexJobHandler;
import com.adobe.acs.commons.util.AemCapabilityHelper;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CopyOnWriteArrayList;
import javax.jcr.RepositoryException;
import org.apache.commons.lang.StringUtils;
import org.apache.felix.scr.annotations.Activate;
import org.apache.felix.scr.annotations.Component;
import org.apache.felix.scr.annotations.ConfigurationPolicy;
import org.apache.felix.scr.annotations.Properties;
import org.apache.felix.scr.annotations.Property;
import org.apache.felix.scr.annotations.Reference;
import org.apache.felix.scr.annotations.Service;
import org.apache.sling.api.resource.ResourceResolverFactory;
import org.apache.sling.commons.osgi.PropertiesUtil;
import org.apache.sling.commons.scheduler.ScheduleOptions;
import org.apache.sling.commons.scheduler.Scheduler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(label="ACS AEM Commons - Ensure Oak Index", description="Component Factory to manage Oak indexes.", configurationFactory=true, policy=ConfigurationPolicy.REQUIRE, metatype=true)
@Properties(value={@Property(name="webconsole.configurationFactory.nameHint", value={"Definitions: {ensure-definitions.path}, Indexes: {oak-indexes.path}"}, propertyPrivate=true)})
@Service
public class EnsureOakIndex
implements AppliableEnsureOakIndex {
    static final Logger log = LoggerFactory.getLogger(EnsureOakIndex.class);
    private static final String DEFAULT_ENSURE_DEFINITIONS_PATH = "";
    @Property(label="Ensure Definitions Path", description="The absolute path to the resource containing the ACS AEM Commons ensure definitions", value={""})
    public static final String PROP_ENSURE_DEFINITIONS_PATH = "ensure-definitions.path";
    private static final String DEFAULT_OAK_INDEXES_PATH = "/oak:index";
    @Property(label="Oak Indexes Path", description="The absolute path to the oak:index to update; Defaults to [ /oak:index ]", value={"/oak:index"})
    public static final String PROP_OAK_INDEXES_PATH = "oak-indexes.path";
    private static final boolean DEFAULT_IMMEDIATE = true;
    @Property(label="Immediate", description="Apply the indexes on startup of service. Defaults to [ true ]", boolValue={true})
    public static final String PROP_IMMEDIATE = "immediate";
    @Reference
    private AemCapabilityHelper capabilityHelper;
    @Reference
    private ChecksumGenerator checksumGenerator;
    @Reference
    private ResourceResolverFactory resourceResolverFactory;
    @Reference
    private Scheduler scheduler;
    private String ensureDefinitionsPath;
    private String oakIndexesPath;
    private boolean immediate = true;
    private boolean applied = false;
    private CopyOnWriteArrayList<String> ignoreProperties = new CopyOnWriteArrayList();

    @Activate
    protected final void activate(Map<String, Object> config) throws RepositoryException {
        if (!this.capabilityHelper.isOak()) {
            log.info("Cowardly refusing to create indexes on non-Oak instance.");
            return;
        }
        this.ensureDefinitionsPath = PropertiesUtil.toString((Object)config.get(PROP_ENSURE_DEFINITIONS_PATH), (String)DEFAULT_ENSURE_DEFINITIONS_PATH);
        this.oakIndexesPath = PropertiesUtil.toString((Object)config.get(PROP_OAK_INDEXES_PATH), (String)DEFAULT_OAK_INDEXES_PATH);
        if (StringUtils.isBlank((String)this.ensureDefinitionsPath)) {
            throw new IllegalArgumentException("OSGi Configuration Property `ensure-definitions.path` cannot be blank.");
        }
        if (StringUtils.isBlank((String)this.oakIndexesPath)) {
            throw new IllegalArgumentException("OSGi Configuration Property `oak-indexes.path` cannot be blank.");
        }
        this.immediate = PropertiesUtil.toBoolean((Object)config.get(PROP_IMMEDIATE), (boolean)true);
        if (this.immediate) {
            this.apply(false);
        }
    }

    @Override
    public final void apply(boolean force) {
        if (!force && this.applied) {
            return;
        }
        log.info("Ensuring Oak Indexes [ {} ~> {} ]", (Object)this.ensureDefinitionsPath, (Object)this.oakIndexesPath);
        EnsureOakIndexJobHandler jobHandler = new EnsureOakIndexJobHandler(this, this.oakIndexesPath, this.ensureDefinitionsPath);
        ScheduleOptions options = this.scheduler.NOW();
        options.name(this.toString());
        options.canRunConcurrently(false);
        this.scheduler.schedule((Object)jobHandler, options);
        this.applied = true;
        log.info("Job scheduled for ensuring Oak Indexes [ {} ~> {} ]", (Object)this.ensureDefinitionsPath, (Object)this.oakIndexesPath);
    }

    @Override
    public final boolean isApplied() {
        return this.applied;
    }

    @Override
    public boolean isImmediate() {
        return this.immediate;
    }

    @Override
    public List<String> getIgnoreProperties() {
        return this.ignoreProperties;
    }

    @Override
    public void setIgnoreProperties(String[] ignoreProperties) {
        this.ignoreProperties = new CopyOnWriteArrayList<String>(ignoreProperties);
    }

    @Override
    public final String getEnsureDefinitionsPath() {
        return StringUtils.trim((String)this.ensureDefinitionsPath);
    }

    @Override
    public String getOakIndexesPath() {
        return StringUtils.trim((String)this.oakIndexesPath);
    }

    public final String toString() {
        return String.format("EnsureOakIndex( %s => %s )", this.ensureDefinitionsPath, this.oakIndexesPath);
    }

    ChecksumGenerator getChecksumGenerator() {
        return this.checksumGenerator;
    }

    final ResourceResolverFactory getResourceResolverFactory() {
        return this.resourceResolverFactory;
    }

    protected void bindCapabilityHelper(AemCapabilityHelper aemCapabilityHelper) {
        this.capabilityHelper = aemCapabilityHelper;
    }

    protected void unbindCapabilityHelper(AemCapabilityHelper aemCapabilityHelper) {
        if (this.capabilityHelper == aemCapabilityHelper) {
            this.capabilityHelper = null;
        }
    }

    protected void bindChecksumGenerator(ChecksumGenerator checksumGenerator) {
        this.checksumGenerator = checksumGenerator;
    }

    protected void unbindChecksumGenerator(ChecksumGenerator checksumGenerator) {
        if (this.checksumGenerator == checksumGenerator) {
            this.checksumGenerator = null;
        }
    }

    protected void bindResourceResolverFactory(ResourceResolverFactory resourceResolverFactory) {
        this.resourceResolverFactory = resourceResolverFactory;
    }

    protected void unbindResourceResolverFactory(ResourceResolverFactory resourceResolverFactory) {
        if (this.resourceResolverFactory == resourceResolverFactory) {
            this.resourceResolverFactory = null;
        }
    }

    protected void bindScheduler(Scheduler scheduler) {
        this.scheduler = scheduler;
    }

    protected void unbindScheduler(Scheduler scheduler) {
        if (this.scheduler == scheduler) {
            this.scheduler = null;
        }
    }

    static class OakIndexDefinitionException
    extends Exception {
        OakIndexDefinitionException(String message) {
            super(message);
        }
    }
}

