/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.acs.commons.packaging.impl;

import com.adobe.acs.commons.packaging.PackageHelper;
import com.adobe.acs.commons.packaging.impl.AbstractPackagerServlet;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import javax.jcr.RepositoryException;
import org.apache.felix.scr.annotations.Reference;
import org.apache.felix.scr.annotations.sling.SlingServlet;
import org.apache.jackrabbit.api.security.user.Authorizable;
import org.apache.jackrabbit.api.security.user.UserManager;
import org.apache.jackrabbit.vault.fs.api.Filter;
import org.apache.jackrabbit.vault.fs.api.PathFilterSet;
import org.apache.jackrabbit.vault.fs.filter.DefaultPathFilter;
import org.apache.jackrabbit.vault.packaging.Packaging;
import org.apache.sling.api.SlingHttpServletRequest;
import org.apache.sling.api.SlingHttpServletResponse;
import org.apache.sling.api.resource.ResourceResolver;
import org.apache.sling.api.resource.ValueMap;
import org.apache.sling.api.wrappers.ValueMapDecorator;
import org.apache.sling.commons.json.JSONException;

@SlingServlet(methods={"POST"}, resourceTypes={"acs-commons/components/utilities/packager/authorizable-packager"}, selectors={"package"}, extensions={"json"})
public class AuthorizablePackagerServletImpl
extends AbstractPackagerServlet {
    private static final String DEFAULT_PACKAGE_NAME = "authorizables";
    private static final String DEFAULT_PACKAGE_GROUP_NAME = "Authorizables";
    private static final String DEFAULT_PACKAGE_DESCRIPTION = "Authorizable Package initially defined by a ACS AEM Commons - Authorizable Packager configuration.";
    private static final String PACKAGE_THUMBNAIL_RESOURCE_PATH = "/apps/acs-commons/components/utilities/packager/authorizable-packager/definition/package-thumbnail.png";
    @Reference
    private Packaging packaging;
    @Reference
    private PackageHelper packageHelper;

    public final void doPost(SlingHttpServletRequest request, SlingHttpServletResponse response) throws IOException {
        ResourceResolver resourceResolver = request.getResourceResolver();
        boolean preview = Boolean.parseBoolean(request.getParameter("preview"));
        this.log.debug("Preview mode: {}", (Object)preview);
        ValueMap properties = this.getProperties(request);
        try {
            List<PathFilterSet> paths = this.findPaths(resourceResolver, (String[])properties.get("authorizableIds", (Object)new String[0]));
            this.doPackaging(request, response, preview, properties, paths);
        }
        catch (RepositoryException ex) {
            this.log.error("Repository error while creating Query Package", (Throwable)ex);
            response.getWriter().print(this.packageHelper.getErrorJSON(ex.getMessage()));
        }
        catch (IOException ex) {
            this.log.error("IO error while creating Query Package", (Throwable)ex);
            response.getWriter().print(this.packageHelper.getErrorJSON(ex.getMessage()));
        }
        catch (JSONException ex) {
            this.log.error("JSON error while creating Query Package response", (Throwable)ex);
            response.getWriter().print(this.packageHelper.getErrorJSON(ex.getMessage()));
        }
    }

    private ValueMap getProperties(SlingHttpServletRequest request) {
        if (request.getResource().getChild("configuration") == null) {
            this.log.warn("Authorizable Packager Configuration node could not be found for: {}", (Object)request.getResource());
            return new ValueMapDecorator(new HashMap());
        }
        return (ValueMap)request.getResource().getChild("configuration").adaptTo(ValueMap.class);
    }

    private List<PathFilterSet> findPaths(ResourceResolver resourceResolver, String[] authorizableIds) throws RepositoryException {
        UserManager userManager = (UserManager)resourceResolver.adaptTo(UserManager.class);
        ArrayList<PathFilterSet> pathFilterSets = new ArrayList<PathFilterSet>();
        for (String authorizableId : authorizableIds) {
            try {
                Authorizable authorizable = userManager.getAuthorizable(authorizableId);
                if (authorizable == null) continue;
                String path = authorizable.getPath();
                PathFilterSet principal = new PathFilterSet(path);
                principal.addExclude((Filter)new DefaultPathFilter(path + "/\\.tokens"));
                pathFilterSets.add(principal);
            }
            catch (RepositoryException e) {
                this.log.warn("Unable to find path for authorizable " + authorizableId, (Throwable)e);
            }
        }
        return pathFilterSets;
    }

    @Override
    protected String getDefaultPackageDescription() {
        return DEFAULT_PACKAGE_DESCRIPTION;
    }

    @Override
    protected String getDefaultPackageGroupName() {
        return DEFAULT_PACKAGE_GROUP_NAME;
    }

    @Override
    protected String getDefaultPackageName() {
        return DEFAULT_PACKAGE_NAME;
    }

    @Override
    protected String getPackageThumbnailPath() {
        return PACKAGE_THUMBNAIL_RESOURCE_PATH;
    }

    @Override
    protected PackageHelper getPackageHelper() {
        return this.packageHelper;
    }

    protected void bindPackaging(Packaging packaging) {
        this.packaging = packaging;
    }

    protected void unbindPackaging(Packaging packaging) {
        if (this.packaging == packaging) {
            this.packaging = null;
        }
    }

    protected void bindPackageHelper(PackageHelper packageHelper) {
        this.packageHelper = packageHelper;
    }

    protected void unbindPackageHelper(PackageHelper packageHelper) {
        if (this.packageHelper == packageHelper) {
            this.packageHelper = null;
        }
    }
}

