/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.acs.commons.packaging.impl;

import com.adobe.acs.commons.packaging.PackageHelper;
import com.adobe.acs.commons.packaging.impl.JcrPackageCoverageProgressListener;
import com.day.cq.commons.jcr.JcrUtil;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import javax.jcr.Node;
import javax.jcr.NodeIterator;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import org.apache.commons.lang.StringUtils;
import org.apache.felix.scr.annotations.Component;
import org.apache.felix.scr.annotations.Reference;
import org.apache.felix.scr.annotations.Service;
import org.apache.jackrabbit.vault.fs.api.PathFilterSet;
import org.apache.jackrabbit.vault.fs.api.ProgressTrackerListener;
import org.apache.jackrabbit.vault.fs.api.WorkspaceFilter;
import org.apache.jackrabbit.vault.fs.config.DefaultWorkspaceFilter;
import org.apache.jackrabbit.vault.fs.io.ImportOptions;
import org.apache.jackrabbit.vault.packaging.JcrPackage;
import org.apache.jackrabbit.vault.packaging.JcrPackageDefinition;
import org.apache.jackrabbit.vault.packaging.JcrPackageManager;
import org.apache.jackrabbit.vault.packaging.PackageException;
import org.apache.jackrabbit.vault.packaging.PackageId;
import org.apache.jackrabbit.vault.packaging.Packaging;
import org.apache.jackrabbit.vault.packaging.Version;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.commons.json.JSONArray;
import org.apache.sling.commons.json.JSONException;
import org.apache.sling.commons.json.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component
@Service
public final class PackageHelperImpl
implements PackageHelper {
    private static final Logger log = LoggerFactory.getLogger(PackageHelperImpl.class);
    private static final String NN_THUMBNAIL = "thumbnail.png";
    private static final String JSON_EXCEPTION_MSG = "{\"status\": \"error\", \"msg\": \"Error creating JSON response.\"}";
    private static final String KEY_STATUS = "status";
    private static final String KEY_MSG = "msg";
    private static final String KEY_PATH = "path";
    private static final String KEY_FILTER_SETS = "filterSets";
    private static final String KEY_IMPORT_MODE = "importMode";
    private static final String KEY_ROOT_PATH = "rootPath";
    @Reference
    private Packaging packaging;

    @Override
    public void addThumbnail(JcrPackage jcrPackage, Resource thumbnailResource) {
        if (jcrPackage == null) {
            log.error("JCR Package is null; no package thumbnail needed for null packages!");
            return;
        }
        Node thumbnailNode = null;
        if (thumbnailResource != null) {
            thumbnailNode = (Node)thumbnailResource.adaptTo(Node.class);
        }
        try {
            boolean useDefault = thumbnailNode == null || !thumbnailNode.isNodeType("nt:file");
            Node dstParentNode = jcrPackage.getDefinition().getNode();
            Session session = dstParentNode.getSession();
            if (useDefault) {
                log.debug("Using default ACS AEM Commons packager package icon.");
                if (session.nodeExists("/apps/acs-commons/components/utilities/packager/definition/package-thumbnail.png")) {
                    thumbnailNode = session.getNode("/apps/acs-commons/components/utilities/packager/definition/package-thumbnail.png");
                }
            }
            if (thumbnailNode == null || !thumbnailNode.isNodeType("nt:file")) {
                log.warn("Cannot find a specific OR a default package icon; no package icon will be used.");
            } else {
                JcrUtil.copy((Node)thumbnailNode, (Node)dstParentNode, (String)NN_THUMBNAIL);
                dstParentNode.getSession().save();
            }
        }
        catch (RepositoryException e) {
            log.error("Could not add package thumbnail: {}", (Throwable)e);
        }
    }

    @Override
    public Version getNextVersion(JcrPackageManager jcrPackageManager, String groupName, String name, String version) throws RepositoryException {
        Node packageRoot = jcrPackageManager.getPackageRoot(false);
        Version configVersion = Version.create((String)version);
        if (!packageRoot.hasNode(groupName)) {
            return configVersion;
        }
        Node packageGroupNode = packageRoot.getNode(groupName);
        if (packageGroupNode == null) {
            return configVersion;
        }
        NodeIterator children = packageGroupNode.getNodes();
        Version latestVersion = configVersion;
        boolean configVersionEligible = true;
        while (children.hasNext()) {
            Node child = children.nextNode();
            JcrPackage jcrPackage = jcrPackageManager.open(child, true);
            if (jcrPackage == null || jcrPackage.getDefinition() == null || jcrPackage.getDefinition().getId() == null) {
                log.warn("Could not covert node [ {} ] into a proper JCR Package, moving to next node", (Object)child.getPath());
                continue;
            }
            if (!StringUtils.equals((String)name, (String)jcrPackage.getDefinition().getId().getName())) continue;
            Version packageVersion = jcrPackage.getDefinition().getId().getVersion();
            log.debug(packageVersion.toString() + " compareTo " + latestVersion.toString() + " = " + packageVersion.compareTo(latestVersion));
            if (packageVersion.compareTo(latestVersion) >= 1) {
                latestVersion = packageVersion;
                log.debug("Found a new latest version: {}", (Object)latestVersion.toString());
                continue;
            }
            if (packageVersion.compareTo(configVersion) != 0) continue;
            configVersionEligible = false;
            log.debug("Found a package with the same version as the config version");
        }
        log.debug("Current latest version: {}", (Object)latestVersion.toString());
        if (configVersionEligible && latestVersion.equals((Object)configVersion)) {
            return configVersion;
        }
        latestVersion = this.normalizeVersion(latestVersion);
        String[] segments = latestVersion.getNormalizedSegments();
        segments[1] = String.valueOf(Integer.parseInt(segments[1]) + 1);
        Version nextVersion = Version.create((String[])segments);
        log.debug("Next version: {}", (Object)nextVersion);
        return nextVersion;
    }

    private Version normalizeVersion(Version version) {
        int numVersionSegments = 3;
        String[] normalizedSegments = version.getNormalizedSegments();
        String[] segments = new String[]{normalizedSegments.length <= 0 ? "1" : normalizedSegments[0], normalizedSegments.length <= 1 ? "0" : normalizedSegments[1], normalizedSegments.length <= 2 ? "0" : normalizedSegments[2]};
        return Version.create((String[])segments);
    }

    @Override
    public void removePackage(JcrPackageManager jcrPackageManager, String groupName, String name, String version) throws RepositoryException {
        PackageId packageId = new PackageId(groupName, name, version);
        JcrPackage jcrPackage = jcrPackageManager.open(packageId);
        if (jcrPackage != null && jcrPackage.getNode() != null) {
            jcrPackage.getNode().remove();
            jcrPackage.getNode().getSession().save();
        } else {
            log.debug("Nothing to remove at: ", (Object)packageId.getInstallationPath());
        }
    }

    @Override
    public JcrPackage createPackage(Collection<Resource> resources, Session session, String groupName, String name, String version, PackageHelper.ConflictResolution conflictResolution, Map<String, String> packageDefinitionProperties) throws IOException, RepositoryException {
        ArrayList<PathFilterSet> pathFilterSets = new ArrayList<PathFilterSet>();
        for (Resource resource : resources) {
            pathFilterSets.add(new PathFilterSet(resource.getPath()));
        }
        return this.createPackageFromPathFilterSets(pathFilterSets, session, groupName, name, version, conflictResolution, packageDefinitionProperties);
    }

    @Override
    public JcrPackage createPackageForPaths(Collection<String> paths, Session session, String groupName, String name, String version, PackageHelper.ConflictResolution conflictResolution, Map<String, String> packageDefinitionProperties) throws IOException, RepositoryException {
        ArrayList<PathFilterSet> pathFilterSets = new ArrayList<PathFilterSet>();
        for (String path : paths) {
            pathFilterSets.add(new PathFilterSet(path));
        }
        return this.createPackageFromPathFilterSets(pathFilterSets, session, groupName, name, version, conflictResolution, packageDefinitionProperties);
    }

    @Override
    public JcrPackage createPackageFromPathFilterSets(Collection<PathFilterSet> pathFilterSets, Session session, String groupName, String name, String version, PackageHelper.ConflictResolution conflictResolution, Map<String, String> packageDefinitionProperties) throws IOException, RepositoryException {
        JcrPackageManager jcrPackageManager = this.packaging.getPackageManager(session);
        if (PackageHelper.ConflictResolution.Replace.equals((Object)conflictResolution)) {
            this.removePackage(jcrPackageManager, groupName, name, version);
        } else if (PackageHelper.ConflictResolution.IncrementVersion.equals((Object)conflictResolution)) {
            version = this.getNextVersion(jcrPackageManager, groupName, name, version).toString();
        }
        JcrPackage jcrPackage = jcrPackageManager.create(groupName, name, version);
        JcrPackageDefinition jcrPackageDefinition = jcrPackage.getDefinition();
        DefaultWorkspaceFilter workspaceFilter = new DefaultWorkspaceFilter();
        for (PathFilterSet pathFilterSet : pathFilterSets) {
            workspaceFilter.add(pathFilterSet);
        }
        jcrPackageDefinition.setFilter((WorkspaceFilter)workspaceFilter, true);
        for (Map.Entry entry : packageDefinitionProperties.entrySet()) {
            jcrPackageDefinition.set((String)entry.getKey(), (String)entry.getValue(), false);
        }
        session.save();
        return jcrPackage;
    }

    @Override
    public List<String> getContents(JcrPackage jcrPackage) throws IOException, RepositoryException, PackageException {
        JcrPackageCoverageProgressListener jcrPackageCoverageProgressListener = new JcrPackageCoverageProgressListener();
        ImportOptions importOptions = new ImportOptions();
        importOptions.setDryRun(true);
        importOptions.setListener((ProgressTrackerListener)jcrPackageCoverageProgressListener);
        jcrPackage.extract(importOptions);
        return jcrPackageCoverageProgressListener.getCoverage();
    }

    @Override
    public String getSuccessJSON(JcrPackage jcrPackage) throws JSONException, RepositoryException {
        JSONObject json = new JSONObject();
        json.put(KEY_STATUS, (Object)"success");
        json.put(KEY_PATH, (Object)jcrPackage.getNode().getPath());
        json.put(KEY_FILTER_SETS, (Object)new JSONArray());
        List filterSets = jcrPackage.getDefinition().getMetaInf().getFilter().getFilterSets();
        for (PathFilterSet filterSet : filterSets) {
            JSONObject jsonFilterSet = new JSONObject();
            jsonFilterSet.put(KEY_IMPORT_MODE, (Object)filterSet.getImportMode().name());
            jsonFilterSet.put(KEY_ROOT_PATH, (Object)filterSet.getRoot());
            json.accumulate(KEY_FILTER_SETS, (Object)jsonFilterSet);
        }
        return json.toString();
    }

    @Override
    public String getPreviewJSON(Collection<Resource> resources) throws JSONException {
        ArrayList<PathFilterSet> pathFilterSets = new ArrayList<PathFilterSet>();
        for (Resource resource : resources) {
            pathFilterSets.add(new PathFilterSet(resource.getPath()));
        }
        return this.getPathFilterSetPreviewJSON(pathFilterSets);
    }

    @Override
    public String getPreviewJSONForPaths(Collection<String> paths) throws JSONException {
        ArrayList<PathFilterSet> pathFilterSets = new ArrayList<PathFilterSet>();
        for (String path : paths) {
            pathFilterSets.add(new PathFilterSet(path));
        }
        return this.getPathFilterSetPreviewJSON(pathFilterSets);
    }

    @Override
    public String getPathFilterSetPreviewJSON(Collection<PathFilterSet> pathFilterSets) throws JSONException {
        JSONObject json = new JSONObject();
        json.put(KEY_STATUS, (Object)"preview");
        json.put(KEY_PATH, (Object)"Not applicable (Preview)");
        json.put(KEY_FILTER_SETS, (Object)new JSONArray());
        for (PathFilterSet pathFilterSet : pathFilterSets) {
            JSONObject tmp = new JSONObject();
            tmp.put(KEY_IMPORT_MODE, (Object)"Not applicable (Preview)");
            tmp.put(KEY_ROOT_PATH, (Object)pathFilterSet.getRoot());
            json.accumulate(KEY_FILTER_SETS, (Object)tmp);
        }
        return json.toString();
    }

    @Override
    public String getErrorJSON(String msg) {
        JSONObject json = new JSONObject();
        try {
            json.put(KEY_STATUS, (Object)"error");
            json.put(KEY_MSG, (Object)msg);
            return json.toString();
        }
        catch (JSONException e) {
            log.error("Error creating JSON Error response message: {}", (Throwable)e);
            return JSON_EXCEPTION_MSG;
        }
    }

    protected void bindPackaging(Packaging packaging) {
        this.packaging = packaging;
    }

    protected void unbindPackaging(Packaging packaging) {
        if (this.packaging == packaging) {
            this.packaging = null;
        }
    }
}

