/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.acs.commons.packaging.impl;

import com.adobe.acs.commons.packaging.PackageHelper;
import com.adobe.acs.commons.util.QueryHelper;
import com.day.cq.search.QueryBuilder;
import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import org.apache.felix.scr.annotations.Reference;
import org.apache.felix.scr.annotations.sling.SlingServlet;
import org.apache.jackrabbit.vault.fs.io.AccessControlHandling;
import org.apache.jackrabbit.vault.packaging.JcrPackage;
import org.apache.jackrabbit.vault.packaging.Packaging;
import org.apache.sling.api.SlingHttpServletRequest;
import org.apache.sling.api.SlingHttpServletResponse;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.resource.ResourceResolver;
import org.apache.sling.api.resource.ValueMap;
import org.apache.sling.api.servlets.SlingAllMethodsServlet;
import org.apache.sling.api.wrappers.ValueMapDecorator;
import org.apache.sling.commons.json.JSONException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@SlingServlet(methods={"POST"}, resourceTypes={"acs-commons/components/utilities/packager/query-packager"}, selectors={"package"}, extensions={"json"})
public class QueryPackagerServletImpl
extends SlingAllMethodsServlet {
    private static final Logger log = LoggerFactory.getLogger(QueryPackagerServletImpl.class);
    private static final String PACKAGE_NAME = "packageName";
    private static final String PACKAGE_GROUP_NAME = "packageGroupName";
    private static final String PACKAGE_VERSION = "packageVersion";
    private static final String PACKAGE_DESCRIPTION = "packageDescription";
    private static final String PACKAGE_ACL_HANDLING = "packageACLHandling";
    private static final String CONFLICT_RESOLUTION = "conflictResolution";
    private static final String DEFAULT_PACKAGE_NAME = "query";
    private static final String DEFAULT_PACKAGE_GROUP_NAME = "Query";
    private static final String DEFAULT_PACKAGE_VERSION = "1.0.0";
    private static final String DEFAULT_PACKAGE_DESCRIPTION = "Query Package initially defined by a ACS AEM Commons - Query Packager configuration.";
    private static final String QUERY_PACKAGE_THUMBNAIL_RESOURCE_PATH = "/apps/acs-commons/components/utilities/packager/query-packager/definition/package-thumbnail.png";
    @Reference
    private Packaging packaging;
    @Reference
    private PackageHelper packageHelper;
    @Reference
    private QueryBuilder queryBuilder;
    @Reference
    private QueryHelper queryHelper;

    public final void doPost(SlingHttpServletRequest request, SlingHttpServletResponse response) throws IOException {
        ResourceResolver resourceResolver = request.getResourceResolver();
        boolean preview = Boolean.parseBoolean(request.getParameter("preview"));
        log.debug("Preview mode: {}", (Object)preview);
        ValueMap properties = this.getProperties(request);
        try {
            List<Resource> packageResources = this.queryHelper.findResources(resourceResolver, (String)properties.get("queryLanguage", (Object)"JCR-SQL2"), (String)properties.get(DEFAULT_PACKAGE_NAME, String.class), (String)properties.get("relPath", String.class));
            HashMap<String, String> packageDefinitionProperties = new HashMap<String, String>();
            packageDefinitionProperties.put("acHandling", (String)properties.get(PACKAGE_ACL_HANDLING, (Object)AccessControlHandling.OVERWRITE.toString()));
            packageDefinitionProperties.put("jcr:description", (String)properties.get(PACKAGE_DESCRIPTION, (Object)DEFAULT_PACKAGE_DESCRIPTION));
            if (preview) {
                response.getWriter().print(this.packageHelper.getPreviewJSON(packageResources));
            } else if (packageResources == null || packageResources.isEmpty()) {
                response.getWriter().print(this.packageHelper.getErrorJSON("Refusing to create a package with no filter set rules."));
            } else {
                JcrPackage jcrPackage = this.packageHelper.createPackage(packageResources, (Session)request.getResourceResolver().adaptTo(Session.class), (String)properties.get(PACKAGE_GROUP_NAME, (Object)DEFAULT_PACKAGE_GROUP_NAME), (String)properties.get(PACKAGE_NAME, (Object)DEFAULT_PACKAGE_NAME), (String)properties.get(PACKAGE_VERSION, (Object)DEFAULT_PACKAGE_VERSION), PackageHelper.ConflictResolution.valueOf((String)properties.get(CONFLICT_RESOLUTION, (Object)PackageHelper.ConflictResolution.IncrementVersion.toString())), packageDefinitionProperties);
                this.packageHelper.addThumbnail(jcrPackage, request.getResourceResolver().getResource(QUERY_PACKAGE_THUMBNAIL_RESOURCE_PATH));
                log.debug("Successfully created JCR package");
                response.getWriter().print(this.packageHelper.getSuccessJSON(jcrPackage));
            }
        }
        catch (RepositoryException ex) {
            log.error("Repository error while creating Query Package", (Throwable)ex);
            response.getWriter().print(this.packageHelper.getErrorJSON(ex.getMessage()));
        }
        catch (IOException ex) {
            log.error("IO error while creating Query Package", (Throwable)ex);
            response.getWriter().print(this.packageHelper.getErrorJSON(ex.getMessage()));
        }
        catch (JSONException ex) {
            log.error("JSON error while creating Query Package response", (Throwable)ex);
            response.getWriter().print(this.packageHelper.getErrorJSON(ex.getMessage()));
        }
    }

    private ValueMap getProperties(SlingHttpServletRequest request) {
        if (request.getResource().getChild("configuration") == null) {
            log.warn("Query Packager Configuration node could not be found for: {}", (Object)request.getResource());
            return new ValueMapDecorator(new HashMap());
        }
        return (ValueMap)request.getResource().getChild("configuration").adaptTo(ValueMap.class);
    }

    protected void bindPackaging(Packaging packaging) {
        this.packaging = packaging;
    }

    protected void unbindPackaging(Packaging packaging) {
        if (this.packaging == packaging) {
            this.packaging = null;
        }
    }

    protected void bindPackageHelper(PackageHelper packageHelper) {
        this.packageHelper = packageHelper;
    }

    protected void unbindPackageHelper(PackageHelper packageHelper) {
        if (this.packageHelper == packageHelper) {
            this.packageHelper = null;
        }
    }

    protected void bindQueryBuilder(QueryBuilder queryBuilder) {
        this.queryBuilder = queryBuilder;
    }

    protected void unbindQueryBuilder(QueryBuilder queryBuilder) {
        if (this.queryBuilder == queryBuilder) {
            this.queryBuilder = null;
        }
    }

    protected void bindQueryHelper(QueryHelper queryHelper) {
        this.queryHelper = queryHelper;
    }

    protected void unbindQueryHelper(QueryHelper queryHelper) {
        if (this.queryHelper == queryHelper) {
            this.queryHelper = null;
        }
    }
}

