/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.acs.commons.quickly.operations.impl;

import com.adobe.acs.commons.quickly.Command;
import com.adobe.acs.commons.quickly.operations.AbstractOperation;
import com.adobe.acs.commons.quickly.results.Result;
import com.adobe.acs.commons.util.TextUtil;
import com.day.cq.search.PredicateGroup;
import com.day.cq.search.Query;
import com.day.cq.search.QueryBuilder;
import com.day.cq.search.result.Hit;
import com.day.cq.search.result.SearchResult;
import com.day.cq.wcm.api.Page;
import com.day.cq.wcm.api.PageManager;
import java.text.Format;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.time.FastDateFormat;
import org.apache.felix.scr.annotations.Component;
import org.apache.felix.scr.annotations.Properties;
import org.apache.felix.scr.annotations.Property;
import org.apache.felix.scr.annotations.Reference;
import org.apache.felix.scr.annotations.Service;
import org.apache.sling.api.SlingHttpServletRequest;
import org.apache.sling.api.SlingHttpServletResponse;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.resource.ResourceResolver;
import org.apache.sling.commons.json.JSONException;
import org.apache.sling.commons.json.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component
@Properties(value={@Property(name="cmd", value={"lastmod"})})
@Service
public class LastModifiedOperationImpl
extends AbstractOperation {
    private static final Logger log = LoggerFactory.getLogger(LastModifiedOperationImpl.class);
    public static final String CMD = "lastmod";
    private static final Format DATE_FORMAT = FastDateFormat.getInstance((String)"EEE, d MMM yyyy @ hh:mm aaa");
    private static final int MAX_QUERY_RESULTS = 25;
    @Reference
    private QueryBuilder queryBuilder;

    @Override
    public boolean accepts(SlingHttpServletRequest request, Command cmd) {
        return StringUtils.equalsIgnoreCase((String)CMD, (String)cmd.getOp());
    }

    @Override
    public String getCmd() {
        return CMD;
    }

    @Override
    protected List<Result> withoutParams(SlingHttpServletRequest request, SlingHttpServletResponse response, Command cmd) {
        ArrayList<Result> results = new ArrayList<Result>();
        Result infoResult = new Result.Builder("lastmod [ userId ] [ 1s | 2m | 3h | 4d | 5w | 6M | 7y ]").description("Returns the last modified Pages. Defaults to: me 1d").build();
        results.add(infoResult);
        results.addAll(this.withParams(request, response, cmd));
        return results;
    }

    @Override
    protected List<Result> withParams(SlingHttpServletRequest request, SlingHttpServletResponse response, Command cmd) {
        long start = System.currentTimeMillis();
        ArrayList<Result> results = new ArrayList<Result>();
        ResourceResolver resourceResolver = request.getResourceResolver();
        PageManager pageManager = (PageManager)resourceResolver.adaptTo(PageManager.class);
        List<Resource> pages = this.getLastModifiedPages(resourceResolver, cmd);
        log.debug("LastModified pages -- [ {} ] results", (Object)pages.size());
        for (Resource resource : pages) {
            Page page = pageManager.getContainingPage(resource);
            if (page == null) continue;
            String title = TextUtil.getFirstNonEmpty(page.getTitle(), page.getPageTitle(), page.getNavigationTitle(), page.getName());
            String description = page.getPath() + " by " + page.getLastModifiedBy() + " at " + DATE_FORMAT.format(page.getLastModified().getTime());
            results.add(new Result.Builder(title).path(page.getPath()).description(description).resultType("OPEN").build());
        }
        log.debug("Lastmod - Execution time: {} ms", (Object)(System.currentTimeMillis() - start));
        return results;
    }

    private List<Resource> getLastModifiedPages(ResourceResolver resourceResolver, Command cmd) {
        String relativeDateRange = this.getRelativeDateRangeLowerBoundParam(cmd);
        String userId = this.getUserIdParam(cmd, resourceResolver.getUserID());
        return this.getLastModifiedQuery(resourceResolver, userId, relativeDateRange, "cq:PageContent", "@cq:lastModified", 25);
    }

    private List<Resource> getLastModifiedQuery(ResourceResolver resourceResolver, String userId, String relativeDateRange, String nodeType, String dateProperty, int limit) {
        ArrayList<Resource> resources = new ArrayList<Resource>();
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("path", "/content");
        map.put("type", nodeType);
        map.put("1_property", "cq:lastModifiedBy");
        map.put("1_property.value", userId);
        map.put("relativedaterange.property", dateProperty);
        map.put("relativedaterange.lowerBound", relativeDateRange);
        map.put("orderby", dateProperty);
        map.put("orderby.sort", "desc");
        map.put("p.limit", String.valueOf(limit));
        map.put("p.guessTotal", "true");
        try {
            log.debug("Lastmod QueryBuilder Map: {}", (Object)new JSONObject(map).toString(2));
        }
        catch (JSONException jSONException) {
            // empty catch block
        }
        Query query = this.queryBuilder.createQuery(PredicateGroup.create(map), (Session)resourceResolver.adaptTo(Session.class));
        SearchResult result = query.getResult();
        for (Hit hit : result.getHits()) {
            try {
                resources.add(hit.getResource());
            }
            catch (RepositoryException e) {
                log.error("Error resolving Hit to Resource [ {} ]. Likely issue with lucene index being out of sync.", (Object)hit.toString());
            }
        }
        return resources;
    }

    private String getRelativeDateRangeLowerBoundParam(Command cmd) {
        String defaultParam = "-1d";
        String[] params = cmd.getParams();
        if (params.length > 0) {
            String param = params[0];
            if (params.length > 1) {
                param = params[1];
            }
            if (StringUtils.isNotBlank((String)param) && param.matches("\\d+[s|m|h|d|w|M|y]{1}")) {
                return "-" + param;
            }
        }
        return "-1d";
    }

    private String getUserIdParam(Command cmd, String currentUserId) {
        String param;
        String[] params = cmd.getParams();
        if (params.length > 0 && StringUtils.isNotBlank((String)(param = params[0])) && !StringUtils.equalsIgnoreCase((String)param, (String)"me") && !param.matches("\\d+[s|m|h|d|w|M|y]{1}")) {
            return param;
        }
        return currentUserId;
    }

    protected void bindQueryBuilder(QueryBuilder queryBuilder) {
        this.queryBuilder = queryBuilder;
    }

    protected void unbindQueryBuilder(QueryBuilder queryBuilder) {
        if (this.queryBuilder == queryBuilder) {
            this.queryBuilder = null;
        }
    }
}

