/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.acs.commons.redirectmaps.impl;

import com.adobe.acs.commons.redirectmaps.models.MapEntry;
import com.adobe.acs.commons.redirectmaps.models.RedirectMapModel;
import com.google.common.base.Charsets;
import com.google.common.net.MediaType;
import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.reflect.TypeToken;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import javax.servlet.ServletException;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.sling.api.SlingHttpServletRequest;
import org.apache.sling.api.SlingHttpServletResponse;
import org.apache.sling.api.resource.ModifiableValueMap;
import org.apache.sling.api.resource.PersistenceException;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.resource.ResourceResolver;
import org.apache.sling.api.resource.ResourceUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RedirectEntriesUtils {
    private static final Gson gson = new Gson();
    private static final Logger log = LoggerFactory.getLogger(RedirectEntriesUtils.class);

    private RedirectEntriesUtils() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static final List<String> readEntries(SlingHttpServletRequest request) throws IOException {
        List<String> lines = new ArrayList<String>();
        InputStream is = null;
        try {
            Resource resource = request.getResource();
            Resource fileResource = resource.getChild("redirectMap.txt");
            if (fileResource != null && fileResource.adaptTo(InputStream.class) != null) {
                is = (InputStream)fileResource.adaptTo(InputStream.class);
                lines = IOUtils.readLines((InputStream)is);
            }
            log.debug("Loaded {} lines", (Object)lines.size());
        }
        finally {
            IOUtils.closeQuietly(is);
        }
        return lines;
    }

    protected static final void updateRedirectMap(SlingHttpServletRequest request, List<String> entries) throws PersistenceException {
        Resource resource = request.getResource();
        log.info("Updating redirect map at {}", (Object)request.getResource().getPath());
        Calendar now = Calendar.getInstance();
        ModifiableValueMap contentProperties = (ModifiableValueMap)resource.adaptTo(ModifiableValueMap.class);
        contentProperties.put((Object)"cq:lastModified", (Object)now);
        contentProperties.put((Object)"cq:lastModifiedBy", (Object)request.getResourceResolver().getUserID());
        HashMap<String, String> fileParams = new HashMap<String, String>();
        fileParams.put("jcr:primaryType", "nt:file");
        Resource fileResource = ResourceUtil.getOrCreateResource((ResourceResolver)request.getResourceResolver(), (String)(resource.getPath() + "/" + "redirectMap.txt"), fileParams, (String)"nt:unstructured", (boolean)false);
        HashMap<String, String> contentParams = new HashMap<String, String>();
        contentParams.put("jcr:primaryType", "nt:resource");
        contentParams.put("jcr:mimeType", "text/plain");
        Resource contentResource = ResourceUtil.getOrCreateResource((ResourceResolver)resource.getResourceResolver(), (String)(fileResource.getPath() + "/" + "jcr:content"), contentParams, (String)"nt:unstructured", (boolean)false);
        ModifiableValueMap mvm = (ModifiableValueMap)contentResource.adaptTo(ModifiableValueMap.class);
        mvm.put((Object)"jcr:data", (Object)new ByteArrayInputStream(StringUtils.join(entries, (String)"\n").getBytes(Charsets.UTF_8)));
        mvm.put((Object)"jcr:lastModified", (Object)now);
        mvm.put((Object)"jcr:lastModifiedBy", (Object)request.getResourceResolver().getUserID());
        request.getResourceResolver().commit();
        request.getResourceResolver().refresh();
        log.debug("Changes saved...");
    }

    protected static final void writeEntriesToResponse(SlingHttpServletRequest request, SlingHttpServletResponse response, String message) throws ServletException, IOException {
        log.trace("writeEntriesToResponse");
        log.debug("Requesting redirect maps from {}", (Object)request.getResource());
        RedirectMapModel redirectMap = (RedirectMapModel)request.getResource().adaptTo(RedirectMapModel.class);
        response.setContentType(MediaType.JSON_UTF_8.toString());
        JsonObject res = new JsonObject();
        res.addProperty("message", message);
        JsonElement entries = gson.toJsonTree(redirectMap.getEntries(), new TypeToken<List<MapEntry>>(){}.getType());
        Iterator it = entries.getAsJsonArray().iterator();
        int i = 0;
        while (it.hasNext()) {
            ((JsonElement)it.next()).getAsJsonObject().addProperty("id", (Number)i);
            ++i;
        }
        res.add("entries", entries);
        res.add("invalidEntries", gson.toJsonTree(redirectMap.getInvalidEntries(), new TypeToken<List<MapEntry>>(){}.getType()));
        IOUtils.write((String)res.toString(), (OutputStream)response.getOutputStream(), (Charset)StandardCharsets.UTF_8);
    }
}

