/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.acs.commons.reports.models;

import com.adobe.acs.commons.reports.api.ReportCellCSVExporter;
import com.day.cq.tagging.TagManager;
import java.util.ArrayList;
import javax.inject.Inject;
import org.apache.commons.lang3.StringUtils;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.models.annotations.Model;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Model(adaptables={Resource.class})
public class TagReportCellCSVExporter
implements ReportCellCSVExporter {
    private static final Logger log = LoggerFactory.getLogger(TagReportCellCSVExporter.class);
    @Inject
    private String property;

    @Override
    public String getValue(Object result) {
        Resource resource = (Resource)result;
        TagManager tagMgr = (TagManager)resource.getResourceResolver().adaptTo(TagManager.class);
        log.debug("Loading tags from {}@{}", (Object)resource.getPath(), (Object)this.property);
        ArrayList<String> tags = new ArrayList<String>();
        String[] values = (String[])resource.getValueMap().get(this.property, String[].class);
        if (values != null) {
            for (String value : values) {
                tags.add(tagMgr.resolve(value).getTitle());
            }
        }
        log.debug("Loaded {} tags", tags);
        return StringUtils.join(tags, (String)";");
    }
}

