/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.acs.commons.rewriter.impl;

import com.adobe.acs.commons.rewriter.AbstractTransformer;
import com.adobe.acs.commons.util.ParameterUtil;
import java.util.Dictionary;
import java.util.HashMap;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang.ArrayUtils;
import org.apache.commons.lang.StringEscapeUtils;
import org.apache.felix.scr.annotations.Activate;
import org.apache.felix.scr.annotations.Component;
import org.apache.felix.scr.annotations.ConfigurationPolicy;
import org.apache.felix.scr.annotations.Properties;
import org.apache.felix.scr.annotations.Property;
import org.apache.felix.scr.annotations.PropertyUnbounded;
import org.apache.felix.scr.annotations.Service;
import org.apache.sling.commons.osgi.PropertiesUtil;
import org.apache.sling.rewriter.Transformer;
import org.apache.sling.rewriter.TransformerFactory;
import org.osgi.service.component.ComponentContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.AttributesImpl;

@Component(label="ACS AEM Commons - Static Reference Rewriter", description="Rewriter pipeline component which rewrites host name on static references for cookie-less domain support", metatype=true, configurationFactory=true, policy=ConfigurationPolicy.REQUIRE)
@Service
@Properties(value={@Property(name="pipeline.type", label="Rewriter Pipeline Type", description="Type identifier to be referenced in rewriter pipeline configuration."), @Property(name="webconsole.configurationFactory.nameHint", value={"Pipeline: {pipeline.type}"})})
public final class StaticReferenceRewriteTransformerFactory
implements TransformerFactory {
    private static final Logger log = LoggerFactory.getLogger(StaticReferenceRewriteTransformerFactory.class);
    private static final String ATTR_CLASS = "class";
    private static final String CLASS_NOSTATIC = "nostatic";
    private static final String[] DEFAULT_ATTRIBUTES = new String[]{"img:src", "link:href", "script:src"};
    private static final int DEFAULT_HOST_COUNT = 1;
    @Property(label="Rewrite Attributes", description="List of element/attribute pairs to rewrite", value={"img:src", "link:href", "script:src"})
    private static final String PROP_ATTRIBUTES = "attributes";
    @Property(label="Matching Patterns", description="List of patterns how to find url to prepend host to for more complex values. The url must be the first matching group within the pattern.")
    private static final String PROP_MATCHING_PATTERNS = "matchingPatterns";
    @Property(intValue={1}, label="Static Host Count", description="Number of static hosts available.")
    private static final String PROP_HOST_COUNT = "host.count";
    @Property(label="Static Host Pattern", description="Pattern for generating static host domain names. '{}' will be replaced with the host number. If more than one is provided, the host count is ignored.", unbounded=PropertyUnbounded.ARRAY)
    private static final String PROP_HOST_NAME_PATTERN = "host.pattern";
    @Property(unbounded=PropertyUnbounded.ARRAY, label="Path Prefixes", description="Path prefixes to rewrite.")
    private static final String PROP_PREFIXES = "prefixes";
    private Map<String, String[]> attributes;
    private Map<String, Pattern> matchingPatterns;
    private String[] prefixes;
    private int staticHostCount;
    private String[] staticHostPattern;
    private static final ShardNameProvider toStringShardNameProvider = new ShardNameProvider(){

        @Override
        public String lookup(int idx) {
            return Integer.toString(idx);
        }
    };
    private ShardNameProvider lookupShardNameProvider = new ShardNameProvider(){

        @Override
        public String lookup(int idx) {
            return StaticReferenceRewriteTransformerFactory.this.staticHostPattern[idx - 1];
        }
    };

    public Transformer createTransformer() {
        return new StaticReferenceRewriteTransformer();
    }

    private static String getShardValue(String filePath, int shardCount, ShardNameProvider sharder) {
        int result = 1;
        if (shardCount > 1) {
            int fileHash = (filePath.hashCode() & Integer.MAX_VALUE) % shardCount + 1;
            String hostNumberString = Integer.toString(fileHash);
            if (hostNumberString.length() >= 2) {
                Character c = Character.valueOf(hostNumberString.charAt(1));
                hostNumberString = c.toString();
                hostNumberString = Integer.toString(Integer.parseInt(hostNumberString, shardCount));
                result = Integer.parseInt(hostNumberString) + 1;
            } else {
                result = fileHash;
            }
        }
        return sharder.lookup(result);
    }

    private String prependHostName(String value) {
        if (this.staticHostPattern != null && this.staticHostPattern.length > 0) {
            String host;
            if (this.staticHostPattern.length == 1) {
                String hostNum = StaticReferenceRewriteTransformerFactory.getShardValue(value, this.staticHostCount, toStringShardNameProvider);
                host = this.staticHostPattern[0].replace("{}", hostNum);
            } else {
                host = StaticReferenceRewriteTransformerFactory.getShardValue(value, this.staticHostPattern.length, this.lookupShardNameProvider);
            }
            return String.format("//%s%s", host, value);
        }
        return value;
    }

    private Attributes rebuildAttributes(String elementName, Attributes attrs) {
        if (this.attributes.containsKey(elementName)) {
            String[] modifyableAttributes = this.attributes.get(elementName);
            boolean rewriteStatic = true;
            for (int i = 0; i < attrs.getLength(); ++i) {
                String attrValue;
                String attrName = attrs.getLocalName(i);
                if (!ATTR_CLASS.equals(attrName) || !(attrValue = attrs.getValue(i)).contains(CLASS_NOSTATIC)) continue;
                rewriteStatic = false;
            }
            if (rewriteStatic) {
                return this.rebuildAttributes(elementName, attrs, modifyableAttributes);
            }
        }
        return attrs;
    }

    private Attributes rebuildAttributes(String elementName, Attributes attrs, String[] modifyableAttributes) {
        AttributesImpl newAttrs = new AttributesImpl(attrs);
        for (int i = 0; i < newAttrs.getLength(); ++i) {
            String attrName = newAttrs.getLocalName(i);
            if (!ArrayUtils.contains((Object[])modifyableAttributes, (Object)attrName)) continue;
            String attrValue = newAttrs.getValue(i);
            String key = elementName + ":" + attrName;
            if (this.matchingPatterns.containsKey(key)) {
                Pattern matchingPattern = this.matchingPatterns.get(key);
                try {
                    newAttrs.setValue(i, this.handleMatchingPatternAttribute(matchingPattern, attrValue));
                }
                catch (Exception e) {
                    log.error("Could not perform replacement based on matching pattern", (Throwable)e);
                }
                continue;
            }
            for (String prefix : this.prefixes) {
                if (!attrValue.startsWith(prefix)) continue;
                newAttrs.setValue(i, this.prependHostName(attrValue));
            }
        }
        return newAttrs;
    }

    private String handleMatchingPatternAttribute(Pattern pattern, String attrValue) {
        String unescapedValue = StringEscapeUtils.unescapeHtml((String)attrValue);
        Matcher m = pattern.matcher(unescapedValue);
        StringBuffer sb = new StringBuffer(unescapedValue.length());
        block0: while (m.find()) {
            String url = m.group(1);
            for (String prefix : this.prefixes) {
                if (!url.startsWith(prefix)) continue;
                url = this.prependHostName(url);
                m.appendReplacement(sb, Matcher.quoteReplacement(url));
                continue block0;
            }
        }
        m.appendTail(sb);
        return sb.toString();
    }

    @Activate
    protected void activate(ComponentContext componentContext) {
        Dictionary properties = componentContext.getProperties();
        String[] attrProp = PropertiesUtil.toStringArray(properties.get(PROP_ATTRIBUTES), (String[])DEFAULT_ATTRIBUTES);
        this.attributes = ParameterUtil.toMap(attrProp, ":", ",");
        String[] matchingPatternsProp = PropertiesUtil.toStringArray(properties.get(PROP_MATCHING_PATTERNS));
        this.matchingPatterns = StaticReferenceRewriteTransformerFactory.initializeMatchingPatterns(matchingPatternsProp);
        this.prefixes = PropertiesUtil.toStringArray(properties.get(PROP_PREFIXES), (String[])new String[0]);
        this.staticHostPattern = PropertiesUtil.toStringArray(properties.get(PROP_HOST_NAME_PATTERN), null);
        this.staticHostCount = PropertiesUtil.toInteger(properties.get(PROP_HOST_COUNT), (int)1);
    }

    private static Map<String, Pattern> initializeMatchingPatterns(String[] matchingPatternsProp) {
        HashMap<String, Pattern> result = new HashMap<String, Pattern>();
        Map<String, String> map = ParameterUtil.toMap(matchingPatternsProp, ";");
        for (String key : map.keySet()) {
            String matchingPatternString = map.get(key);
            try {
                Pattern compiled = Pattern.compile(matchingPatternString);
                result.put(key, compiled);
            }
            catch (Exception e) {
                log.warn("Could not compile pattern {} for {}. Ignoring it", (Object)matchingPatternString, (Object)key);
            }
        }
        return result;
    }

    private static interface ShardNameProvider {
        public String lookup(int var1);
    }

    public final class StaticReferenceRewriteTransformer
    extends AbstractTransformer {
        @Override
        public void startElement(String namespaceURI, String localName, String qName, Attributes atts) throws SAXException {
            this.getContentHandler().startElement(namespaceURI, localName, qName, StaticReferenceRewriteTransformerFactory.this.rebuildAttributes(localName, atts));
        }
    }
}

