/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.acs.commons.search.impl;

import com.day.cq.search.Predicate;
import com.day.cq.search.eval.AbstractPredicateEvaluator;
import com.day.cq.search.eval.EvaluationContext;
import com.day.cq.search.eval.PredicateEvaluator;
import java.util.Map;
import javax.jcr.RepositoryException;
import javax.jcr.query.Row;
import org.apache.commons.lang.StringUtils;
import org.apache.felix.scr.annotations.Component;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(factory="com.day.cq.search.eval.PredicateEvaluator/nodeExists")
public class NodeExistsPredicateEvaluator
extends AbstractPredicateEvaluator
implements PredicateEvaluator {
    private static final Logger log = LoggerFactory.getLogger(NodeExistsPredicateEvaluator.class);
    public static final String OR = "or";
    public static final String EXISTS_REL_PATH = "exists";
    public static final String NOT_EXISTS_REL_PATH = "notexists";

    public final boolean canXpath(Predicate predicate, EvaluationContext context) {
        return false;
    }

    public final boolean canFilter(Predicate predicate, EvaluationContext context) {
        return !predicate.getParameters().isEmpty() && (predicate.getParameters().size() != 1 || predicate.getParameters().get(OR) == null);
    }

    public final boolean isFiltering(Predicate predicate, EvaluationContext context) {
        return this.canFilter(predicate, context);
    }

    public final boolean includes(Predicate predicate, Row row, EvaluationContext context) {
        boolean or = predicate.getBool(OR);
        if (log.isDebugEnabled()) {
            if (or) {
                log.debug("NodeExistsPredicatorEvaluator evaluating as [ OR ]");
            } else {
                log.debug("NodeExistsPredicatorEvaluator evaluating as [ AND ]");
            }
        }
        for (Map.Entry entry : predicate.getParameters().entrySet()) {
            boolean ruleIncludes = false;
            String operation = (String)entry.getKey();
            if (StringUtils.contains((String)operation, (String)"_")) {
                operation = StringUtils.substringAfterLast((String)((String)entry.getKey()), (String)"_");
            }
            try {
                if (EXISTS_REL_PATH.equals(operation)) {
                    ruleIncludes = row.getNode().hasNode((String)entry.getValue());
                } else if (NOT_EXISTS_REL_PATH.equals(operation)) {
                    ruleIncludes = !row.getNode().hasNode((String)entry.getValue());
                } else if (!OR.equals(operation)) {
                    log.debug("Invalid operation [ {} ]", (Object)operation);
                }
                if (or && ruleIncludes) {
                    if (log.isDebugEnabled()) {
                        log.debug("Including [ {} ] based on [ {}  -> {} ] as part of [ OR ]", new Object[]{row.getPath(), operation, entry.getValue()});
                    }
                    return true;
                }
                if (or || ruleIncludes) continue;
                if (log.isDebugEnabled()) {
                    log.debug("Excluding [ {} ] based on [ {}  -> {} ] as part of [ AND ]", new Object[]{row.getPath(), operation, entry.getValue()});
                }
                return false;
            }
            catch (RepositoryException e) {
                log.error("Unable to check if Node [ {} : {} ] via the nodeExists QueryBuilder predicate", (Object)new String[]{(String)entry.getKey(), (String)entry.getValue()}, (Object)e);
            }
        }
        if (or) {
            if (log.isDebugEnabled()) {
                try {
                    log.debug("Excluding [ {} ] based on NOT matching conditions as part of [ OR ]", (Object)row.getPath());
                }
                catch (RepositoryException e) {
                    log.error("Could not obtain path from for Result row in predicate evaluator", (Throwable)e);
                }
            }
            return false;
        }
        if (log.isDebugEnabled()) {
            try {
                log.debug("Include [ {} ] based on ALL matching conditions as part of [ AND ]", (Object)row.getPath());
            }
            catch (RepositoryException e) {
                log.error("Could not obtain path from for Result row in predicate evaluator", (Throwable)e);
            }
        }
        return true;
    }
}

