/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.acs.commons.users.impl;

import com.adobe.acs.commons.users.impl.AbstractAuthorizable;
import com.adobe.acs.commons.users.impl.EnsureAuthorizableException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.sling.commons.osgi.PropertiesUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Group
extends AbstractAuthorizable {
    private static final Logger log = LoggerFactory.getLogger(Group.class);
    private static final String PATH_GROUPS = "/home/groups";
    private final List<String> memberOf;
    private final List<String> membership = new ArrayList<String>();

    public Group(Map<String, Object> config) throws EnsureAuthorizableException {
        super(config);
        String[] memberOfArr = PropertiesUtil.toStringArray((Object)config.get("member-of"), (String[])new String[0]);
        this.memberOf = Arrays.asList(memberOfArr);
    }

    public List<String> getMemberOf() {
        return this.memberOf;
    }

    @Override
    public String getDefaultPath() {
        return PATH_GROUPS;
    }

    public void addMembership(String groupName) {
        this.membership.add(groupName);
    }

    public List<String> getMissingMemberOf() {
        return this.memberOf.stream().filter(group -> !this.membership.contains(group)).collect(Collectors.toList());
    }
}

